/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class ZipCompressAction
extends AbstractAction {
    private static final int BUF_SIZE = 8192;
    private final File source;
    private final File destination;
    private final boolean deleteSource;
    private final int level;

    public ZipCompressAction(File file, File file2, boolean bl2, int n2) {
        Objects.requireNonNull(file, "source");
        Objects.requireNonNull(file2, "destination");
        this.source = file;
        this.destination = file2;
        this.deleteSource = bl2;
        this.level = n2;
    }

    @Override
    public boolean execute() throws IOException {
        return ZipCompressAction.execute(this.source, this.destination, this.deleteSource, this.level);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean execute(File file, File file2, boolean bl2, int n2) throws IOException {
        block21: {
            FileInputStream fileInputStream;
            block22: {
                Object object;
                if (!file.exists()) return false;
                fileInputStream = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    block19: {
                        block20: {
                            Object object2;
                            object = new ZipOutputStream(new FileOutputStream(file2));
                            Throwable throwable2 = null;
                            try {
                                int n3;
                                ((ZipOutputStream)object).setLevel(n2);
                                object2 = new ZipEntry(file.getName());
                                ((ZipOutputStream)object).putNextEntry((ZipEntry)object2);
                                byte[] byArray = new byte[8192];
                                while ((n3 = fileInputStream.read(byArray)) != -1) {
                                    ((ZipOutputStream)object).write(byArray, 0, n3);
                                }
                                if (object == null) break block19;
                                if (throwable2 == null) break block20;
                            }
                            catch (Throwable throwable3) {
                                try {
                                    Throwable throwable5;
                                    Throwables.throwIfCritical(throwable3);
                                    throwable2 = throwable5 = throwable3;
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    if (object == null) throw throwable6;
                                    if (throwable2 == null) {
                                        ((ZipOutputStream)object).close();
                                        throw throwable6;
                                    }
                                    try {
                                        ((ZipOutputStream)object).close();
                                        throw throwable6;
                                    }
                                    catch (Throwable throwable4) {
                                        Throwables.throwIfCritical(throwable4);
                                        Throwable throwable8 = throwable4;
                                        throwable2.addSuppressed(throwable8);
                                        throw throwable6;
                                    }
                                }
                            }
                            try {
                                ((ZipOutputStream)object).close();
                            }
                            catch (Throwable throwable5) {
                                Throwables.throwIfCritical(throwable5);
                                object2 = throwable5;
                                throwable2.addSuppressed((Throwable)object2);
                            }
                            break block19;
                        }
                        ((ZipOutputStream)object).close();
                    }
                    if (fileInputStream == null) break block21;
                    if (throwable == null) break block22;
                }
                catch (Throwable throwable6) {
                    try {
                        Throwable throwable11;
                        Throwables.throwIfCritical(throwable6);
                        throwable = throwable11 = throwable6;
                        throw throwable11;
                    }
                    catch (Throwable throwable12) {
                        if (fileInputStream == null) throw throwable12;
                        if (throwable == null) {
                            fileInputStream.close();
                            throw throwable12;
                        }
                        try {
                            fileInputStream.close();
                            throw throwable12;
                        }
                        catch (Throwable throwable7) {
                            Throwables.throwIfCritical(throwable7);
                            Throwable throwable14 = throwable7;
                            throwable.addSuppressed(throwable14);
                            throw throwable12;
                        }
                    }
                }
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable8) {
                    Throwables.throwIfCritical(throwable8);
                    object = throwable8;
                    throwable.addSuppressed((Throwable)object);
                }
                break block21;
            }
            fileInputStream.close();
        }
        if (!bl2) return true;
        if (file.delete()) return true;
        LOGGER.warn("Unable to delete " + file.toString() + '.');
        return true;
    }

    @Override
    protected void reportException(Exception exception) {
        LOGGER.warn("Exception during compression of '" + this.source.toString() + "'.", (Throwable)exception);
    }

    public String toString() {
        return ZipCompressAction.class.getSimpleName() + '[' + this.source + " to " + this.destination + ", level=" + this.level + ", deleteSource=" + this.deleteSource + ']';
    }

    public File getSource() {
        return this.source;
    }

    public File getDestination() {
        return this.destination;
    }

    public boolean isDeleteSource() {
        return this.deleteSource;
    }

    public int getLevel() {
        return this.level;
    }
}

