/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Level;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.DefaultAsyncQueueFullPolicy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.EventRoute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class DiscardingAsyncQueueFullPolicy
extends DefaultAsyncQueueFullPolicy {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Level thresholdLevel;
    private final AtomicLong discardCount = new AtomicLong();

    public DiscardingAsyncQueueFullPolicy(Level level) {
        this.thresholdLevel = Objects.requireNonNull(level, "thresholdLevel");
    }

    @Override
    public EventRoute getRoute(long l2, Level level) {
        if (level.isLessSpecificThan(this.thresholdLevel)) {
            if (this.discardCount.getAndIncrement() == 0L) {
                LOGGER.warn("Async queue is full, discarding event with level {}. This message will only appear once; future events from {} are silently discarded until queue capacity becomes available.", (Object)level, (Object)this.thresholdLevel);
            }
            return EventRoute.DISCARD;
        }
        return super.getRoute(l2, level);
    }

    public static long getDiscardCount(AsyncQueueFullPolicy asyncQueueFullPolicy) {
        if (asyncQueueFullPolicy instanceof DiscardingAsyncQueueFullPolicy) {
            return ((DiscardingAsyncQueueFullPolicy)asyncQueueFullPolicy).discardCount.get();
        }
        return 0L;
    }

    public Level getThresholdLevel() {
        return this.thresholdLevel;
    }
}

