/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Integers;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Constants;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertiesUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum ThreadNameCachingStrategy {
    CACHED{

        @Override
        public String getThreadName() {
            String string = (String)THREADLOCAL_NAME.get();
            if (string == null) {
                string = Thread.currentThread().getName();
                THREADLOCAL_NAME.set(string);
            }
            return string;
        }
    }
    ,
    UNCACHED{

        @Override
        public String getThreadName() {
            return Thread.currentThread().getName();
        }
    };

    private static final StatusLogger LOGGER;
    private static final ThreadLocal<String> THREADLOCAL_NAME;
    static final ThreadNameCachingStrategy DEFAULT_STRATEGY;

    abstract String getThreadName();

    public static ThreadNameCachingStrategy create() {
        String string = PropertiesUtil.getProperties().getStringProperty("AsyncLogger.ThreadNameStrategy");
        try {
            ThreadNameCachingStrategy threadNameCachingStrategy = string != null ? ThreadNameCachingStrategy.valueOf(string) : DEFAULT_STRATEGY;
            LOGGER.debug("AsyncLogger.ThreadNameStrategy={} (user specified {}, default is {})", (Object)threadNameCachingStrategy.name(), (Object)string, (Object)DEFAULT_STRATEGY.name());
            return threadNameCachingStrategy;
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.debug("Using AsyncLogger.ThreadNameStrategy.{}: '{}' not valid: {}", (Object)DEFAULT_STRATEGY.name(), (Object)string, (Object)exception2.toString());
            return DEFAULT_STRATEGY;
        }
    }

    static boolean isAllocatingThreadGetName() {
        if (Constants.JAVA_MAJOR_VERSION == 8) {
            try {
                Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)_(\\d+)");
                Matcher matcher = pattern.matcher(System.getProperty("java.version"));
                if (matcher.matches()) {
                    return Integers.parseInt(matcher.group(3)) == 0 && Integers.parseInt(matcher.group(4)) < 102;
                }
                return true;
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                return true;
            }
        }
        return Constants.JAVA_MAJOR_VERSION < 8;
    }

    static {
        LOGGER = StatusLogger.getLogger();
        THREADLOCAL_NAME = new ThreadLocal();
        DEFAULT_STRATEGY = ThreadNameCachingStrategy.isAllocatingThreadGetName() ? CACHED : UNCACHED;
    }
}

