/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.PropertiesPlugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginValue;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup.StrSubstitutor;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.util.Objects;

@Plugin(name="property", category="Core", printObject=true)
public final class Property {
    public static final Property[] EMPTY_ARRAY = new Property[0];
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String name;
    private final String rawValue;
    private final String value;
    private final boolean valueNeedsLookup;

    private Property(String string, String string2, String string3) {
        this.name = string;
        this.rawValue = string2;
        this.value = string3;
        this.valueNeedsLookup = string3 != null && string3.contains("${");
    }

    public String getName() {
        return this.name;
    }

    public String getRawValue() {
        return Objects.toString(this.rawValue, "");
    }

    public String getValue() {
        return Objects.toString(this.value, "");
    }

    public boolean isValueNeedsLookup() {
        return this.valueNeedsLookup;
    }

    public String evaluate(StrSubstitutor strSubstitutor) {
        return this.valueNeedsLookup ? strSubstitutor.replace(PropertiesPlugin.unescape(this.getRawValue())) : this.getValue();
    }

    public static Property createProperty(String string, String string2) {
        return Property.createProperty(string, string2, string2);
    }

    public static Property createProperty(String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException("Property name cannot be null");
        }
        return new Property(string, string2, string3);
    }

    @PluginFactory
    public static Property createProperty(@PluginAttribute(value="name") String string, @PluginValue(value="value", substitute=false) String string2, @PluginConfiguration Configuration configuration) {
        return Property.createProperty(string, string2, configuration == null ? string2 : configuration.getStrSubstitutor().replace(string2));
    }

    public String toString() {
        return this.name + '=' + this.getValue();
    }
}

