/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.processor;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.javax.annotation.processing.AbstractProcessor;
import com.contrastsecurity.thirdparty.javax.annotation.processing.Messager;
import com.contrastsecurity.thirdparty.javax.annotation.processing.RoundEnvironment;
import com.contrastsecurity.thirdparty.javax.annotation.processing.SupportedAnnotationTypes;
import com.contrastsecurity.thirdparty.javax.lang.model.SourceVersion;
import com.contrastsecurity.thirdparty.javax.lang.model.element.Element;
import com.contrastsecurity.thirdparty.javax.lang.model.element.ElementVisitor;
import com.contrastsecurity.thirdparty.javax.lang.model.element.TypeElement;
import com.contrastsecurity.thirdparty.javax.lang.model.util.Elements;
import com.contrastsecurity.thirdparty.javax.lang.model.util.SimpleElementVisitor7;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAliases;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.processor.PluginCache;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.*"})
public class PluginProcessor
extends AbstractProcessor {
    private static final Element[] EMPTY_ELEMENT_ARRAY = new Element[0];
    public static final String PLUGIN_CACHE_FILE = "META-INF/com/contrastsecurity/thirdparty/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat";
    private final PluginCache pluginCache = new PluginCache();

    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Messager messager = this.processingEnv.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, (CharSequence)"Processing Log4j annotations");
        try {
            Set set2 = roundEnvironment.getElementsAnnotatedWith(Plugin.class);
            if (set2.isEmpty()) {
                messager.printMessage(Diagnostic.Kind.NOTE, (CharSequence)"No elements to process");
                return false;
            }
            this.collectPlugins(set2);
            this.writeCacheFile(set2.toArray(EMPTY_ELEMENT_ARRAY));
            messager.printMessage(Diagnostic.Kind.NOTE, (CharSequence)"Annotations processed");
            return true;
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            exception2.printStackTrace();
            this.error(exception2.getMessage());
            return false;
        }
    }

    private void error(CharSequence charSequence) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, charSequence);
    }

    private void collectPlugins(Iterable<? extends Element> iterable) {
        Elements elements = this.processingEnv.getElementUtils();
        PluginElementVisitor pluginElementVisitor = new PluginElementVisitor(elements);
        PluginAliasesElementVisitor pluginAliasesElementVisitor = new PluginAliasesElementVisitor(elements);
        for (Element element : iterable) {
            Plugin plugin = (Plugin)element.getAnnotation(Plugin.class);
            if (plugin == null) continue;
            PluginEntry pluginEntry = (PluginEntry)element.accept((ElementVisitor)pluginElementVisitor, (Object)plugin);
            Map<String, PluginEntry> map = this.pluginCache.getCategory(pluginEntry.getCategory());
            map.put(pluginEntry.getKey(), pluginEntry);
            Collection collection = (Collection)element.accept((ElementVisitor)pluginAliasesElementVisitor, (Object)plugin);
            for (PluginEntry pluginEntry2 : collection) {
                map.put(pluginEntry2.getKey(), pluginEntry2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeCacheFile(Element ... elementArray) throws IOException {
        OutputStream outputStream;
        block9: {
            FileObject fileObject = this.processingEnv.getFiler().createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, (CharSequence)"", (CharSequence)PLUGIN_CACHE_FILE, elementArray);
            outputStream = fileObject.openOutputStream();
            Throwable throwable = null;
            try {
                this.pluginCache.writeCache(outputStream);
                if (outputStream == null) return;
                if (throwable == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable5;
                    Throwables.throwIfCritical(throwable2);
                    throwable = throwable5 = throwable2;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    if (outputStream == null) throw throwable6;
                    if (throwable == null) {
                        outputStream.close();
                        throw throwable6;
                    }
                    try {
                        outputStream.close();
                        throw throwable6;
                    }
                    catch (Throwable throwable3) {
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable8 = throwable3;
                        throwable.addSuppressed(throwable8);
                        throw throwable6;
                    }
                }
            }
            try {
                outputStream.close();
                return;
            }
            catch (Throwable throwable4) {
                Throwables.throwIfCritical(throwable4);
                Throwable throwable3 = throwable4;
                throwable.addSuppressed(throwable3);
                return;
            }
        }
        outputStream.close();
    }

    private static class PluginAliasesElementVisitor
    extends SimpleElementVisitor7<Collection<PluginEntry>, Plugin> {
        private final Elements elements;

        private PluginAliasesElementVisitor(Elements elements) {
            super(Collections.emptyList());
            this.elements = elements;
        }

        public Collection<PluginEntry> visitType(TypeElement typeElement, Plugin plugin) {
            PluginAliases pluginAliases = (PluginAliases)typeElement.getAnnotation(PluginAliases.class);
            if (pluginAliases == null) {
                return (Collection)this.DEFAULT_VALUE;
            }
            ArrayList<PluginEntry> arrayList = new ArrayList<PluginEntry>(pluginAliases.value().length);
            for (String string : pluginAliases.value()) {
                PluginEntry pluginEntry = new PluginEntry();
                pluginEntry.setKey(string.toLowerCase(Locale.US));
                pluginEntry.setClassName(this.elements.getBinaryName(typeElement).toString());
                pluginEntry.setName("".equals(plugin.elementType()) ? string : plugin.elementType());
                pluginEntry.setPrintable(plugin.printObject());
                pluginEntry.setDefer(plugin.deferChildren());
                pluginEntry.setCategory(plugin.category());
                arrayList.add(pluginEntry);
            }
            return arrayList;
        }
    }

    private static class PluginElementVisitor
    extends SimpleElementVisitor7<PluginEntry, Plugin> {
        private final Elements elements;

        private PluginElementVisitor(Elements elements) {
            this.elements = elements;
        }

        public PluginEntry visitType(TypeElement typeElement, Plugin plugin) {
            Objects.requireNonNull(plugin, "Plugin annotation is null.");
            PluginEntry pluginEntry = new PluginEntry();
            pluginEntry.setKey(plugin.name().toLowerCase(Locale.US));
            pluginEntry.setClassName(this.elements.getBinaryName(typeElement).toString());
            pluginEntry.setName("".equals(plugin.elementType()) ? plugin.name() : plugin.elementType());
            pluginEntry.setPrintable(plugin.printObject());
            pluginEntry.setDefer(plugin.deferChildren());
            pluginEntry.setCategory(plugin.category());
            return pluginEntry;
        }
    }
}

