/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.visitors;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginVisitorStrategy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.visitors.PluginVisitor;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.lang.annotation.Annotation;

public final class PluginVisitors {
    private static final Logger LOGGER = StatusLogger.getLogger();

    private PluginVisitors() {
    }

    public static PluginVisitor<? extends Annotation> findVisitor(Class<? extends Annotation> clazz) {
        PluginVisitorStrategy pluginVisitorStrategy = clazz.getAnnotation(PluginVisitorStrategy.class);
        if (pluginVisitorStrategy == null) {
            return null;
        }
        try {
            return pluginVisitorStrategy.value().newInstance();
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.error("Error loading PluginVisitor [{}] for annotation [{}].", (Object)pluginVisitorStrategy.value(), (Object)clazz, (Object)exception2);
            return null;
        }
    }
}

