/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.filter;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Level;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Marker;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.filter.AbstractFilter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.Message;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

@Plugin(name="BurstFilter", category="Core", elementType="filter", printObject=true)
public final class BurstFilter
extends AbstractFilter {
    private static final long NANOS_IN_SECONDS = 1000000000L;
    private static final int DEFAULT_RATE = 10;
    private static final int DEFAULT_RATE_MULTIPLE = 100;
    private static final int HASH_SHIFT = 32;
    private final Level level;
    private final long burstInterval;
    private final DelayQueue<LogDelay> history = new DelayQueue();
    private final Queue<LogDelay> available = new ConcurrentLinkedQueue<LogDelay>();

    static LogDelay createLogDelay(long l2) {
        return new LogDelay(l2);
    }

    private BurstFilter(Level level, float f2, long l2, Filter.Result result, Filter.Result result2) {
        super(result, result2);
        this.level = level;
        this.burstInterval = (long)(1.0E9f * ((float)l2 / f2));
        int n2 = 0;
        while ((long)n2 < l2) {
            this.available.add(BurstFilter.createLogDelay(0L));
            ++n2;
        }
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object ... objectArray) {
        return this.filter(level);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, Object object, Throwable throwable) {
        return this.filter(level);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, Message message, Throwable throwable) {
        return this.filter(level);
    }

    @Override
    public Filter.Result filter(LogEvent logEvent) {
        return this.filter(logEvent.getLevel());
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object) {
        return this.filter(level);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2) {
        return this.filter(level);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3) {
        return this.filter(level);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4) {
        return this.filter(level);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        return this.filter(level);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return this.filter(level);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return this.filter(level);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        return this.filter(level);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        return this.filter(level);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        return this.filter(level);
    }

    private Filter.Result filter(Level level) {
        if (this.level.isMoreSpecificThan(level)) {
            LogDelay logDelay = (LogDelay)this.history.poll();
            while (logDelay != null) {
                this.available.add(logDelay);
                logDelay = (LogDelay)this.history.poll();
            }
            logDelay = this.available.poll();
            if (logDelay != null) {
                logDelay.setDelay(this.burstInterval);
                this.history.add(logDelay);
                return this.onMatch;
            }
            return this.onMismatch;
        }
        return this.onMatch;
    }

    public int getAvailable() {
        return this.available.size();
    }

    public void clear() {
        for (LogDelay logDelay : this.history) {
            this.history.remove(logDelay);
            this.available.add(logDelay);
        }
    }

    @Override
    public String toString() {
        return "level=" + this.level.toString() + ", interval=" + this.burstInterval + ", max=" + this.history.size();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractFilter.AbstractFilterBuilder<Builder>
    implements com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder<BurstFilter> {
        @PluginBuilderAttribute
        private Level level = Level.WARN;
        @PluginBuilderAttribute
        private float rate = 10.0f;
        @PluginBuilderAttribute
        private long maxBurst;

        public Builder setLevel(Level level) {
            this.level = level;
            return this;
        }

        public Builder setRate(float f2) {
            this.rate = f2;
            return this;
        }

        public Builder setMaxBurst(long l2) {
            this.maxBurst = l2;
            return this;
        }

        @Override
        public BurstFilter build() {
            if (this.rate <= 0.0f) {
                this.rate = 10.0f;
            }
            if (this.maxBurst <= 0L) {
                this.maxBurst = (long)(this.rate * 100.0f);
            }
            return new BurstFilter(this.level, this.rate, this.maxBurst, this.getOnMatch(), this.getOnMismatch());
        }
    }

    private static class LogDelay
    implements Delayed {
        private long expireTime;

        LogDelay(long l2) {
            this.expireTime = l2;
        }

        public void setDelay(long l2) {
            this.expireTime = l2 + System.nanoTime();
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            return timeUnit.convert(this.expireTime - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            long l2 = this.expireTime - ((LogDelay)delayed).expireTime;
            return Long.signum(l2);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LogDelay logDelay = (LogDelay)object;
            return this.expireTime == logDelay.expireTime;
        }

        public int hashCode() {
            return (int)(this.expireTime ^ this.expireTime >>> 32);
        }
    }
}

