/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.filter;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.com.fasterxml.jackson.databind.DeserializationFeature;
import com.contrastsecurity.thirdparty.com.fasterxml.jackson.databind.ObjectMapper;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Level;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Marker;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationException;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationScheduler;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAliases;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.filter.AbstractFilter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.filter.ThreadContextMapFilter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.filter.mutable.KeyValuePairConfig;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.AuthorizationProvider;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.KeyValuePair;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.internal.HttpInputStreamUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.internal.LastModifiedSource;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.internal.Status;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.Message;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PerformanceSensitive;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertiesUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@Plugin(name="MutableThreadContextMapFilter", category="Core", elementType="filter", printObject=true)
@PluginAliases(value={"MutableContextMapFilter"})
@PerformanceSensitive(value={"allocation"})
public class MutableThreadContextMapFilter
extends AbstractFilter {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final KeyValuePair[] EMPTY_ARRAY = new KeyValuePair[0];
    private volatile Filter filter;
    private final long pollInterval;
    private final ConfigurationScheduler scheduler;
    private final LastModifiedSource source;
    private final AuthorizationProvider authorizationProvider;
    private final List<FilterConfigUpdateListener> listeners = new ArrayList<FilterConfigUpdateListener>();
    private ScheduledFuture<?> future = null;

    private MutableThreadContextMapFilter(Filter filter, LastModifiedSource lastModifiedSource, long l2, AuthorizationProvider authorizationProvider, Filter.Result result, Filter.Result result2, Configuration configuration) {
        super(result, result2);
        this.filter = filter;
        this.pollInterval = l2;
        this.source = lastModifiedSource;
        this.scheduler = configuration.getScheduler();
        this.authorizationProvider = authorizationProvider;
    }

    @Override
    public void start() {
        if (this.pollInterval > 0L) {
            this.future = this.scheduler.scheduleWithFixedDelay(new FileMonitor(), 0L, this.pollInterval, TimeUnit.SECONDS);
            LOGGER.debug("Watching {} with poll interval {}", (Object)this.source.toString(), (Object)this.pollInterval);
        }
        super.start();
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.future.cancel(true);
        return super.stop(l2, timeUnit);
    }

    public void registerListener(FilterConfigUpdateListener filterConfigUpdateListener) {
        this.listeners.add(filterConfigUpdateListener);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Filter.Result filter(LogEvent logEvent) {
        return this.filter.filter(logEvent);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, Message message, Throwable throwable) {
        return this.filter.filter(logger, level, marker, message, throwable);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, Object object, Throwable throwable) {
        return this.filter.filter(logger, level, marker, object, throwable);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object ... objectArray) {
        return this.filter.filter(logger, level, marker, string, objectArray);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object) {
        return this.filter.filter(logger, level, marker, string, object);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2) {
        return this.filter.filter(logger, level, marker, string, object, object2);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3) {
        return this.filter.filter(logger, level, marker, string, object, object2, object3);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4) {
        return this.filter.filter(logger, level, marker, string, object, object2, object3, object4);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        return this.filter.filter(logger, level, marker, string, object, object2, object3, object4, object5);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return this.filter.filter(logger, level, marker, string, object, object2, object3, object4, object5, object6);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return this.filter.filter(logger, level, marker, string, object, object2, object3, object4, object5, object6, object7);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        return this.filter.filter(logger, level, marker, string, object, object2, object3, object4, object5, object6, object7, object8);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        return this.filter.filter(logger, level, marker, string, object, object2, object3, object4, object5, object6, object7, object8, object9);
    }

    @Override
    public Filter.Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        return this.filter.filter(logger, level, marker, string, object, object2, object3, object4, object5, object6, object7, object8, object9, object10);
    }

    private static LastModifiedSource getSource(String string) {
        LastModifiedSource lastModifiedSource = null;
        try {
            URI uRI = new URI(string);
            lastModifiedSource = uRI.getScheme() != null ? new LastModifiedSource(new URI(string)) : new LastModifiedSource(new File(string));
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            lastModifiedSource = new LastModifiedSource(new File(string));
        }
        return lastModifiedSource;
    }

    private static ConfigResult getConfig(LastModifiedSource lastModifiedSource, AuthorizationProvider authorizationProvider) {
        ConfigResult configResult;
        block22: {
            HttpInputStreamUtil.Result result;
            InputStream inputStream;
            block21: {
                File file = lastModifiedSource.getFile();
                inputStream = null;
                result = null;
                long l2 = lastModifiedSource.getLastModified();
                if (file != null && file.exists()) {
                    try {
                        long l3 = file.lastModified();
                        if (l3 > l2) {
                            lastModifiedSource.setLastModified(l3);
                            inputStream = new FileInputStream(file);
                            result = new HttpInputStreamUtil.Result(Status.SUCCESS);
                            break block21;
                        }
                        result = new HttpInputStreamUtil.Result(Status.NOT_MODIFIED);
                    }
                    catch (Exception exception) {
                        Throwables.throwIfCritical(exception);
                        Exception exception2 = exception;
                        result = new HttpInputStreamUtil.Result(Status.ERROR);
                    }
                } else if (lastModifiedSource.getURI() != null) {
                    try {
                        result = HttpInputStreamUtil.getInputStream(lastModifiedSource, authorizationProvider);
                        inputStream = result.getInputStream();
                    }
                    catch (ConfigurationException configurationException) {
                        result = new HttpInputStreamUtil.Result(Status.ERROR);
                    }
                } else {
                    result = new HttpInputStreamUtil.Result(Status.NOT_FOUND);
                }
            }
            configResult = new ConfigResult();
            if (result.getStatus() == Status.SUCCESS) {
                LOGGER.debug("Processing Debug key/value pairs from: {}", (Object)lastModifiedSource.toString());
                try {
                    KeyValuePairConfig keyValuePairConfig = (KeyValuePairConfig)MAPPER.readValue(inputStream, KeyValuePairConfig.class);
                    if (keyValuePairConfig != null) {
                        Map<String, String[]> map = keyValuePairConfig.getConfigs();
                        if (map != null && map.size() > 0) {
                            ArrayList<KeyValuePair> arrayList = new ArrayList<KeyValuePair>();
                            for (Map.Entry<String, String[]> entry : map.entrySet()) {
                                String string = entry.getKey();
                                for (String string2 : entry.getValue()) {
                                    if (string2 != null) {
                                        arrayList.add(new KeyValuePair(string, string2));
                                        continue;
                                    }
                                    LOGGER.warn("Ignoring null value for {}", (Object)string);
                                }
                            }
                            if (arrayList.size() > 0) {
                                configResult.pairs = arrayList.toArray(EMPTY_ARRAY);
                                configResult.status = Status.SUCCESS;
                            } else {
                                configResult.status = Status.EMPTY;
                            }
                        } else {
                            LOGGER.debug("No configuration data in {}", (Object)lastModifiedSource.toString());
                            configResult.status = Status.EMPTY;
                        }
                        break block22;
                    }
                    LOGGER.warn("No configs element in MutableThreadContextMapFilter configuration");
                    configResult.status = Status.ERROR;
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    Exception exception3 = exception;
                    LOGGER.warn("Invalid key/value pair configuration, input ignored: {}", (Object)exception3.getMessage());
                    configResult.status = Status.ERROR;
                }
            } else {
                configResult.status = result.getStatus();
            }
        }
        return configResult;
    }

    private static class ConfigResult
    extends HttpInputStreamUtil.Result {
        public KeyValuePair[] pairs;
        public Status status;

        private ConfigResult() {
        }
    }

    public static interface FilterConfigUpdateListener {
        public void onEvent();
    }

    private static class NoOpFilter
    extends AbstractFilter {
        public NoOpFilter() {
            super(Filter.Result.NEUTRAL, Filter.Result.NEUTRAL);
        }
    }

    private class FileMonitor
    implements Runnable {
        private FileMonitor() {
        }

        @Override
        public void run() {
            ConfigResult configResult = MutableThreadContextMapFilter.getConfig(MutableThreadContextMapFilter.this.source, MutableThreadContextMapFilter.this.authorizationProvider);
            if (configResult.status == Status.SUCCESS) {
                MutableThreadContextMapFilter.this.filter = ThreadContextMapFilter.createFilter(configResult.pairs, "or", MutableThreadContextMapFilter.this.getOnMatch(), MutableThreadContextMapFilter.this.getOnMismatch());
                LOGGER.info("Filter configuration was updated: {}", (Object)MutableThreadContextMapFilter.this.filter.toString());
                for (FilterConfigUpdateListener filterConfigUpdateListener : MutableThreadContextMapFilter.this.listeners) {
                    filterConfigUpdateListener.onEvent();
                }
            } else if (configResult.status == Status.NOT_FOUND) {
                if (!(MutableThreadContextMapFilter.this.filter instanceof NoOpFilter)) {
                    LOGGER.info("Filter configuration was removed");
                    MutableThreadContextMapFilter.this.filter = new NoOpFilter();
                    for (FilterConfigUpdateListener filterConfigUpdateListener : MutableThreadContextMapFilter.this.listeners) {
                        filterConfigUpdateListener.onEvent();
                    }
                }
            } else if (configResult.status == Status.EMPTY) {
                LOGGER.debug("Filter configuration is empty");
                MutableThreadContextMapFilter.this.filter = new NoOpFilter();
            }
        }
    }

    public static class Builder
    extends AbstractFilter.AbstractFilterBuilder<Builder>
    implements com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder<MutableThreadContextMapFilter> {
        @PluginBuilderAttribute
        private String configLocation;
        @PluginBuilderAttribute
        private long pollInterval;
        @PluginConfiguration
        private Configuration configuration;

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setPollInterval(long l2) {
            this.pollInterval = l2;
            return this;
        }

        public Builder setConfigLocation(String string) {
            this.configLocation = string;
            return this;
        }

        @Override
        public MutableThreadContextMapFilter build() {
            AbstractFilter abstractFilter;
            LastModifiedSource lastModifiedSource = MutableThreadContextMapFilter.getSource(this.configLocation);
            if (lastModifiedSource == null) {
                return new MutableThreadContextMapFilter(new NoOpFilter(), null, 0L, null, this.getOnMatch(), this.getOnMismatch(), this.configuration);
            }
            AuthorizationProvider authorizationProvider = ConfigurationFactory.authorizationProvider(PropertiesUtil.getProperties());
            if (this.pollInterval <= 0L) {
                ConfigResult configResult = MutableThreadContextMapFilter.getConfig(lastModifiedSource, authorizationProvider);
                if (configResult.status == Status.SUCCESS) {
                    abstractFilter = configResult.pairs.length > 0 ? ThreadContextMapFilter.createFilter(configResult.pairs, "or", this.getOnMatch(), this.getOnMismatch()) : new NoOpFilter();
                } else if (configResult.status == Status.NOT_FOUND || configResult.status == Status.EMPTY) {
                    abstractFilter = new NoOpFilter();
                } else {
                    LOGGER.warn("Unexpected response returned on initial call: {}", (Object)configResult.status);
                    abstractFilter = new NoOpFilter();
                }
            } else {
                abstractFilter = new NoOpFilter();
            }
            if (this.pollInterval > 0L) {
                this.configuration.getScheduler().incrementScheduledItems();
            }
            return new MutableThreadContextMapFilter(abstractFilter, lastModifiedSource, this.pollInterval, authorizationProvider, this.getOnMatch(), this.getOnMismatch(), this.configuration);
        }
    }
}

