/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.jmx;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.LogManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Appender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LoggerContext;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AsyncAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.async.AsyncLoggerContext;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.LoggerConfig;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.Log4jContextFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.jmx.AppenderAdmin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.jmx.AsyncAppenderAdmin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.jmx.ContextSelectorAdmin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.jmx.LoggerConfigAdmin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.jmx.LoggerContextAdmin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.jmx.RingBufferAdmin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.jmx.StatusLoggerAdmin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.selector.ContextSelector;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Constants;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Log4jThreadFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.LoggerContextFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertiesUtil;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public final class Server {
    private static final String CONTEXT_NAME_ALL = "*";
    public static final String DOMAIN = "com.contrastsecurity.thirdparty.org.apache.logging.log4j2";
    private static final String PROPERTY_DISABLE_JMX = "com.contrastsecurity.thirdparty.log4j2.disable.jmx";
    private static final String PROPERTY_ASYNC_NOTIF = "com.contrastsecurity.thirdparty.log4j2.jmx.notify.async";
    private static final String THREAD_NAME_PREFIX = "jmx.notif";
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    static final Executor executor = Server.isJmxDisabled() ? null : Server.createExecutor();

    private Server() {
    }

    private static ExecutorService createExecutor() {
        boolean bl2 = !Constants.IS_WEB_APP;
        boolean bl3 = PropertiesUtil.getProperties().getBooleanProperty(PROPERTY_ASYNC_NOTIF, bl2);
        return bl3 ? Executors.newFixedThreadPool(1, Log4jThreadFactory.createDaemonThreadFactory(THREAD_NAME_PREFIX)) : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        boolean bl2 = false;
        block6: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\"': 
                case '*': 
                case '?': 
                case '\\': {
                    stringBuilder.append('\\');
                    bl2 = true;
                    break;
                }
                case ',': 
                case ':': 
                case '=': {
                    bl2 = true;
                    break;
                }
                case '\r': {
                    continue block6;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    bl2 = true;
                    continue block6;
                }
            }
            stringBuilder.append(c2);
        }
        if (bl2) {
            stringBuilder.insert(0, '\"');
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    private static boolean isJmxDisabled() {
        return PropertiesUtil.getProperties().getBooleanProperty(PROPERTY_DISABLE_JMX);
    }

    public static void reregisterMBeansAfterReconfigure() {
        if (Server.isJmxDisabled()) {
            LOGGER.debug("JMX disabled for Log4j2. Not registering MBeans.");
            return;
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Server.reregisterMBeansAfterReconfigure(mBeanServer);
    }

    public static void reregisterMBeansAfterReconfigure(MBeanServer mBeanServer) {
        if (Server.isJmxDisabled()) {
            LOGGER.debug("JMX disabled for Log4j2. Not registering MBeans.");
            return;
        }
        try {
            ContextSelector contextSelector = Server.getContextSelector();
            if (contextSelector == null) {
                LOGGER.debug("Could not register MBeans: no ContextSelector found.");
                return;
            }
            LOGGER.trace("Reregistering MBeans after reconfigure. Selector={}", (Object)contextSelector);
            List<LoggerContext> list = contextSelector.getLoggerContexts();
            int n2 = 0;
            for (LoggerContext loggerContext : list) {
                RingBufferAdmin ringBufferAdmin;
                LOGGER.trace("Reregistering context ({}/{}): '{}' {}", (Object)(++n2), (Object)list.size(), (Object)loggerContext.getName(), (Object)loggerContext);
                Server.unregisterLoggerContext(loggerContext.getName(), mBeanServer);
                LoggerContextAdmin loggerContextAdmin = new LoggerContextAdmin(loggerContext, executor);
                Server.register(mBeanServer, loggerContextAdmin, loggerContextAdmin.getObjectName());
                if (loggerContext instanceof AsyncLoggerContext && (ringBufferAdmin = ((AsyncLoggerContext)loggerContext).createRingBufferAdmin()).getBufferSize() > 0L) {
                    Server.register(mBeanServer, ringBufferAdmin, ringBufferAdmin.getObjectName());
                }
                Server.registerStatusLogger(loggerContext.getName(), mBeanServer, executor);
                Server.registerContextSelector(loggerContext.getName(), contextSelector, mBeanServer, executor);
                Server.registerLoggerConfigs(loggerContext, mBeanServer, executor);
                Server.registerAppenders(loggerContext, mBeanServer, executor);
            }
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.error("Could not register mbeans", (Throwable)exception2);
        }
    }

    public static void unregisterMBeans() {
        if (Server.isJmxDisabled()) {
            LOGGER.debug("JMX disabled for Log4j2. Not unregistering MBeans.");
            return;
        }
        Server.unregisterMBeans(ManagementFactory.getPlatformMBeanServer());
    }

    public static void unregisterMBeans(MBeanServer mBeanServer) {
        if (mBeanServer != null) {
            Server.unregisterStatusLogger(CONTEXT_NAME_ALL, mBeanServer);
            Server.unregisterContextSelector(CONTEXT_NAME_ALL, mBeanServer);
            Server.unregisterContexts(mBeanServer);
            Server.unregisterLoggerConfigs(CONTEXT_NAME_ALL, mBeanServer);
            Server.unregisterAsyncLoggerRingBufferAdmins(CONTEXT_NAME_ALL, mBeanServer);
            Server.unregisterAsyncLoggerConfigRingBufferAdmins(CONTEXT_NAME_ALL, mBeanServer);
            Server.unregisterAppenders(CONTEXT_NAME_ALL, mBeanServer);
            Server.unregisterAsyncAppenders(CONTEXT_NAME_ALL, mBeanServer);
        }
    }

    private static ContextSelector getContextSelector() {
        LoggerContextFactory loggerContextFactory = LogManager.getFactory();
        if (loggerContextFactory instanceof Log4jContextFactory) {
            ContextSelector contextSelector = ((Log4jContextFactory)loggerContextFactory).getSelector();
            return contextSelector;
        }
        return null;
    }

    public static void unregisterLoggerContext(String string) {
        if (Server.isJmxDisabled()) {
            LOGGER.debug("JMX disabled for Log4j2. Not unregistering MBeans.");
            return;
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Server.unregisterLoggerContext(string, mBeanServer);
    }

    public static void unregisterLoggerContext(String string, MBeanServer mBeanServer) {
        String string2 = String.format("com.contrastsecurity.thirdparty.org.apache.logging.log4j2:type=%s", Server.escape(string), CONTEXT_NAME_ALL);
        Server.unregisterAllMatching(string2, mBeanServer);
        Server.unregisterStatusLogger(string, mBeanServer);
        Server.unregisterContextSelector(string, mBeanServer);
        Server.unregisterLoggerConfigs(string, mBeanServer);
        Server.unregisterAppenders(string, mBeanServer);
        Server.unregisterAsyncAppenders(string, mBeanServer);
        Server.unregisterAsyncLoggerRingBufferAdmins(string, mBeanServer);
        Server.unregisterAsyncLoggerConfigRingBufferAdmins(string, mBeanServer);
    }

    private static void registerStatusLogger(String string, MBeanServer mBeanServer, Executor executor) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        StatusLoggerAdmin statusLoggerAdmin = new StatusLoggerAdmin(string, executor);
        Server.register(mBeanServer, statusLoggerAdmin, statusLoggerAdmin.getObjectName());
    }

    private static void registerContextSelector(String string, ContextSelector contextSelector, MBeanServer mBeanServer, Executor executor) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ContextSelectorAdmin contextSelectorAdmin = new ContextSelectorAdmin(string, contextSelector);
        Server.register(mBeanServer, contextSelectorAdmin, contextSelectorAdmin.getObjectName());
    }

    private static void unregisterStatusLogger(String string, MBeanServer mBeanServer) {
        String string2 = String.format("com.contrastsecurity.thirdparty.org.apache.logging.log4j2:type=%s,component=StatusLogger", Server.escape(string), CONTEXT_NAME_ALL);
        Server.unregisterAllMatching(string2, mBeanServer);
    }

    private static void unregisterContextSelector(String string, MBeanServer mBeanServer) {
        String string2 = String.format("com.contrastsecurity.thirdparty.org.apache.logging.log4j2:type=%s,component=ContextSelector", Server.escape(string), CONTEXT_NAME_ALL);
        Server.unregisterAllMatching(string2, mBeanServer);
    }

    private static void unregisterLoggerConfigs(String string, MBeanServer mBeanServer) {
        String string2 = "com.contrastsecurity.thirdparty.org.apache.logging.log4j2:type=%s,component=Loggers,name=%s";
        String string3 = String.format("com.contrastsecurity.thirdparty.org.apache.logging.log4j2:type=%s,component=Loggers,name=%s", Server.escape(string), CONTEXT_NAME_ALL);
        Server.unregisterAllMatching(string3, mBeanServer);
    }

    private static void unregisterContexts(MBeanServer mBeanServer) {
        String string = "com.contrastsecurity.thirdparty.org.apache.logging.log4j2:type=%s";
        String string2 = String.format("com.contrastsecurity.thirdparty.org.apache.logging.log4j2:type=%s", CONTEXT_NAME_ALL);
        Server.unregisterAllMatching(string2, mBeanServer);
    }

    private static void unregisterAppenders(String string, MBeanServer mBeanServer) {
        String string2 = "com.contrastsecurity.thirdparty.org.apache.logging.log4j2:type=%s,component=Appenders,name=%s";
        String string3 = String.format("com.contrastsecurity.thirdparty.org.apache.logging.log4j2:type=%s,component=Appenders,name=%s", Server.escape(string), CONTEXT_NAME_ALL);
        Server.unregisterAllMatching(string3, mBeanServer);
    }

    private static void unregisterAsyncAppenders(String string, MBeanServer mBeanServer) {
        String string2 = "com.contrastsecurity.thirdparty.org.apache.logging.log4j2:type=%s,component=AsyncAppenders,name=%s";
        String string3 = String.format("com.contrastsecurity.thirdparty.org.apache.logging.log4j2:type=%s,component=AsyncAppenders,name=%s", Server.escape(string), CONTEXT_NAME_ALL);
        Server.unregisterAllMatching(string3, mBeanServer);
    }

    private static void unregisterAsyncLoggerRingBufferAdmins(String string, MBeanServer mBeanServer) {
        String string2 = "com.contrastsecurity.thirdparty.org.apache.logging.log4j2:type=%s,component=AsyncLoggerRingBuffer";
        String string3 = String.format("com.contrastsecurity.thirdparty.org.apache.logging.log4j2:type=%s,component=AsyncLoggerRingBuffer", Server.escape(string));
        Server.unregisterAllMatching(string3, mBeanServer);
    }

    private static void unregisterAsyncLoggerConfigRingBufferAdmins(String string, MBeanServer mBeanServer) {
        String string2 = "com.contrastsecurity.thirdparty.org.apache.logging.log4j2:type=%s,component=Loggers,name=%s,subtype=RingBuffer";
        String string3 = String.format("com.contrastsecurity.thirdparty.org.apache.logging.log4j2:type=%s,component=Loggers,name=%s,subtype=RingBuffer", Server.escape(string), CONTEXT_NAME_ALL);
        Server.unregisterAllMatching(string3, mBeanServer);
    }

    private static void unregisterAllMatching(String string, MBeanServer mBeanServer) {
        try {
            ObjectName objectName = new ObjectName(string);
            Set<ObjectName> set = mBeanServer.queryNames(objectName, null);
            if (set == null || set.isEmpty()) {
                LOGGER.trace("Unregistering but no MBeans found matching '{}'", (Object)string);
            } else {
                LOGGER.trace("Unregistering {} MBeans: {}", (Object)set.size(), (Object)set);
            }
            if (set != null) {
                for (ObjectName objectName2 : set) {
                    mBeanServer.unregisterMBean(objectName2);
                }
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            LOGGER.debug("Could not unregister MBeans for " + string + ". Ignoring " + instanceNotFoundException);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.error("Could not unregister MBeans for " + string, (Throwable)exception2);
        }
    }

    private static void registerLoggerConfigs(LoggerContext loggerContext, MBeanServer mBeanServer, Executor executor) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        Map<String, LoggerConfig> map = loggerContext.getConfiguration().getLoggers();
        for (String string : map.keySet()) {
            LoggerConfig loggerConfig = map.get(string);
            LoggerConfigAdmin loggerConfigAdmin = new LoggerConfigAdmin(loggerContext, loggerConfig);
            Server.register(mBeanServer, loggerConfigAdmin, loggerConfigAdmin.getObjectName());
            if (!(loggerConfig instanceof AsyncLoggerConfig)) continue;
            AsyncLoggerConfig asyncLoggerConfig = (AsyncLoggerConfig)loggerConfig;
            RingBufferAdmin ringBufferAdmin = asyncLoggerConfig.createRingBufferAdmin(loggerContext.getName());
            Server.register(mBeanServer, ringBufferAdmin, ringBufferAdmin.getObjectName());
        }
    }

    private static void registerAppenders(LoggerContext loggerContext, MBeanServer mBeanServer, Executor executor) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        Map<String, Appender> map = loggerContext.getConfiguration().getAppenders();
        for (String string : map.keySet()) {
            Object object;
            Appender appender = map.get(string);
            if (appender instanceof AsyncAppender) {
                object = (AsyncAppender)appender;
                AsyncAppenderAdmin asyncAppenderAdmin = new AsyncAppenderAdmin(loggerContext.getName(), (AsyncAppender)object);
                Server.register(mBeanServer, asyncAppenderAdmin, asyncAppenderAdmin.getObjectName());
                continue;
            }
            object = new AppenderAdmin(loggerContext.getName(), appender);
            Server.register(mBeanServer, object, ((AppenderAdmin)object).getObjectName());
        }
    }

    private static void register(MBeanServer mBeanServer, Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (mBeanServer.isRegistered(objectName)) {
            try {
                mBeanServer.unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException jMException) {
                LOGGER.trace("Failed to unregister MBean {}", (Object)objectName);
            }
        }
        LOGGER.debug("Registering MBean {}", (Object)objectName);
        mBeanServer.registerMBean(object, objectName);
    }
}

