/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.ByteBufferDestination;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.Encoder;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.TextEncoderHelper;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Constants;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Objects;

public class StringBuilderEncoder
implements Encoder<StringBuilder> {
    private final ThreadLocal<Object[]> threadLocal = new ThreadLocal();
    private final Charset charset;
    private final int charBufferSize;
    private final int byteBufferSize;

    public StringBuilderEncoder(Charset charset) {
        this(charset, Constants.ENCODER_CHAR_BUFFER_SIZE, Constants.ENCODER_BYTE_BUFFER_SIZE);
    }

    public StringBuilderEncoder(Charset charset, int n2, int n3) {
        this.charBufferSize = n2;
        this.byteBufferSize = n3;
        this.charset = Objects.requireNonNull(charset, "charset");
    }

    @Override
    public void encode(StringBuilder stringBuilder, ByteBufferDestination byteBufferDestination) {
        try {
            Object[] objectArray = this.getThreadLocalState();
            CharsetEncoder charsetEncoder = (CharsetEncoder)objectArray[0];
            CharBuffer charBuffer = (CharBuffer)objectArray[1];
            ByteBuffer byteBuffer = (ByteBuffer)objectArray[2];
            TextEncoderHelper.encodeText(charsetEncoder, charBuffer, byteBuffer, stringBuilder, byteBufferDestination);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            StringBuilderEncoder.logEncodeTextException(exception2, stringBuilder);
            TextEncoderHelper.encodeTextFallBack(this.charset, stringBuilder, byteBufferDestination);
        }
    }

    private Object[] getThreadLocalState() {
        Object[] objectArray = this.threadLocal.get();
        if (objectArray == null) {
            objectArray = new Object[]{this.charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE), CharBuffer.allocate(this.charBufferSize), ByteBuffer.allocate(this.byteBufferSize)};
            this.threadLocal.set(objectArray);
        } else {
            ((CharsetEncoder)objectArray[0]).reset();
            ((CharBuffer)objectArray[1]).clear();
            ((ByteBuffer)objectArray[2]).clear();
        }
        return objectArray;
    }

    private static void logEncodeTextException(Exception exception, StringBuilder stringBuilder) {
        StatusLogger.getLogger().error("Recovering from StringBuilderEncoder.encode('{}') error: {}", (Object)stringBuilder, (Object)exception, (Object)exception);
    }
}

