/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.AbstractStringLayout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.Facility;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.Priority;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.NetUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Plugin(name="SyslogLayout", category="Core", elementType="layout", printObject=true)
public final class SyslogLayout
extends AbstractStringLayout {
    public static final Pattern NEWLINE_PATTERN = Pattern.compile("\\r?\\n");
    private final Facility facility;
    private final boolean includeNewLine;
    private final String escapeNewLine;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss", Locale.ENGLISH);
    private final String localHostname = NetUtils.getLocalHostname();

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    protected SyslogLayout(Facility facility, boolean bl2, String string, Charset charset) {
        super(charset);
        this.facility = facility;
        this.includeNewLine = bl2;
        this.escapeNewLine = string == null ? null : Matcher.quoteReplacement(string);
    }

    @Override
    public String toSerializable(LogEvent logEvent) {
        StringBuilder stringBuilder = SyslogLayout.getStringBuilder();
        stringBuilder.append('<');
        stringBuilder.append(Priority.getPriority(this.facility, logEvent.getLevel()));
        stringBuilder.append('>');
        this.addDate(logEvent.getTimeMillis(), stringBuilder);
        stringBuilder.append(' ');
        stringBuilder.append(this.localHostname);
        stringBuilder.append(' ');
        String string = logEvent.getMessage().getFormattedMessage();
        if (null != this.escapeNewLine) {
            string = NEWLINE_PATTERN.matcher(string).replaceAll(this.escapeNewLine);
        }
        stringBuilder.append(string);
        if (this.includeNewLine) {
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private synchronized void addDate(long l2, StringBuilder stringBuilder) {
        int n2 = stringBuilder.length() + 4;
        stringBuilder.append(this.dateFormat.format(new Date(l2)));
        if (stringBuilder.charAt(n2) == '0') {
            stringBuilder.setCharAt(n2, ' ');
        }
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("structured", "false");
        hashMap.put("formatType", "logfilepatternreceiver");
        hashMap.put("dateFormat", this.dateFormat.toPattern());
        hashMap.put("format", "<LEVEL>TIMESTAMP PROP(HOSTNAME) MESSAGE");
        return hashMap;
    }

    @Deprecated
    public static SyslogLayout createLayout(Facility facility, boolean bl2, String string, Charset charset) {
        return new SyslogLayout(facility, bl2, string, charset);
    }

    public Facility getFacility() {
        return this.facility;
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractStringLayout.Builder<B>
    implements com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder<SyslogLayout> {
        @PluginBuilderAttribute
        private Facility facility = Facility.LOCAL0;
        @PluginBuilderAttribute(value="newLine")
        private boolean includeNewLine;
        @PluginBuilderAttribute(value="newLineEscape")
        private String escapeNL;

        public Builder() {
            this.setCharset(StandardCharsets.UTF_8);
        }

        @Override
        public SyslogLayout build() {
            return new SyslogLayout(this.facility, this.includeNewLine, this.escapeNL, this.getCharset());
        }

        public Facility getFacility() {
            return this.facility;
        }

        public boolean isIncludeNewLine() {
            return this.includeNewLine;
        }

        public String getEscapeNL() {
            return this.escapeNL;
        }

        public B setFacility(Facility facility) {
            this.facility = facility;
            return (B)((Builder)this.asBuilder());
        }

        public B setIncludeNewLine(boolean bl2) {
            this.includeNewLine = bl2;
            return (B)((Builder)this.asBuilder());
        }

        public B setEscapeNL(String string) {
            this.escapeNL = string;
            return (B)((Builder)this.asBuilder());
        }
    }
}

