/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup.LookupResult;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup.StrLookup;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class PropertiesLookup
implements StrLookup {
    private final Map<String, String> contextProperties;
    private final Map<String, ConfigurationPropertyResult> configurationProperties;

    public PropertiesLookup(Property[] propertyArray, Map<String, String> map) {
        this.contextProperties = map == null ? Collections.emptyMap() : map;
        this.configurationProperties = propertyArray == null ? Collections.emptyMap() : PropertiesLookup.createConfigurationPropertyMap(propertyArray);
    }

    public PropertiesLookup(Map<String, String> map) {
        this(Property.EMPTY_ARRAY, map);
    }

    @Override
    public String lookup(LogEvent logEvent, String string) {
        return this.lookup(string);
    }

    @Override
    public String lookup(String string) {
        LookupResult lookupResult = this.evaluate(string);
        return lookupResult == null ? null : lookupResult.value();
    }

    @Override
    public LookupResult evaluate(String string) {
        if (string == null) {
            return null;
        }
        LookupResult lookupResult = this.configurationProperties.get(string);
        if (lookupResult != null) {
            return lookupResult;
        }
        String string2 = this.contextProperties.get(string);
        return string2 == null ? null : new ContextPropertyResult(string2);
    }

    @Override
    public LookupResult evaluate(LogEvent logEvent, String string) {
        return this.evaluate(string);
    }

    public String toString() {
        return "PropertiesLookup{contextProperties=" + this.contextProperties + ", configurationProperties=" + this.configurationProperties + '}';
    }

    private static Map<String, ConfigurationPropertyResult> createConfigurationPropertyMap(Property[] propertyArray) {
        HashMap<String, ConfigurationPropertyResult> hashMap = new HashMap<String, ConfigurationPropertyResult>(propertyArray.length);
        for (Property property : propertyArray) {
            hashMap.put(property.getName(), new ConfigurationPropertyResult(property.getRawValue()));
        }
        return hashMap;
    }

    private static final class ContextPropertyResult
    implements LookupResult {
        private final String value;

        ContextPropertyResult(String string) {
            this.value = Objects.requireNonNull(string, "value is required");
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public boolean isLookupEvaluationAllowedInValue() {
            return false;
        }

        public String toString() {
            return "ContextPropertyResult{'" + this.value + "'}";
        }
    }

    private static final class ConfigurationPropertyResult
    implements LookupResult {
        private final String value;

        ConfigurationPropertyResult(String string) {
            this.value = Objects.requireNonNull(string, "value is required");
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public boolean isLookupEvaluationAllowedInValue() {
            return true;
        }

        public String toString() {
            return "ConfigurationPropertyResult{'" + this.value + "'}";
        }
    }
}

