/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net;

import com.contrastsecurity.agent.logging.log4j2.i;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AppenderLoggingException;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class DatagramOutputStream
extends OutputStream {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private static final int SHIFT_1 = 8;
    private static final int SHIFT_2 = 16;
    private static final int SHIFT_3 = 24;
    private i datagramSocket;
    private final InetAddress inetAddress;
    private final int port;
    private byte[] data;
    private final byte[] header;
    private final byte[] footer;

    public DatagramOutputStream(String string, int n2, byte[] byArray, byte[] byArray2) {
        this.port = n2;
        this.header = byArray;
        this.footer = byArray2;
        try {
            this.inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            String string2 = "Could not find host " + string;
            LOGGER.error(string2, (Throwable)unknownHostException);
            throw new AppenderLoggingException(string2, unknownHostException);
        }
        try {
            this.datagramSocket = new i();
        }
        catch (SocketException socketException) {
            String string3 = "Could not instantiate DatagramSocket to " + string;
            LOGGER.error(string3, (Throwable)socketException);
            throw new AppenderLoggingException(string3, socketException);
        }
    }

    @Override
    public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        this.copy(byArray, n2, n3);
    }

    @Override
    public synchronized void write(int n2) throws IOException {
        this.copy(new byte[]{(byte)(n2 >>> 24), (byte)(n2 >>> 16), (byte)(n2 >>> 8), (byte)n2}, 0, 4);
    }

    @Override
    public synchronized void write(byte[] byArray) throws IOException {
        this.copy(byArray, 0, byArray.length);
    }

    @Override
    public synchronized void flush() throws IOException {
        try {
            if (this.data != null && this.datagramSocket != null && this.inetAddress != null) {
                if (this.footer != null) {
                    this.copy(this.footer, 0, this.footer.length);
                }
                DatagramPacket datagramPacket = new DatagramPacket(this.data, this.data.length, this.inetAddress, this.port);
                this.datagramSocket.send(datagramPacket);
            }
        }
        finally {
            this.data = null;
            if (this.header != null) {
                this.copy(this.header, 0, this.header.length);
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.datagramSocket != null) {
            if (this.data != null) {
                this.flush();
            }
            this.datagramSocket.close();
            this.datagramSocket = null;
        }
    }

    private void copy(byte[] byArray, int n2, int n3) {
        int n4 = this.data == null ? 0 : this.data.length;
        byte[] byArray2 = new byte[n3 + n4];
        if (this.data != null) {
            System.arraycopy(this.data, 0, byArray2, 0, this.data.length);
        }
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        this.data = byArray2;
    }
}

