/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Level;

public enum Severity {
    EMERG(0),
    ALERT(1),
    CRITICAL(2),
    ERROR(3),
    WARNING(4),
    NOTICE(5),
    INFO(6),
    DEBUG(7);

    private final int code;

    private Severity(int n3) {
        this.code = n3;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isEqual(String string) {
        return this.name().equalsIgnoreCase(string);
    }

    public static Severity getSeverity(Level level) {
        switch (level.getStandardLevel()) {
            case ALL: {
                return DEBUG;
            }
            case TRACE: {
                return DEBUG;
            }
            case DEBUG: {
                return DEBUG;
            }
            case INFO: {
                return INFO;
            }
            case WARN: {
                return WARNING;
            }
            case ERROR: {
                return ERROR;
            }
            case FATAL: {
                return ALERT;
            }
            case OFF: {
                return EMERG;
            }
        }
        return DEBUG;
    }
}

