/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl.LaxHostnameVerifier;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl.SslConfigurationFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.AuthorizationProvider;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertiesUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Strings;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;

public class UrlConnectionFactory {
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final int connectTimeoutMillis = 60000;
    private static final int readTimeoutMillis = 60000;
    private static final String JSON = "application/json";
    private static final String XML = "application/xml";
    private static final String PROPERTIES = "text/x-java-properties";
    private static final String TEXT = "text/plain";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String JAR = "jar";
    private static final String DEFAULT_ALLOWED_PROTOCOLS = "https, file, jar";
    private static final String NO_PROTOCOLS = "_none";
    public static final String ALLOWED_PROTOCOLS = "com.contrastsecurity.thirdparty.log4j2.Configuration.allowedProtocols";

    public static <T extends URLConnection> T createConnection(URL uRL, long l2, SslConfiguration sslConfiguration, AuthorizationProvider authorizationProvider) throws IOException {
        URLConnection uRLConnection;
        PropertiesUtil propertiesUtil = PropertiesUtil.getProperties();
        List<String> list = Arrays.asList(Strings.splitList(propertiesUtil.getStringProperty(ALLOWED_PROTOCOLS, DEFAULT_ALLOWED_PROTOCOLS).toLowerCase(Locale.ROOT)));
        if (list.size() == 1 && NO_PROTOCOLS.equals(list.get(0))) {
            throw new ProtocolException("No external protocols have been enabled");
        }
        String string = uRL.getProtocol();
        if (string == null) {
            throw new ProtocolException("No protocol was specified on " + uRL.toString());
        }
        if (!list.contains(string)) {
            throw new ProtocolException("Protocol " + string + " has not been enabled as an allowed protocol");
        }
        if (uRL.getProtocol().equals(HTTP) || uRL.getProtocol().equals(HTTPS)) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            if (authorizationProvider != null) {
                authorizationProvider.addAuthorization(httpURLConnection);
            }
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setConnectTimeout(60000);
            httpURLConnection.setReadTimeout(60000);
            String[] stringArray = uRL.getFile().split("\\.");
            String string2 = stringArray[stringArray.length - 1].trim();
            String string3 = UrlConnectionFactory.isXml(string2) ? XML : (UrlConnectionFactory.isJson(string2) ? JSON : (UrlConnectionFactory.isProperties(string2) ? PROPERTIES : TEXT));
            httpURLConnection.setRequestProperty("Content-Type", string3);
            if (l2 > 0L) {
                httpURLConnection.setIfModifiedSince(l2);
            }
            if (uRL.getProtocol().equals(HTTPS) && sslConfiguration != null) {
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(sslConfiguration.getSslSocketFactory());
                if (!sslConfiguration.isVerifyHostName()) {
                    ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(LaxHostnameVerifier.INSTANCE);
                }
            }
            uRLConnection = httpURLConnection;
        } else if (uRL.getProtocol().equals(JAR)) {
            uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
        } else {
            uRLConnection = uRL.openConnection();
        }
        return (T)uRLConnection;
    }

    public static URLConnection createConnection(URL uRL) throws IOException {
        URLConnection uRLConnection = null;
        if (uRL.getProtocol().equals(HTTPS) || uRL.getProtocol().equals(HTTP)) {
            AuthorizationProvider authorizationProvider = ConfigurationFactory.authorizationProvider(PropertiesUtil.getProperties());
            uRLConnection = UrlConnectionFactory.createConnection(uRL, 0L, SslConfigurationFactory.getSslConfiguration(), authorizationProvider);
        } else {
            uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof JarURLConnection) {
                uRLConnection.setUseCaches(false);
            }
        }
        return uRLConnection;
    }

    private static boolean isXml(String string) {
        return string.equalsIgnoreCase("xml");
    }

    private static boolean isJson(String string) {
        return string.equalsIgnoreCase("json") || string.equalsIgnoreCase("jsn");
    }

    private static boolean isProperties(String string) {
        return string.equalsIgnoreCase("properties");
    }
}

