/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationSource;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl.MemoryPasswordProvider;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl.PasswordProvider;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl.SslConfigurationDefaults;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl.StoreConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl.StoreConfigurationException;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.NetUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Objects;

public class AbstractKeyStoreConfiguration
extends StoreConfiguration<KeyStore> {
    private final KeyStore keyStore;
    private final String keyStoreType;

    public AbstractKeyStoreConfiguration(String string, PasswordProvider passwordProvider, String string2) throws StoreConfigurationException {
        super(string, passwordProvider);
        this.keyStoreType = string2 == null ? SslConfigurationDefaults.KEYSTORE_TYPE : string2;
        this.keyStore = this.load();
    }

    @Deprecated
    public AbstractKeyStoreConfiguration(String string, char[] cArray, String string2) throws StoreConfigurationException {
        this(string, new MemoryPasswordProvider(cArray), string2);
    }

    @Deprecated
    public AbstractKeyStoreConfiguration(String string, String string2, String string3) throws StoreConfigurationException {
        this(string, new MemoryPasswordProvider(string2 == null ? null : string2.toCharArray()), string3);
    }

    /*
     * Loose catch block
     */
    @Override
    protected KeyStore load() throws StoreConfigurationException {
        String string = this.getLocation();
        char[] cArray = this.getPasswordAsCharArray();
        LOGGER.debug("Loading keystore from location {}", (Object)string);
        try {
            KeyStore keyStore;
            Throwable throwable;
            InputStream inputStream;
            block25: {
                block26: {
                    KeyStore keyStore2 = KeyStore.getInstance(this.keyStoreType);
                    if (string == null) {
                        if (this.keyStoreType.equalsIgnoreCase("JKS") || this.keyStoreType.equalsIgnoreCase("PKCS12")) {
                            throw new IOException("The location is null");
                        }
                        keyStore2.load(null, cArray);
                        LOGGER.debug("KeyStore successfully loaded");
                        KeyStore keyStore3 = keyStore2;
                        return keyStore3;
                    }
                    inputStream = this.openInputStream(string);
                    throwable = null;
                    keyStore2.load(inputStream, cArray);
                    LOGGER.debug("KeyStore successfully loaded from location {}", (Object)string);
                    keyStore = keyStore2;
                    if (inputStream == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        Throwables.throwIfCritical(throwable2);
                        Throwable throwable3 = throwable2;
                        throwable.addSuppressed(throwable3);
                    }
                    break block25;
                }
                inputStream.close();
            }
            return keyStore;
            catch (Throwable throwable4) {
                try {
                    try {
                        Throwable throwable5;
                        Throwables.throwIfCritical(throwable4);
                        throwable = throwable5 = throwable4;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        if (inputStream != null) {
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable7) {
                                    Throwables.throwIfCritical(throwable7);
                                    Throwable throwable8 = throwable7;
                                    throwable.addSuppressed(throwable8);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                        throw throwable6;
                    }
                }
                catch (CertificateException certificateException) {
                    LOGGER.error("No Provider supports a KeyStoreSpi implementation for the specified type {} for location {}", (Object)this.keyStoreType, (Object)string, (Object)certificateException);
                    throw new StoreConfigurationException(string, certificateException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    LOGGER.error("The algorithm used to check the integrity of the keystore cannot be found for location {}", (Object)string, (Object)noSuchAlgorithmException);
                    throw new StoreConfigurationException(string, noSuchAlgorithmException);
                }
                catch (KeyStoreException keyStoreException) {
                    LOGGER.error("KeyStoreException for location {}", (Object)string, (Object)keyStoreException);
                    throw new StoreConfigurationException(string, keyStoreException);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LOGGER.error("The keystore file {} is not found", (Object)string, (Object)fileNotFoundException);
                    throw new StoreConfigurationException(string, fileNotFoundException);
                }
                catch (IOException iOException) {
                    LOGGER.error("Something is wrong with the format of the keystore or the given password for location {}", (Object)string, (Object)iOException);
                    throw new StoreConfigurationException(string, iOException);
                }
            }
        }
        finally {
            if (cArray != null) {
                Arrays.fill(cArray, '\u0000');
            }
        }
    }

    private InputStream openInputStream(String string) {
        return ConfigurationSource.fromUri(NetUtils.toURI(string)).getInputStream();
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.keyStore == null ? 0 : this.keyStore.hashCode());
        n3 = 31 * n3 + (this.keyStoreType == null ? 0 : this.keyStoreType.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractKeyStoreConfiguration abstractKeyStoreConfiguration = (AbstractKeyStoreConfiguration)object;
        if (!Objects.equals(this.keyStore, abstractKeyStoreConfiguration.keyStore)) {
            return false;
        }
        return Objects.equals(this.keyStoreType, abstractKeyStoreConfiguration.keyStoreType);
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }
}

