/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.util.PluginType;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.AnsiConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.ConverterKeys;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.ExtendedThrowablePatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.FormattingInfo;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.LiteralPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.NanoTimePatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.PatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.PatternFormatter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.SimpleLiteralPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.SystemNanoClock;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Strings;
import java.io.Serializable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class PatternParser {
    static final String DISABLE_ANSI = "disableAnsi";
    static final String NO_CONSOLE_NO_ANSI = "noConsoleNoAnsi";
    private static final char ESCAPE_CHAR = '%';
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int BUF_SIZE = 32;
    private static final int DECIMAL = 10;
    private final Configuration config;
    private final Map<String, Class<PatternConverter>> converterRules;

    public PatternParser(String string) {
        this(null, string, null, null);
    }

    public PatternParser(Configuration configuration, String string, Class<?> clazz) {
        this(configuration, string, clazz, null);
    }

    public PatternParser(Configuration configuration, String string, Class<?> clazz, Class<?> clazz2) {
        this.config = configuration;
        PluginManager pluginManager = new PluginManager(string);
        pluginManager.collectPlugins(configuration == null ? null : configuration.getPluginPackages());
        Map<String, PluginType<?>> map = pluginManager.getPlugins();
        LinkedHashMap<String, Class<PatternConverter>> linkedHashMap = new LinkedHashMap<String, Class<PatternConverter>>();
        for (PluginType<?> pluginType : map.values()) {
            Serializable serializable;
            try {
                ConverterKeys converterKeys;
                serializable = pluginType.getPluginClass();
                if (clazz2 != null && !clazz2.isAssignableFrom((Class<?>)serializable) || (converterKeys = ((Class)serializable).getAnnotation(ConverterKeys.class)) == null) continue;
                for (String string2 : converterKeys.value()) {
                    if (linkedHashMap.containsKey(string2)) {
                        LOGGER.warn("Converter key '{}' is already mapped to '{}'. Sorry, Dave, I can't let you do that! Ignoring plugin [{}].", (Object)string2, linkedHashMap.get(string2), (Object)serializable);
                        continue;
                    }
                    linkedHashMap.put(string2, (Class<PatternConverter>)serializable);
                }
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                serializable = exception;
                LOGGER.error("Error processing plugin " + pluginType.getElementName(), (Throwable)serializable);
            }
        }
        this.converterRules = linkedHashMap;
    }

    public List<PatternFormatter> parse(String string) {
        return this.parse(string, false, false, false);
    }

    public List<PatternFormatter> parse(String string, boolean bl2, boolean bl3) {
        return this.parse(string, bl2, false, bl3);
    }

    public List<PatternFormatter> parse(String string, boolean bl2, boolean bl3, boolean bl4) {
        ArrayList<PatternFormatter> arrayList = new ArrayList<PatternFormatter>();
        ArrayList<PatternConverter> arrayList2 = new ArrayList<PatternConverter>();
        ArrayList<FormattingInfo> arrayList3 = new ArrayList<FormattingInfo>();
        this.parse(string, arrayList2, arrayList3, bl3, bl4, true);
        Iterator iterator = arrayList3.iterator();
        boolean bl5 = false;
        for (PatternConverter patternConverter : arrayList2) {
            LogEventPatternConverter logEventPatternConverter;
            if (patternConverter instanceof NanoTimePatternConverter && this.config != null) {
                this.config.setNanoClock(new SystemNanoClock());
            }
            if (patternConverter instanceof LogEventPatternConverter) {
                logEventPatternConverter = (LogEventPatternConverter)patternConverter;
                bl5 |= logEventPatternConverter.handlesThrowable();
            } else {
                logEventPatternConverter = SimpleLiteralPatternConverter.of("");
            }
            FormattingInfo formattingInfo = iterator.hasNext() ? (FormattingInfo)iterator.next() : FormattingInfo.getDefault();
            arrayList.add(new PatternFormatter(logEventPatternConverter, formattingInfo));
        }
        if (bl2 && !bl5) {
            ExtendedThrowablePatternConverter extendedThrowablePatternConverter = ExtendedThrowablePatternConverter.newInstance(this.config, null);
            arrayList.add(new PatternFormatter(extendedThrowablePatternConverter, FormattingInfo.getDefault()));
        }
        return arrayList;
    }

    private static int extractConverter(char c2, String string, int n2, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        int n3;
        stringBuilder.setLength(0);
        if (!Character.isUnicodeIdentifierStart(c2)) {
            return n3;
        }
        stringBuilder.append(c2);
        for (n3 = n2; n3 < string.length() && Character.isUnicodeIdentifierPart(string.charAt(n3)); ++n3) {
            stringBuilder.append(string.charAt(n3));
            stringBuilder2.append(string.charAt(n3));
        }
        return n3;
    }

    private static int extractOptions(String string, int n2, List<String> list) {
        int n3 = n2;
        while (n3 < string.length() && string.charAt(n3) == '{') {
            int n4 = ++n3;
            int n5 = 1;
            while (n5 > 0 && n3 < string.length()) {
                char c2 = string.charAt(n3);
                if (c2 == '{') {
                    ++n5;
                } else if (c2 == '}') {
                    --n5;
                }
                ++n3;
            }
            if (n5 > 0) {
                n3 = string.lastIndexOf(125);
                if (n3 == -1 || n3 < n2) {
                    return n4;
                }
                return n3 + 1;
            }
            list.add(string.substring(n4, n3 - 1));
        }
        return n3;
    }

    public void parse(String string, List<PatternConverter> list, List<FormattingInfo> list2, boolean bl2, boolean bl3) {
        this.parse(string, list, list2, false, bl2, bl3);
    }

    public void parse(String string, List<PatternConverter> list, List<FormattingInfo> list2, boolean bl2, boolean bl3, boolean bl4) {
        Objects.requireNonNull(string, "pattern");
        StringBuilder stringBuilder = new StringBuilder(32);
        int n2 = string.length();
        ParserState parserState = ParserState.LITERAL_STATE;
        int n3 = 0;
        FormattingInfo formattingInfo = FormattingInfo.getDefault();
        while (n3 < n2) {
            char c2 = string.charAt(n3++);
            block0 : switch (parserState) {
                case LITERAL_STATE: {
                    if (n3 == n2) {
                        stringBuilder.append(c2);
                        break;
                    }
                    if (c2 == '%') {
                        switch (string.charAt(n3)) {
                            case '%': {
                                stringBuilder.append(c2);
                                ++n3;
                                break block0;
                            }
                        }
                        if (stringBuilder.length() != 0) {
                            list.add(this.literalPattern(stringBuilder.toString(), bl4));
                            list2.add(FormattingInfo.getDefault());
                        }
                        stringBuilder.setLength(0);
                        stringBuilder.append(c2);
                        parserState = ParserState.CONVERTER_STATE;
                        formattingInfo = FormattingInfo.getDefault();
                        break;
                    }
                    stringBuilder.append(c2);
                    break;
                }
                case CONVERTER_STATE: {
                    stringBuilder.append(c2);
                    switch (c2) {
                        case '0': {
                            formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength(), formattingInfo.getMaxLength(), formattingInfo.isLeftTruncate(), true);
                            break block0;
                        }
                        case '-': {
                            formattingInfo = new FormattingInfo(true, formattingInfo.getMinLength(), formattingInfo.getMaxLength(), formattingInfo.isLeftTruncate(), formattingInfo.isZeroPad());
                            break block0;
                        }
                        case '.': {
                            parserState = ParserState.DOT_STATE;
                            break block0;
                        }
                    }
                    if (c2 >= '0' && c2 <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), c2 - 48, formattingInfo.getMaxLength(), formattingInfo.isLeftTruncate(), formattingInfo.isZeroPad());
                        parserState = ParserState.MIN_STATE;
                        break;
                    }
                    n3 = this.finalizeConverter(c2, string, n3, stringBuilder, formattingInfo, this.converterRules, list, list2, bl2, bl3, bl4);
                    parserState = ParserState.LITERAL_STATE;
                    formattingInfo = FormattingInfo.getDefault();
                    stringBuilder.setLength(0);
                    break;
                }
                case MIN_STATE: {
                    stringBuilder.append(c2);
                    if (c2 >= '0' && c2 <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength() * 10 + c2 - 48, formattingInfo.getMaxLength(), formattingInfo.isLeftTruncate(), formattingInfo.isZeroPad());
                        break;
                    }
                    if (c2 == '.') {
                        parserState = ParserState.DOT_STATE;
                        break;
                    }
                    n3 = this.finalizeConverter(c2, string, n3, stringBuilder, formattingInfo, this.converterRules, list, list2, bl2, bl3, bl4);
                    parserState = ParserState.LITERAL_STATE;
                    formattingInfo = FormattingInfo.getDefault();
                    stringBuilder.setLength(0);
                    break;
                }
                case DOT_STATE: {
                    stringBuilder.append(c2);
                    switch (c2) {
                        case '-': {
                            formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength(), formattingInfo.getMaxLength(), false, formattingInfo.isZeroPad());
                            break block0;
                        }
                    }
                    if (c2 >= '0' && c2 <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength(), c2 - 48, formattingInfo.isLeftTruncate(), formattingInfo.isZeroPad());
                        parserState = ParserState.MAX_STATE;
                        break;
                    }
                    LOGGER.error("Error occurred in position " + n3 + ".\n Was expecting digit, instead got char \"" + c2 + "\".");
                    parserState = ParserState.LITERAL_STATE;
                    break;
                }
                case MAX_STATE: {
                    stringBuilder.append(c2);
                    if (c2 >= '0' && c2 <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength(), formattingInfo.getMaxLength() * 10 + c2 - 48, formattingInfo.isLeftTruncate(), formattingInfo.isZeroPad());
                        break;
                    }
                    n3 = this.finalizeConverter(c2, string, n3, stringBuilder, formattingInfo, this.converterRules, list, list2, bl2, bl3, bl4);
                    parserState = ParserState.LITERAL_STATE;
                    formattingInfo = FormattingInfo.getDefault();
                    stringBuilder.setLength(0);
                }
            }
        }
        if (stringBuilder.length() != 0) {
            list.add(this.literalPattern(stringBuilder.toString(), bl4));
            list2.add(FormattingInfo.getDefault());
        }
    }

    private PatternConverter createConverter(String string, StringBuilder stringBuilder, Map<String, Class<PatternConverter>> map, List<String> list, boolean bl2, boolean bl3) {
        Object[] objectArray;
        String string2 = string;
        Class<PatternConverter> clazz = null;
        if (map == null) {
            LOGGER.error("Null rules for [" + string + ']');
            return null;
        }
        for (int i2 = string.length(); i2 > 0 && clazz == null; --i2) {
            string2 = string2.substring(0, i2);
            clazz = map.get(string2);
        }
        if (clazz == null) {
            LOGGER.error("Unrecognized format specifier [" + string + ']');
            return null;
        }
        if (AnsiConverter.class.isAssignableFrom(clazz)) {
            list.add("disableAnsi=" + bl2);
            list.add("noConsoleNoAnsi=" + bl3);
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        Method method = null;
        for (Method method2 : methodArray) {
            if (!Modifier.isStatic(method2.getModifiers()) || !method2.getDeclaringClass().equals(clazz) || !method2.getName().equals("newInstance") || !PatternParser.areValidNewInstanceParameters(method2.getParameterTypes())) continue;
            if (method == null) {
                method = method2;
                continue;
            }
            if (!method2.getReturnType().equals(method.getReturnType())) continue;
            LOGGER.error("Class " + clazz + " cannot contain multiple static newInstance methods");
            return null;
        }
        if (method == null) {
            LOGGER.error("Class " + clazz + " does not contain a static newInstance method");
            return null;
        }
        GenericDeclaration[] genericDeclarationArray = method.getParameterTypes();
        Object[] objectArray2 = objectArray = genericDeclarationArray.length > 0 ? new Object[genericDeclarationArray.length] : null;
        if (objectArray != null) {
            int n2 = 0;
            boolean bl4 = false;
            for (GenericDeclaration genericDeclaration : genericDeclarationArray) {
                if (((Class)genericDeclaration).isArray() && ((Class)genericDeclaration).getName().equals("[Ljava.lang.String;")) {
                    String[] stringArray;
                    objectArray[n2] = stringArray = list.toArray(Strings.EMPTY_ARRAY);
                } else if (((Class)genericDeclaration).isAssignableFrom(Configuration.class)) {
                    objectArray[n2] = this.config;
                } else {
                    LOGGER.error("Unknown parameter type " + ((Class)genericDeclaration).getName() + " for static newInstance method of " + clazz.getName());
                    bl4 = true;
                }
                ++n2;
            }
            if (bl4) {
                return null;
            }
        }
        try {
            Object object = method.invoke(null, objectArray);
            if (object instanceof PatternConverter) {
                stringBuilder.delete(0, stringBuilder.length() - (string.length() - string2.length()));
                return (PatternConverter)object;
            }
            LOGGER.warn("Class {} does not extend PatternConverter.", (Object)clazz.getName());
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.error("Error creating converter for " + string, (Throwable)exception2);
        }
        return null;
    }

    private static boolean areValidNewInstanceParameters(Class<?>[] classArray) {
        for (Class<Configuration> clazz : classArray) {
            if (clazz.isAssignableFrom(Configuration.class) || clazz.isArray() && "[Ljava.lang.String;".equals(clazz.getName())) continue;
            return false;
        }
        return true;
    }

    private int finalizeConverter(char c2, String string, int n2, StringBuilder stringBuilder, FormattingInfo formattingInfo, Map<String, Class<PatternConverter>> map, List<PatternConverter> list, List<FormattingInfo> list2, boolean bl2, boolean bl3, boolean bl4) {
        int n3 = n2;
        StringBuilder stringBuilder2 = new StringBuilder();
        n3 = PatternParser.extractConverter(c2, string, n3, stringBuilder2, stringBuilder);
        String string2 = stringBuilder2.toString();
        ArrayList<String> arrayList = new ArrayList<String>();
        n3 = PatternParser.extractOptions(string, n3, arrayList);
        PatternConverter patternConverter = this.createConverter(string2, stringBuilder, map, arrayList, bl2, bl3);
        if (patternConverter == null) {
            StringBuilder stringBuilder3;
            if (Strings.isEmpty(string2)) {
                stringBuilder3 = new StringBuilder("Empty conversion specifier starting at position ");
            } else {
                stringBuilder3 = new StringBuilder("Unrecognized conversion specifier [");
                stringBuilder3.append(string2);
                stringBuilder3.append("] starting at position ");
            }
            stringBuilder3.append(n3);
            stringBuilder3.append(" in conversion pattern.");
            LOGGER.error(stringBuilder3.toString());
            list.add(this.literalPattern(stringBuilder.toString(), bl4));
            list2.add(FormattingInfo.getDefault());
        } else {
            list.add(patternConverter);
            list2.add(formattingInfo);
            if (stringBuilder.length() > 0) {
                list.add(this.literalPattern(stringBuilder.toString(), bl4));
                list2.add(FormattingInfo.getDefault());
            }
        }
        stringBuilder.setLength(0);
        return n3;
    }

    private LogEventPatternConverter literalPattern(String string, boolean bl2) {
        if (this.config != null && LiteralPatternConverter.containsSubstitutionSequence(string)) {
            return new LiteralPatternConverter(this.config, string, bl2);
        }
        return SimpleLiteralPatternConverter.of(string, bl2);
    }

    private static enum ParserState {
        LITERAL_STATE,
        CONVERTER_STATE,
        DOT_STATE,
        MIN_STATE,
        MAX_STATE;

    }
}

