/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.ConverterKeys;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.UuidUtil;
import java.util.UUID;

@Plugin(name="UuidPatternConverter", category="Converter")
@ConverterKeys(value={"u", "uuid"})
public final class UuidPatternConverter
extends LogEventPatternConverter {
    private final boolean isRandom;

    private UuidPatternConverter(boolean bl2) {
        super("u", "uuid");
        this.isRandom = bl2;
    }

    public static UuidPatternConverter newInstance(String[] stringArray) {
        if (stringArray.length == 0) {
            return new UuidPatternConverter(false);
        }
        if (stringArray.length > 1 || !stringArray[0].equalsIgnoreCase("RANDOM") && !stringArray[0].equalsIgnoreCase("Time")) {
            LOGGER.error("UUID Pattern Converter only accepts a single option with the value \"RANDOM\" or \"TIME\"");
        }
        return new UuidPatternConverter(stringArray[0].equalsIgnoreCase("RANDOM"));
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        UUID uUID = this.isRandom ? UUID.randomUUID() : UuidUtil.getTimeBasedUuid();
        stringBuilder.append(uUID.toString());
    }
}

