/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.selector;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.javax.naming.NamingException;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LoggerContext;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.ContextAnchor;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.JndiManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.selector.NamedContextSelector;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class JndiContextSelector
implements NamedContextSelector {
    private static final LoggerContext CONTEXT = new LoggerContext("Default");
    private static final ConcurrentMap<String, LoggerContext> CONTEXT_MAP = new ConcurrentHashMap<String, LoggerContext>();
    private static final StatusLogger LOGGER = StatusLogger.getLogger();

    public JndiContextSelector() {
        if (!JndiManager.isJndiContextSelectorEnabled()) {
            throw new IllegalStateException("JNDI must be enabled by setting log4j2.enableJndiContextSelector=true");
        }
    }

    @Override
    public void shutdown(String string, ClassLoader classLoader, boolean bl2, boolean bl3) {
        String string2;
        LoggerContext loggerContext = ContextAnchor.THREAD_CONTEXT.get();
        if (loggerContext == null && (string2 = this.getContextName()) != null) {
            loggerContext = (LoggerContext)CONTEXT_MAP.get(string2);
        }
        if (loggerContext != null) {
            loggerContext.stop(50L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public boolean hasContext(String string, ClassLoader classLoader, boolean bl2) {
        LoggerContext loggerContext = ContextAnchor.THREAD_CONTEXT.get();
        if (loggerContext == null) {
            String string2 = this.getContextName();
            if (string2 == null) {
                return false;
            }
            loggerContext = (LoggerContext)CONTEXT_MAP.get(string2);
        }
        return loggerContext != null && loggerContext.isStarted();
    }

    @Override
    public LoggerContext getContext(String string, ClassLoader classLoader, boolean bl2) {
        return this.getContext(string, classLoader, bl2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LoggerContext getContext(String string, ClassLoader classLoader, boolean bl2, URI uRI) {
        LoggerContext loggerContext;
        String string2;
        block13: {
            LoggerContext loggerContext2 = ContextAnchor.THREAD_CONTEXT.get();
            if (loggerContext2 != null) {
                return loggerContext2;
            }
            string2 = null;
            try {
                JndiManager jndiManager;
                block14: {
                    jndiManager = JndiManager.getDefaultManager();
                    Throwable throwable = null;
                    try {
                        string2 = (String)jndiManager.lookup("java:comp/env/log4j/context-name");
                        if (jndiManager == null) break block13;
                        if (throwable == null) break block14;
                    }
                    catch (Throwable throwable2) {
                        try {
                            Throwable throwable5;
                            Throwables.throwIfCritical(throwable2);
                            throwable = throwable5 = throwable2;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (jndiManager == null) throw throwable6;
                            if (throwable == null) {
                                jndiManager.close();
                                throw throwable6;
                            }
                            try {
                                jndiManager.close();
                                throw throwable6;
                            }
                            catch (Throwable throwable3) {
                                Throwables.throwIfCritical(throwable3);
                                Throwable throwable8 = throwable3;
                                throwable.addSuppressed(throwable8);
                                throw throwable6;
                            }
                        }
                    }
                    try {
                        jndiManager.close();
                    }
                    catch (Throwable throwable4) {
                        Throwables.throwIfCritical(throwable4);
                        Throwable throwable3 = throwable4;
                        throwable.addSuppressed(throwable3);
                    }
                    break block13;
                }
                jndiManager.close();
            }
            catch (NamingException namingException) {
                LOGGER.error("Unable to lookup {}", (Object)"java:comp/env/log4j/context-name", (Object)namingException);
            }
        }
        if (string2 == null) {
            loggerContext = CONTEXT;
            return loggerContext;
        }
        loggerContext = this.locateContext(string2, null, uRI);
        return loggerContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getContextName() {
        String string = null;
        try {
            JndiManager jndiManager;
            block11: {
                jndiManager = JndiManager.getDefaultManager();
                Throwable throwable = null;
                try {
                    string = (String)jndiManager.lookup("java:comp/env/log4j/context-name");
                    if (jndiManager == null) return string;
                    if (throwable == null) break block11;
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable5;
                        Throwables.throwIfCritical(throwable2);
                        throwable = throwable5 = throwable2;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        if (jndiManager == null) throw throwable6;
                        if (throwable == null) {
                            jndiManager.close();
                            throw throwable6;
                        }
                        try {
                            jndiManager.close();
                            throw throwable6;
                        }
                        catch (Throwable throwable3) {
                            Throwables.throwIfCritical(throwable3);
                            Throwable throwable8 = throwable3;
                            throwable.addSuppressed(throwable8);
                            throw throwable6;
                        }
                    }
                }
                try {
                    jndiManager.close();
                    return string;
                }
                catch (Throwable throwable4) {
                    Throwables.throwIfCritical(throwable4);
                    Throwable throwable3 = throwable4;
                    throwable.addSuppressed(throwable3);
                    return string;
                }
            }
            jndiManager.close();
            return string;
        }
        catch (NamingException namingException) {
            LOGGER.error("Unable to lookup {}", (Object)"java:comp/env/log4j/context-name", (Object)namingException);
        }
        return string;
    }

    @Override
    public LoggerContext locateContext(String string, Object object, URI uRI) {
        if (string == null) {
            LOGGER.error("A context name is required to locate a LoggerContext");
            return null;
        }
        if (!CONTEXT_MAP.containsKey(string)) {
            LoggerContext loggerContext = new LoggerContext(string, object, uRI);
            CONTEXT_MAP.putIfAbsent(string, loggerContext);
        }
        return (LoggerContext)CONTEXT_MAP.get(string);
    }

    @Override
    public void removeContext(LoggerContext loggerContext) {
        for (Map.Entry entry : CONTEXT_MAP.entrySet()) {
            if (!((LoggerContext)entry.getValue()).equals(loggerContext)) continue;
            CONTEXT_MAP.remove(entry.getKey());
        }
    }

    @Override
    public boolean isClassLoaderDependent() {
        return false;
    }

    @Override
    public LoggerContext removeContext(String string) {
        return (LoggerContext)CONTEXT_MAP.remove(string);
    }

    @Override
    public List<LoggerContext> getLoggerContexts() {
        return Collections.unmodifiableList(new ArrayList(CONTEXT_MAP.values()));
    }
}

