/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.message;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.IndexedStringMap;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertiesUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.StringBuilderFormattable;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.StringBuilders;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;

enum MapMessageJsonFormatter {

    public static final int MAX_DEPTH = MapMessageJsonFormatter.readMaxDepth();
    private static final char DQUOTE = '\"';
    private static final char RBRACE = ']';
    private static final char LBRACE = '[';
    private static final char COMMA = ',';
    private static final char RCURLY = '}';
    private static final char LCURLY = '{';
    private static final char COLON = ':';

    private static int readMaxDepth() {
        int n2 = PropertiesUtil.getProperties().getIntegerProperty("com.contrastsecurity.thirdparty.log4j2.mapMessage.jsonFormatter.maxDepth", 8);
        if (n2 < 0) {
            throw new IllegalArgumentException("was expecting a positive maxDepth, found: " + n2);
        }
        return n2;
    }

    static void format(StringBuilder stringBuilder, Object object) {
        MapMessageJsonFormatter.format(stringBuilder, object, 0);
    }

    private static void format(StringBuilder stringBuilder, Object object, int n2) {
        if (n2 >= MAX_DEPTH) {
            throw new IllegalArgumentException("maxDepth has been exceeded");
        }
        if (object == null) {
            stringBuilder.append("null");
        } else if (object instanceof IndexedStringMap) {
            IndexedStringMap indexedStringMap = (IndexedStringMap)object;
            MapMessageJsonFormatter.formatIndexedStringMap(stringBuilder, indexedStringMap, n2);
        } else if (object instanceof Map) {
            Map map = (Map)object;
            MapMessageJsonFormatter.formatMap(stringBuilder, map, n2);
        } else if (object instanceof List) {
            List list = (List)object;
            MapMessageJsonFormatter.formatList(stringBuilder, list, n2);
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            MapMessageJsonFormatter.formatCollection(stringBuilder, collection, n2);
        } else if (object instanceof Number) {
            Number number = (Number)object;
            MapMessageJsonFormatter.formatNumber(stringBuilder, number);
        } else if (object instanceof Boolean) {
            boolean bl2 = (Boolean)object;
            MapMessageJsonFormatter.formatBoolean(stringBuilder, bl2);
        } else if (object instanceof StringBuilderFormattable) {
            StringBuilderFormattable stringBuilderFormattable = (StringBuilderFormattable)object;
            MapMessageJsonFormatter.formatFormattable(stringBuilder, stringBuilderFormattable);
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            MapMessageJsonFormatter.formatCharArray(stringBuilder, cArray);
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            MapMessageJsonFormatter.formatBooleanArray(stringBuilder, blArray);
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            MapMessageJsonFormatter.formatByteArray(stringBuilder, byArray);
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            MapMessageJsonFormatter.formatShortArray(stringBuilder, sArray);
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            MapMessageJsonFormatter.formatIntArray(stringBuilder, nArray);
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            MapMessageJsonFormatter.formatLongArray(stringBuilder, lArray);
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            MapMessageJsonFormatter.formatFloatArray(stringBuilder, fArray);
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            MapMessageJsonFormatter.formatDoubleArray(stringBuilder, dArray);
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            MapMessageJsonFormatter.formatObjectArray(stringBuilder, objectArray, n2);
        } else {
            MapMessageJsonFormatter.formatString(stringBuilder, object);
        }
    }

    private static void formatIndexedStringMap(StringBuilder stringBuilder, IndexedStringMap indexedStringMap, int n2) {
        stringBuilder.append('{');
        int n3 = n2 + 1;
        for (int i2 = 0; i2 < indexedStringMap.size(); ++i2) {
            String string = indexedStringMap.getKeyAt(i2);
            Object v2 = indexedStringMap.getValueAt(i2);
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"');
            int n4 = stringBuilder.length();
            stringBuilder.append(string);
            StringBuilders.escapeJson(stringBuilder, n4);
            stringBuilder.append('\"').append(':');
            MapMessageJsonFormatter.format(stringBuilder, v2, n3);
        }
        stringBuilder.append('}');
    }

    private static void formatMap(StringBuilder stringBuilder, Map<Object, Object> map, int n2) {
        stringBuilder.append('{');
        int n3 = n2 + 1;
        boolean[] blArray = new boolean[]{true};
        map.forEach((object, object2) -> {
            if (object == null) {
                throw new IllegalArgumentException("null keys are not allowed");
            }
            if (blArray[0]) {
                blArray[0] = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"');
            String string = String.valueOf(object);
            int n3 = stringBuilder.length();
            stringBuilder.append(string);
            StringBuilders.escapeJson(stringBuilder, n3);
            stringBuilder.append('\"').append(':');
            MapMessageJsonFormatter.format(stringBuilder, object2, n3);
        });
        stringBuilder.append('}');
    }

    private static void formatList(StringBuilder stringBuilder, List<Object> list, int n2) {
        stringBuilder.append('[');
        int n3 = n2 + 1;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            Object object = list.get(i2);
            MapMessageJsonFormatter.format(stringBuilder, object, n3);
        }
        stringBuilder.append(']');
    }

    private static void formatCollection(StringBuilder stringBuilder, Collection<Object> collection, int n2) {
        stringBuilder.append('[');
        int n3 = n2 + 1;
        boolean[] blArray = new boolean[]{true};
        collection.forEach(object -> {
            if (blArray[0]) {
                blArray[0] = false;
            } else {
                stringBuilder.append(',');
            }
            MapMessageJsonFormatter.format(stringBuilder, object, n3);
        });
        stringBuilder.append(']');
    }

    private static void formatNumber(StringBuilder stringBuilder, Number number) {
        if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)number;
            stringBuilder.append(bigDecimal.toString());
        } else if (number instanceof Double) {
            double d2 = (Double)number;
            stringBuilder.append(d2);
        } else if (number instanceof Float) {
            float f2 = ((Float)number).floatValue();
            stringBuilder.append(f2);
        } else if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
            long l2 = number.longValue();
            stringBuilder.append(l2);
        } else {
            double d3;
            long l3 = number.longValue();
            if (Double.compare(l3, d3 = number.doubleValue()) == 0) {
                stringBuilder.append(l3);
            } else {
                stringBuilder.append(d3);
            }
        }
    }

    private static void formatBoolean(StringBuilder stringBuilder, boolean bl2) {
        stringBuilder.append(bl2);
    }

    private static void formatFormattable(StringBuilder stringBuilder, StringBuilderFormattable stringBuilderFormattable) {
        stringBuilder.append('\"');
        int n2 = stringBuilder.length();
        stringBuilderFormattable.formatTo(stringBuilder);
        StringBuilders.escapeJson(stringBuilder, n2);
        stringBuilder.append('\"');
    }

    private static void formatCharArray(StringBuilder stringBuilder, char[] cArray) {
        stringBuilder.append('[');
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            char c2 = cArray[i2];
            stringBuilder.append('\"');
            int n2 = stringBuilder.length();
            stringBuilder.append(c2);
            StringBuilders.escapeJson(stringBuilder, n2);
            stringBuilder.append('\"');
        }
        stringBuilder.append(']');
    }

    private static void formatBooleanArray(StringBuilder stringBuilder, boolean[] blArray) {
        stringBuilder.append('[');
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            boolean bl2 = blArray[i2];
            stringBuilder.append(bl2);
        }
        stringBuilder.append(']');
    }

    private static void formatByteArray(StringBuilder stringBuilder, byte[] byArray) {
        stringBuilder.append('[');
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            byte by2 = byArray[i2];
            stringBuilder.append(by2);
        }
        stringBuilder.append(']');
    }

    private static void formatShortArray(StringBuilder stringBuilder, short[] sArray) {
        stringBuilder.append('[');
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            short s2 = sArray[i2];
            stringBuilder.append(s2);
        }
        stringBuilder.append(']');
    }

    private static void formatIntArray(StringBuilder stringBuilder, int[] nArray) {
        stringBuilder.append('[');
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            int n2 = nArray[i2];
            stringBuilder.append(n2);
        }
        stringBuilder.append(']');
    }

    private static void formatLongArray(StringBuilder stringBuilder, long[] lArray) {
        stringBuilder.append('[');
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            long l2 = lArray[i2];
            stringBuilder.append(l2);
        }
        stringBuilder.append(']');
    }

    private static void formatFloatArray(StringBuilder stringBuilder, float[] fArray) {
        stringBuilder.append('[');
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            float f2 = fArray[i2];
            stringBuilder.append(f2);
        }
        stringBuilder.append(']');
    }

    private static void formatDoubleArray(StringBuilder stringBuilder, double[] dArray) {
        stringBuilder.append('[');
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            double d2 = dArray[i2];
            stringBuilder.append(d2);
        }
        stringBuilder.append(']');
    }

    private static void formatObjectArray(StringBuilder stringBuilder, Object[] objectArray, int n2) {
        stringBuilder.append('[');
        int n3 = n2 + 1;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            Object object = objectArray[i2];
            MapMessageJsonFormatter.format(stringBuilder, object, n3);
        }
        stringBuilder.append(']');
    }

    private static void formatString(StringBuilder stringBuilder, Object object) {
        stringBuilder.append('\"');
        int n2 = stringBuilder.length();
        String string = String.valueOf(object);
        stringBuilder.append(string);
        StringBuilders.escapeJson(stringBuilder, n2);
        stringBuilder.append('\"');
    }
}

