/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.simple;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Level;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.MessageFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.simple.SimpleLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.AbstractLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.ExtendedLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.LoggerContext;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.LoggerRegistry;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertiesUtil;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class SimpleLoggerContext
implements LoggerContext {
    static final SimpleLoggerContext INSTANCE = new SimpleLoggerContext();
    private static final String SYSTEM_OUT = "system.out";
    private static final String SYSTEM_ERR = "system.err";
    protected static final String DEFAULT_DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    protected static final String SYSTEM_PREFIX = "com.contrastsecurity.thirdparty.org.apache.logging.log4j.simplelog.";
    private final PropertiesUtil props;
    private final boolean showLogName;
    private final boolean showShortName;
    private final boolean showDateTime;
    private final boolean showContextMap;
    private final String dateTimeFormat;
    private final Level defaultLevel;
    private final PrintStream stream;
    private final LoggerRegistry<ExtendedLogger> loggerRegistry = new LoggerRegistry();

    public SimpleLoggerContext() {
        PrintStream printStream;
        this.props = new PropertiesUtil("com.contrastsecurity.thirdparty.log4j2.simplelog.properties");
        this.showContextMap = this.props.getBooleanProperty("com.contrastsecurity.thirdparty.org.apache.logging.log4j.simplelog.showContextMap", false);
        this.showLogName = this.props.getBooleanProperty("com.contrastsecurity.thirdparty.org.apache.logging.log4j.simplelog.showlogname", false);
        this.showShortName = this.props.getBooleanProperty("com.contrastsecurity.thirdparty.org.apache.logging.log4j.simplelog.showShortLogname", true);
        this.showDateTime = this.props.getBooleanProperty("com.contrastsecurity.thirdparty.org.apache.logging.log4j.simplelog.showdatetime", false);
        String string = this.props.getStringProperty("com.contrastsecurity.thirdparty.org.apache.logging.log4j.simplelog.level");
        this.defaultLevel = Level.toLevel(string, Level.ERROR);
        this.dateTimeFormat = this.showDateTime ? this.props.getStringProperty("com.contrastsecurity.thirdparty.org.apache.logging.log4j.simplelog.dateTimeFormat", DEFAULT_DATE_TIME_FORMAT) : null;
        String string2 = this.props.getStringProperty("com.contrastsecurity.thirdparty.org.apache.logging.log4j.simplelog.logFile", SYSTEM_ERR);
        if (SYSTEM_ERR.equalsIgnoreCase(string2)) {
            printStream = System.err;
        } else if (SYSTEM_OUT.equalsIgnoreCase(string2)) {
            printStream = System.out;
        } else {
            try {
                printStream = new PrintStream(new FileOutputStream(string2));
            }
            catch (FileNotFoundException fileNotFoundException) {
                printStream = System.err;
            }
        }
        this.stream = printStream;
    }

    @Override
    public Object getExternalContext() {
        return null;
    }

    @Override
    public ExtendedLogger getLogger(String string) {
        return this.getLogger(string, null);
    }

    @Override
    public ExtendedLogger getLogger(String string, MessageFactory messageFactory) {
        ExtendedLogger extendedLogger = this.loggerRegistry.getLogger(string, messageFactory);
        if (extendedLogger != null) {
            AbstractLogger.checkMessageFactory(extendedLogger, messageFactory);
            return extendedLogger;
        }
        SimpleLogger simpleLogger = new SimpleLogger(string, this.defaultLevel, this.showLogName, this.showShortName, this.showDateTime, this.showContextMap, this.dateTimeFormat, messageFactory, this.props, this.stream);
        this.loggerRegistry.putIfAbsent(string, messageFactory, simpleLogger);
        return this.loggerRegistry.getLogger(string, messageFactory);
    }

    public LoggerRegistry<ExtendedLogger> getLoggerRegistry() {
        return this.loggerRegistry;
    }

    @Override
    public boolean hasLogger(String string) {
        return false;
    }

    @Override
    public boolean hasLogger(String string, Class<? extends MessageFactory> clazz) {
        return false;
    }

    @Override
    public boolean hasLogger(String string, MessageFactory messageFactory) {
        return false;
    }
}

