/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.util;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.LoaderUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PerformanceSensitive;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PrivateSecurityManagerStackTraceUtil;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Predicate;

public final class StackLocator {
    static final int JDK_7U25_OFFSET;
    private static final Method GET_CALLER_CLASS_METHOD;
    private static final StackLocator INSTANCE;
    private static final Class<?> DEFAULT_CALLER_CLASS;

    public static StackLocator getInstance() {
        return INSTANCE;
    }

    private StackLocator() {
    }

    @PerformanceSensitive
    public Class<?> getCallerClass(Class<?> clazz, Predicate<Class<?>> predicate) {
        Class<?> clazz2;
        if (clazz == null) {
            throw new IllegalArgumentException("sentinelClass cannot be null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("callerPredicate cannot be null");
        }
        boolean bl2 = false;
        int n2 = 2;
        while (null != (clazz2 = this.getCallerClass(n2))) {
            if (clazz.equals(clazz2)) {
                bl2 = true;
            } else if (bl2 && predicate.test(clazz2)) {
                return clazz2;
            }
            ++n2;
        }
        return DEFAULT_CALLER_CLASS;
    }

    @PerformanceSensitive
    public Class<?> getCallerClass(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n2));
        }
        if (GET_CALLER_CLASS_METHOD == null) {
            return DEFAULT_CALLER_CLASS;
        }
        try {
            return (Class)GET_CALLER_CLASS_METHOD.invoke(null, n2 + 1 + JDK_7U25_OFFSET);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            return DEFAULT_CALLER_CLASS;
        }
    }

    @PerformanceSensitive
    public Class<?> getCallerClass(String string, String string2) {
        Class<?> clazz;
        boolean bl2 = false;
        int n2 = 2;
        while (null != (clazz = this.getCallerClass(n2))) {
            if (string.equals(clazz.getName())) {
                bl2 = true;
            } else if (bl2 && clazz.getName().startsWith(string2)) {
                return clazz;
            }
            ++n2;
        }
        return DEFAULT_CALLER_CLASS;
    }

    @PerformanceSensitive
    public Class<?> getCallerClass(Class<?> clazz) {
        Class<?> clazz2;
        boolean bl2 = false;
        int n2 = 2;
        while (null != (clazz2 = this.getCallerClass(n2))) {
            if (clazz.equals(clazz2)) {
                bl2 = true;
            } else if (bl2) {
                return clazz2;
            }
            ++n2;
        }
        return Object.class;
    }

    @PerformanceSensitive
    public Deque<Class<?>> getCurrentStackTrace() {
        Class<?> clazz;
        if (PrivateSecurityManagerStackTraceUtil.isEnabled()) {
            return PrivateSecurityManagerStackTraceUtil.getCurrentStackTrace();
        }
        ArrayDeque arrayDeque = new ArrayDeque();
        int n2 = 1;
        while (null != (clazz = this.getCallerClass(n2))) {
            arrayDeque.push(clazz);
            ++n2;
        }
        return arrayDeque;
    }

    public StackTraceElement calcLocation(String string) {
        if (string == null) {
            return null;
        }
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        boolean bl2 = false;
        for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
            String string2 = stackTraceElementArray[i2].getClassName();
            if (string.equals(string2)) {
                bl2 = true;
                continue;
            }
            if (!bl2 || string.equals(string2)) continue;
            return stackTraceElementArray[i2];
        }
        return null;
    }

    public StackTraceElement getStackTraceElement(int n2) {
        int n3 = 0;
        for (StackTraceElement stackTraceElement : new Throwable().getStackTrace()) {
            if (!this.isValid(stackTraceElement)) continue;
            if (n3 == n2) {
                return stackTraceElement;
            }
            ++n3;
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    private boolean isValid(StackTraceElement stackTraceElement) {
        if (stackTraceElement.isNativeMethod()) {
            return false;
        }
        String string = stackTraceElement.getClassName();
        if (string.startsWith("sun.reflect.")) {
            return false;
        }
        String string2 = stackTraceElement.getMethodName();
        if (string.startsWith("java.lang.reflect.") && (string2.equals("invoke") || string2.equals("newInstance"))) {
            return false;
        }
        if (string.startsWith("jdk.internal.reflect.")) {
            return false;
        }
        if (string.equals("java.lang.Class") && string2.equals("newInstance")) {
            return false;
        }
        return !string.equals("java.lang.invoke.MethodHandle") || !string2.startsWith("invoke");
    }

    static {
        Method method;
        DEFAULT_CALLER_CLASS = null;
        int n2 = 0;
        try {
            Class<?> clazz = LoaderUtil.loadClass("sun.reflect.Reflection");
            method = clazz.getDeclaredMethod("getCallerClass", Integer.TYPE);
            Object object = method.invoke(null, 0);
            method.invoke(null, 0);
            if (object == null || object != clazz) {
                method = null;
                n2 = -1;
            } else {
                object = method.invoke(null, 1);
                if (object == clazz) {
                    System.out.println("WARNING: Unexpected result from sun.reflect.Reflection.getCallerClass(int), adjusting offset for future calls.");
                    n2 = 1;
                }
            }
        }
        catch (Exception | LinkageError throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            System.out.println("WARNING: sun.reflect.Reflection.getCallerClass is not supported. This will impact performance.");
            method = null;
            n2 = -1;
        }
        GET_CALLER_CLASS_METHOD = method;
        JDK_7U25_OFFSET = n2;
        INSTANCE = new StackLocator();
    }
}

