/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.jctools.maps;

import com.contrastsecurity.thirdparty.org.jctools.maps.ConcurrentAutoTable;
import com.contrastsecurity.thirdparty.org.jctools.util.RangeUtil;
import com.contrastsecurity.thirdparty.org.jctools.util.UnsafeAccess;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

public class NonBlockingSetInt
extends AbstractSet<Integer>
implements Serializable {
    private static final long serialVersionUID = 1234123412341234123L;
    private static final long _nbsi_offset = UnsafeAccess.fieldOffset(NonBlockingSetInt.class, "_nbsi");
    private transient NBSI _nbsi = new NBSI(63, new ConcurrentAutoTable(), this);

    private final boolean CAS_nbsi(NBSI nBSI, NBSI nBSI2) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(this, _nbsi_offset, nBSI, nBSI2);
    }

    @Override
    public boolean add(Integer n2) {
        return this.add((int)n2);
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Integer && this.contains((Integer)object);
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof Integer && this.remove((Integer)object);
    }

    @Override
    public boolean add(int n2) {
        RangeUtil.checkPositiveOrZero(n2, "i");
        return this._nbsi.add(n2);
    }

    public boolean contains(int n2) {
        return n2 >= 0 && this._nbsi.contains(n2);
    }

    public boolean remove(int n2) {
        return n2 >= 0 && this._nbsi.remove(n2);
    }

    @Override
    public int size() {
        return this._nbsi.size();
    }

    public int length() {
        return this._nbsi._bits.length << 6;
    }

    @Override
    public void clear() {
        NBSI nBSI = new NBSI(63, new ConcurrentAutoTable(), this);
        while (!this.CAS_nbsi(this._nbsi, nBSI)) {
        }
    }

    public void print() {
        this._nbsi.print(0);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new iter();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        NBSI nBSI = this._nbsi;
        int n2 = this._nbsi._bits.length << 6;
        objectOutputStream.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            objectOutputStream.writeBoolean(this._nbsi.contains(i2));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this._nbsi = new NBSI(n2, new ConcurrentAutoTable(), this);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!objectInputStream.readBoolean()) continue;
            this._nbsi.add(i2);
        }
    }

    private static final class NBSI {
        private final transient NonBlockingSetInt _non_blocking_set_int;
        private final transient ConcurrentAutoTable _size;
        private final long[] _bits;
        private static final int _Lbase = UnsafeAccess.UNSAFE.arrayBaseOffset(long[].class);
        private static final int _Lscale = UnsafeAccess.UNSAFE.arrayIndexScale(long[].class);
        private NBSI _new;
        private static final long _new_offset = UnsafeAccess.fieldOffset(NBSI.class, "_new");
        private final transient AtomicInteger _copyIdx;
        private final transient AtomicInteger _copyDone;
        private final transient int _sum_bits_length;
        private final NBSI _nbsi64;

        private static long rawIndex(long[] lArray, int n2) {
            assert (n2 >= 0 && n2 < lArray.length);
            return (long)_Lbase + (long)n2 * (long)_Lscale;
        }

        private final boolean CAS(int n2, long l2, long l3) {
            return UnsafeAccess.UNSAFE.compareAndSwapLong(this._bits, NBSI.rawIndex(this._bits, n2), l2, l3);
        }

        private final boolean CAS_new(NBSI nBSI) {
            return UnsafeAccess.UNSAFE.compareAndSwapObject(this, _new_offset, null, nBSI);
        }

        private static final long mask(int n2) {
            return 1L << (n2 & 0x3F);
        }

        private NBSI(int n2, ConcurrentAutoTable concurrentAutoTable, NonBlockingSetInt nonBlockingSetInt) {
            this._non_blocking_set_int = nonBlockingSetInt;
            this._size = concurrentAutoTable;
            this._copyIdx = concurrentAutoTable == null ? null : new AtomicInteger();
            this._copyDone = concurrentAutoTable == null ? null : new AtomicInteger();
            this._bits = new long[(int)((long)n2 + 63L >>> 6)];
            this._nbsi64 = n2 + 1 >>> 6 == 0 ? null : new NBSI(n2 + 1 >>> 6, null, null);
            this._sum_bits_length = this._bits.length + (this._nbsi64 == null ? 0 : this._nbsi64._sum_bits_length);
        }

        public boolean add(int n2) {
            long l2;
            if (n2 >> 6 >= this._bits.length) {
                return this.install_larger_new_bits(n2).help_copy().add(n2);
            }
            NBSI nBSI = this;
            int n3 = n2;
            while ((n3 & 0x3F) == 63) {
                nBSI = nBSI._nbsi64;
                n3 >>= 6;
            }
            long l3 = NBSI.mask(n3);
            do {
                if ((l2 = nBSI._bits[n3 >> 6]) < 0L) {
                    return this.help_copy_impl(n2).help_copy().add(n2);
                }
                if ((l2 & l3) == 0L) continue;
                return false;
            } while (!nBSI.CAS(n3 >> 6, l2, l2 | l3));
            this._size.add(1L);
            return true;
        }

        public boolean remove(int n2) {
            long l2;
            if (n2 >> 6 >= this._bits.length) {
                return this._new != null && this.help_copy().remove(n2);
            }
            NBSI nBSI = this;
            int n3 = n2;
            while ((n3 & 0x3F) == 63) {
                nBSI = nBSI._nbsi64;
                n3 >>= 6;
            }
            long l3 = NBSI.mask(n3);
            do {
                if ((l2 = nBSI._bits[n3 >> 6]) < 0L) {
                    return this.help_copy_impl(n2).help_copy().remove(n2);
                }
                if ((l2 & l3) != 0L) continue;
                return false;
            } while (!nBSI.CAS(n3 >> 6, l2, l2 & (l3 ^ 0xFFFFFFFFFFFFFFFFL)));
            this._size.add(-1L);
            return true;
        }

        public boolean contains(int n2) {
            if (n2 >> 6 >= this._bits.length) {
                return this._new != null && this.help_copy().contains(n2);
            }
            NBSI nBSI = this;
            int n3 = n2;
            while ((n3 & 0x3F) == 63) {
                nBSI = nBSI._nbsi64;
                n3 >>= 6;
            }
            long l2 = NBSI.mask(n3);
            long l3 = nBSI._bits[n3 >> 6];
            if (l3 < 0L) {
                return this.help_copy_impl(n2).help_copy().contains(n2);
            }
            return (l3 & l2) != 0L;
        }

        public int size() {
            return (int)this._size.get();
        }

        private NBSI install_larger_new_bits(int n2) {
            if (this._new == null) {
                int n3 = this._bits.length << 6 << 1;
                this.CAS_new(new NBSI(n3, this._size, this._non_blocking_set_int));
            }
            return this;
        }

        private NBSI help_copy() {
            NBSI nBSI = this._non_blocking_set_int._nbsi;
            int n2 = 8;
            int n3 = nBSI._copyIdx.getAndAdd(512);
            for (int i2 = 0; i2 < 8; ++i2) {
                int n4 = n3 + i2 * 64;
                nBSI.help_copy_impl(n4 %= nBSI._bits.length << 6);
                nBSI.help_copy_impl(n4 + 63);
            }
            if (nBSI._copyDone.get() != nBSI._sum_bits_length || this._non_blocking_set_int.CAS_nbsi(nBSI, nBSI._new)) {
                // empty if block
            }
            return this._new;
        }

        private NBSI help_copy_impl(int n2) {
            long l2;
            NBSI nBSI = this;
            NBSI nBSI2 = this._new;
            if (nBSI2 == null) {
                return this;
            }
            int n3 = n2;
            while ((n3 & 0x3F) == 63) {
                nBSI = nBSI._nbsi64;
                nBSI2 = nBSI2._nbsi64;
                n3 >>= 6;
            }
            long l3 = nBSI._bits[n3 >> 6];
            while (l3 >= 0L) {
                l2 = l3;
                if (nBSI.CAS(n3 >> 6, l2, l3 |= NBSI.mask(63))) {
                    if (l2 != 0L) break;
                    this._copyDone.addAndGet(1);
                    break;
                }
                l3 = nBSI._bits[n3 >> 6];
            }
            if (l3 != NBSI.mask(63)) {
                l2 = nBSI2._bits[n3 >> 6];
                if (l2 == 0L) {
                    l2 = l3 & (NBSI.mask(63) ^ 0xFFFFFFFFFFFFFFFFL);
                    if (!nBSI2.CAS(n3 >> 6, 0L, l2)) {
                        l2 = nBSI2._bits[n3 >> 6];
                    }
                    assert (l2 != 0L);
                }
                if (nBSI.CAS(n3 >> 6, l3, NBSI.mask(63))) {
                    this._copyDone.addAndGet(1);
                }
            }
            return this;
        }

        private void print(int n2, String string) {
            for (int i2 = 0; i2 < n2; ++i2) {
                System.out.print("  ");
            }
            System.out.println(string);
        }

        private void print(int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("NBSI - _bits.len=");
            NBSI nBSI = this;
            while (nBSI != null) {
                stringBuilder.append(" " + nBSI._bits.length);
                nBSI = nBSI._nbsi64;
            }
            this.print(n2, stringBuilder.toString());
            nBSI = this;
            while (nBSI != null) {
                for (int i2 = 0; i2 < nBSI._bits.length; ++i2) {
                    System.out.print(Long.toHexString(nBSI._bits[i2]) + " ");
                }
                nBSI = nBSI._nbsi64;
                System.out.println();
            }
            if (this._copyIdx.get() != 0 || this._copyDone.get() != 0) {
                this.print(n2, "_copyIdx=" + this._copyIdx.get() + " _copyDone=" + this._copyDone.get() + " _words_to_cpy=" + this._sum_bits_length);
            }
            if (this._new != null) {
                this.print(n2, "__has_new - ");
                this._new.print(n2 + 1);
            }
        }
    }

    private class iter
    implements Iterator<Integer> {
        NBSI _nbsi2;
        int _idx = -1;
        int _prev = -1;

        iter() {
            this._nbsi2 = NonBlockingSetInt.this._nbsi;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this._idx != -2;
        }

        private void advance() {
            do {
                ++this._idx;
                while (this._idx >> 6 >= this._nbsi2._bits.length) {
                    if (this._nbsi2._new == null) {
                        this._idx = -2;
                        return;
                    }
                    this._nbsi2 = this._nbsi2._new;
                }
            } while (!this._nbsi2.contains(this._idx));
        }

        @Override
        public Integer next() {
            if (this._idx == -1) {
                throw new NoSuchElementException();
            }
            this._prev = this._idx;
            this.advance();
            return this._prev;
        }

        @Override
        public void remove() {
            if (this._prev == -1) {
                throw new IllegalStateException();
            }
            this._nbsi2.remove(this._prev);
            this._prev = -1;
        }
    }
}

