/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.jctools.queues;

import com.contrastsecurity.thirdparty.org.jctools.queues.MessagePassingQueue;
import com.contrastsecurity.thirdparty.org.jctools.util.PortableJvmInfo;

public final class MessagePassingQueueUtil {
    public static <E> int drain(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue.Consumer<E> consumer, int n2) {
        E e2;
        int n3;
        if (null == consumer) {
            throw new IllegalArgumentException("c is null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("limit is negative: " + n2);
        }
        if (n2 == 0) {
            return 0;
        }
        for (n3 = 0; n3 < n2 && (e2 = messagePassingQueue.relaxedPoll()) != null; ++n3) {
            consumer.accept(e2);
        }
        return n3;
    }

    public static <E> int drain(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue.Consumer<E> consumer) {
        E e2;
        if (null == consumer) {
            throw new IllegalArgumentException("c is null");
        }
        int n2 = 0;
        while ((e2 = messagePassingQueue.relaxedPoll()) != null) {
            ++n2;
            consumer.accept(e2);
        }
        return n2;
    }

    public static <E> void drain(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        if (null == consumer) {
            throw new IllegalArgumentException("c is null");
        }
        if (null == waitStrategy) {
            throw new IllegalArgumentException("wait is null");
        }
        if (null == exitCondition) {
            throw new IllegalArgumentException("exit condition is null");
        }
        int n2 = 0;
        while (exitCondition.keepRunning()) {
            E e2 = messagePassingQueue.relaxedPoll();
            if (e2 == null) {
                n2 = waitStrategy.idle(n2);
                continue;
            }
            n2 = 0;
            consumer.accept(e2);
        }
    }

    public static <E> void fill(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        if (null == waitStrategy) {
            throw new IllegalArgumentException("waiter is null");
        }
        if (null == exitCondition) {
            throw new IllegalArgumentException("exit condition is null");
        }
        int n2 = 0;
        while (exitCondition.keepRunning()) {
            if (messagePassingQueue.fill(supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH) == 0) {
                n2 = waitStrategy.idle(n2);
                continue;
            }
            n2 = 0;
        }
    }

    public static <E> int fillBounded(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue.Supplier<E> supplier) {
        return MessagePassingQueueUtil.fillInBatchesToLimit(messagePassingQueue, supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH, messagePassingQueue.capacity());
    }

    public static <E> int fillInBatchesToLimit(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue.Supplier<E> supplier, int n2, int n3) {
        int n4;
        long l2 = 0L;
        do {
            if ((n4 = messagePassingQueue.fill(supplier, n2)) != 0) continue;
            return (int)l2;
        } while ((l2 += (long)n4) <= (long)n3);
        return (int)l2;
    }

    public static <E> int fillUnbounded(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue.Supplier<E> supplier) {
        return MessagePassingQueueUtil.fillInBatchesToLimit(messagePassingQueue, supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH, 4096);
    }
}

