/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.msgpack.core.buffer;

import com.contrastsecurity.thirdparty.org.msgpack.core.Preconditions;
import com.contrastsecurity.thirdparty.org.msgpack.core.buffer.MessageBuffer;
import com.contrastsecurity.thirdparty.org.msgpack.core.buffer.MessageBufferOutput;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamBufferOutput
implements MessageBufferOutput {
    private OutputStream out;
    private MessageBuffer buffer;

    public OutputStreamBufferOutput(OutputStream outputStream) {
        this(outputStream, 8192);
    }

    public OutputStreamBufferOutput(OutputStream outputStream, int n2) {
        this.out = Preconditions.checkNotNull(outputStream, "output is null");
        this.buffer = MessageBuffer.allocate(n2);
    }

    public OutputStream reset(OutputStream outputStream) throws IOException {
        OutputStream outputStream2 = this.out;
        this.out = outputStream;
        return outputStream2;
    }

    @Override
    public MessageBuffer next(int n2) throws IOException {
        if (this.buffer.size() < n2) {
            this.buffer = MessageBuffer.allocate(n2);
        }
        return this.buffer;
    }

    @Override
    public void writeBuffer(int n2) throws IOException {
        this.write(this.buffer.array(), this.buffer.arrayOffset(), n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.out.write(byArray, n2, n3);
    }

    @Override
    public void add(byte[] byArray, int n2, int n3) throws IOException {
        this.write(byArray, n2, n3);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

