/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.ast;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.mvel2.CompileException;
import com.contrastsecurity.thirdparty.org.mvel2.MVEL;
import com.contrastsecurity.thirdparty.org.mvel2.MVELInterpretedRuntime;
import com.contrastsecurity.thirdparty.org.mvel2.ParserContext;
import com.contrastsecurity.thirdparty.org.mvel2.PropertyAccessor;
import com.contrastsecurity.thirdparty.org.mvel2.ast.ASTNode;
import com.contrastsecurity.thirdparty.org.mvel2.ast.Assignment;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.CompiledAccExpression;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.ExecutableStatement;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.util.ArrayTools;
import com.contrastsecurity.thirdparty.org.mvel2.util.ParseTools;

public class AssignmentNode
extends ASTNode
implements Assignment {
    private String assignmentVar;
    private String varName;
    private transient CompiledAccExpression accExpr;
    private char[] indexTarget;
    private String index;
    private ExecutableStatement statement;
    private boolean col = false;

    public AssignmentNode(char[] cArray, int n2, int n3, int n4, ParserContext parserContext) {
        super(parserContext);
        this.expr = cArray;
        this.start = n2;
        this.offset = n3;
        int n5 = ParseTools.find(cArray, n2, n3, '=');
        if (n5 != -1) {
            this.assignmentVar = this.varName = ParseTools.createStringTrimmed(cArray, n2, n5 - n2);
            this.start = ParseTools.skipWhitespace(cArray, n5 + 1);
            if (this.start >= n2 + n3) {
                throw new CompileException("unexpected end of statement", cArray, n5 + 1);
            }
            this.offset = n3 - (this.start - n2);
            if ((n4 & 0x10) != 0) {
                this.statement = (ExecutableStatement)ParseTools.subCompileExpression(cArray, this.start, this.offset, parserContext);
                this.egressType = this.statement.getKnownEgressType();
            }
            this.indexTarget = this.varName.toCharArray();
            this.endOfName = ArrayTools.findFirst('[', 0, this.varName.length(), this.indexTarget);
            this.col = this.endOfName > 0;
            if (this.col) {
                if (((this.fields |= 0x100) & 0x10) != 0) {
                    this.accExpr = (CompiledAccExpression)MVEL.compileSetExpression(this.indexTarget, parserContext);
                }
                this.varName = new String(cArray, n2, this.endOfName);
                this.index = new String(this.indexTarget, this.endOfName, this.indexTarget.length - this.endOfName);
            }
            try {
                ParseTools.checkNameSafety(this.varName);
            }
            catch (RuntimeException runtimeException) {
                Throwables.throwIfCritical(runtimeException);
                RuntimeException runtimeException2 = runtimeException;
                throw new CompileException(runtimeException2.getMessage(), cArray, n2);
            }
        }
        try {
            this.varName = new String(cArray, n2, n3);
            ParseTools.checkNameSafety(this.varName);
            this.assignmentVar = this.varName;
        }
        catch (RuntimeException runtimeException) {
            Throwables.throwIfCritical(runtimeException);
            RuntimeException runtimeException3 = runtimeException;
            throw new CompileException(runtimeException3.getMessage(), cArray, n2);
        }
        if ((n4 & 0x10) != 0) {
            parserContext.addVariable(this.varName, this.egressType);
        }
    }

    public Object getReducedValueAccelerated(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        if (this.accExpr == null && this.indexTarget != null) {
            this.accExpr = (CompiledAccExpression)MVEL.compileSetExpression(this.indexTarget);
        }
        if (this.col) {
            return this.accExpr.setValue(object, object2, variableResolverFactory, this.statement.getValue(object, object2, variableResolverFactory));
        }
        if (this.statement != null) {
            if (variableResolverFactory == null) {
                throw new CompileException("cannot assign variables; no variable resolver factory available", this.expr, this.start);
            }
            return variableResolverFactory.createVariable(this.varName, this.statement.getValue(object, object2, variableResolverFactory)).getValue();
        }
        if (variableResolverFactory == null) {
            throw new CompileException("cannot assign variables; no variable resolver factory available", this.expr, this.start);
        }
        variableResolverFactory.createVariable(this.varName, null);
        return null;
    }

    public Object getReducedValue(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        ParseTools.checkNameSafety(this.varName);
        MVELInterpretedRuntime mVELInterpretedRuntime = new MVELInterpretedRuntime(this.expr, this.start, this.offset, object, variableResolverFactory, this.pCtx);
        if (!this.col) {
            return variableResolverFactory.createVariable(this.varName, mVELInterpretedRuntime.parse()).getValue();
        }
        object = mVELInterpretedRuntime.parse();
        PropertyAccessor.set(variableResolverFactory.getVariableResolver(this.varName).getValue(), variableResolverFactory, this.index, object, this.pCtx);
        return object;
    }

    public String getAssignmentVar() {
        return this.assignmentVar;
    }

    public char[] getExpression() {
        return ParseTools.subset(this.expr, this.start, this.offset);
    }

    public boolean isNewDeclaration() {
        return false;
    }

    public void setValueStatement(ExecutableStatement executableStatement) {
        this.statement = executableStatement;
    }

    public String toString() {
        return this.assignmentVar + " = " + new String(this.expr, this.start, this.offset);
    }
}

