/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.ast;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.mvel2.CompileException;
import com.contrastsecurity.thirdparty.org.mvel2.DataConversion;
import com.contrastsecurity.thirdparty.org.mvel2.ParserContext;
import com.contrastsecurity.thirdparty.org.mvel2.UnresolveablePropertyException;
import com.contrastsecurity.thirdparty.org.mvel2.ast.ASTNode;
import com.contrastsecurity.thirdparty.org.mvel2.ast.Function;
import com.contrastsecurity.thirdparty.org.mvel2.ast.InvokationContextFactory;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.ExecutableStatement;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolver;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.integration.impl.MapVariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.integration.impl.SimpleValueResolver;
import com.contrastsecurity.thirdparty.org.mvel2.util.CallableProxy;
import com.contrastsecurity.thirdparty.org.mvel2.util.SimpleIndexHashMapWrapper;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class Proto
extends ASTNode {
    private String name;
    private Map<String, Receiver> receivers;
    private int cursorStart;
    private int cursorEnd;

    public Proto(String string, ParserContext parserContext) {
        super(parserContext);
        this.name = string;
        this.receivers = new SimpleIndexHashMapWrapper<String, Receiver>();
    }

    public Receiver declareReceiver(String string, Function function) {
        Receiver receiver = new Receiver(null, ReceiverType.FUNCTION, function);
        this.receivers.put(string, receiver);
        return receiver;
    }

    public Receiver declareReceiver(String string, Class clazz, ExecutableStatement executableStatement) {
        Receiver receiver = new Receiver(null, ReceiverType.PROPERTY, executableStatement);
        this.receivers.put(string, receiver);
        return receiver;
    }

    public Receiver declareReceiver(String string, ReceiverType receiverType, ExecutableStatement executableStatement) {
        Receiver receiver = new Receiver(null, receiverType, executableStatement);
        this.receivers.put(string, receiver);
        return receiver;
    }

    public ProtoInstance newInstance(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        return new ProtoInstance(this, object, object2, variableResolverFactory);
    }

    public Object getReducedValue(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        variableResolverFactory.createVariable(this.name, this);
        return this;
    }

    public Object getReducedValueAccelerated(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        variableResolverFactory.createVariable(this.name, this);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "proto " + this.name;
    }

    public void setCursorPosition(int n2, int n3) {
        this.cursorStart = n2;
        this.cursorEnd = n3;
    }

    public int getCursorStart() {
        return this.cursorStart;
    }

    public int getCursorEnd() {
        return this.cursorEnd;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProtoResolver
    implements VariableResolver {
        private String name;
        private Class<?> knownType;
        private Map<String, Object> variableMap;

        public ProtoResolver(Map<String, Object> map, String string) {
            this.variableMap = map;
            this.name = string;
        }

        public ProtoResolver(Map<String, Object> map, String string, Class clazz) {
            this.name = string;
            this.knownType = clazz;
            this.variableMap = map;
        }

        public void setName(String string) {
            this.name = string;
        }

        @Override
        public void setStaticType(Class clazz) {
            this.knownType = clazz;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class getType() {
            return this.knownType;
        }

        @Override
        public void setValue(Object object) {
            if (this.knownType != null && object != null && object.getClass() != this.knownType) {
                if (!DataConversion.canConvert(this.knownType, object.getClass())) {
                    throw new CompileException("cannot assign " + object.getClass().getName() + " to type: " + this.knownType.getName(), Proto.this.expr, Proto.this.start);
                }
                try {
                    object = DataConversion.convert(object, this.knownType);
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    Exception exception2 = exception;
                    throw new CompileException("cannot convert value of " + object.getClass().getName() + " to: " + this.knownType.getName(), Proto.this.expr, Proto.this.start);
                }
            }
            ((Receiver)this.variableMap.get(this.name)).receiver = object;
        }

        @Override
        public Object getValue() {
            return ((Receiver)this.variableMap.get(this.name)).receiver;
        }

        @Override
        public int getFlags() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProtoContextFactory
    extends MapVariableResolverFactory {
        private final SimpleIndexHashMapWrapper<String, VariableResolver> variableResolvers;

        public ProtoContextFactory(SimpleIndexHashMapWrapper simpleIndexHashMapWrapper) {
            super(simpleIndexHashMapWrapper);
            this.variableResolvers = new SimpleIndexHashMapWrapper(simpleIndexHashMapWrapper, true);
        }

        @Override
        public VariableResolver createVariable(String string, Object object) {
            try {
                VariableResolver variableResolver = this.getVariableResolver(string);
                variableResolver.setValue(object);
                return variableResolver;
            }
            catch (UnresolveablePropertyException unresolveablePropertyException) {
                ProtoResolver protoResolver = new ProtoResolver(this.variables, string);
                this.addResolver(string, protoResolver).setValue(object);
                return protoResolver;
            }
        }

        @Override
        public VariableResolver createVariable(String string, Object object, Class<?> clazz) {
            VariableResolver variableResolver;
            try {
                variableResolver = this.getVariableResolver(string);
            }
            catch (UnresolveablePropertyException unresolveablePropertyException) {
                variableResolver = null;
            }
            if (variableResolver != null && variableResolver.getType() != null) {
                throw new CompileException("variable already defined within scope: " + variableResolver.getType() + " " + string, Proto.this.expr, Proto.this.start);
            }
            variableResolver = new ProtoResolver(this.variables, string, clazz);
            this.addResolver(string, variableResolver).setValue(object);
            return variableResolver;
        }

        @Override
        public void setIndexedVariableNames(String[] stringArray) {
        }

        @Override
        public String[] getIndexedVariableNames() {
            return null;
        }

        @Override
        public VariableResolver createIndexedVariable(int n2, String string, Object object, Class<?> clazz) {
            VariableResolver variableResolver;
            VariableResolver variableResolver2 = variableResolver = this.variableResolvers != null ? this.variableResolvers.getByIndex(n2) : null;
            if (variableResolver != null && variableResolver.getType() != null) {
                throw new CompileException("variable already defined within scope: " + variableResolver.getType() + " " + string, Proto.this.expr, Proto.this.start);
            }
            return this.createIndexedVariable(this.variableIndexOf(string), string, object);
        }

        @Override
        public VariableResolver createIndexedVariable(int n2, String string, Object object) {
            VariableResolver variableResolver = this.variableResolvers.getByIndex(n2);
            if (variableResolver == null) {
                variableResolver = new SimpleValueResolver(object);
                this.variableResolvers.putAtIndex(n2, variableResolver);
            } else {
                variableResolver.setValue(object);
            }
            return this.indexedVariableResolvers[n2];
        }

        @Override
        public VariableResolver getIndexedVariableResolver(int n2) {
            return this.variableResolvers.getByIndex(n2);
        }

        @Override
        public VariableResolver setIndexedVariableResolver(int n2, VariableResolver variableResolver) {
            this.variableResolvers.putAtIndex(n2, variableResolver);
            return variableResolver;
        }

        @Override
        public int variableIndexOf(String string) {
            return this.variableResolvers.indexOf(string);
        }

        @Override
        public VariableResolver getVariableResolver(String string) {
            VariableResolver variableResolver = this.variableResolvers.get(string);
            if (variableResolver != null) {
                return variableResolver;
            }
            if (this.variables.containsKey(string)) {
                variableResolver = new ProtoResolver(this.variables, string);
                this.variableResolvers.put(string, variableResolver);
                return variableResolver;
            }
            if (this.nextFactory != null) {
                return this.nextFactory.getVariableResolver(string);
            }
            throw new UnresolveablePropertyException("unable to resolve variable '" + string + "'");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProtoInstance
    implements Map<String, Receiver> {
        private Proto protoType;
        private VariableResolverFactory instanceStates;
        private SimpleIndexHashMapWrapper<String, Receiver> receivers;

        public ProtoInstance(Proto proto2, Object object, Object object2, VariableResolverFactory variableResolverFactory) {
            this.protoType = proto2;
            this.receivers = new SimpleIndexHashMapWrapper();
            for (Map.Entry entry : proto2.receivers.entrySet()) {
                this.receivers.put((String)entry.getKey(), ((Receiver)entry.getValue()).init(this, object, object2, variableResolverFactory));
            }
            this.instanceStates = new ProtoContextFactory(this.receivers);
        }

        public Proto getProtoType() {
            return this.protoType;
        }

        @Override
        public int size() {
            return this.receivers.size();
        }

        @Override
        public boolean isEmpty() {
            return this.receivers.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.receivers.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.receivers.containsValue(object);
        }

        @Override
        public Receiver get(Object object) {
            return this.receivers.get(object);
        }

        @Override
        public Receiver put(String string, Receiver receiver) {
            return this.receivers.put(string, receiver);
        }

        @Override
        public Receiver remove(Object object) {
            return this.receivers.remove(object);
        }

        @Override
        public void putAll(Map map) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<String> keySet() {
            return this.receivers.keySet();
        }

        @Override
        public Collection<Receiver> values() {
            return this.receivers.values();
        }

        @Override
        public Set<Map.Entry<String, Receiver>> entrySet() {
            return this.receivers.entrySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReceiverType {
        DEFERRED,
        FUNCTION,
        PROPERTY;

    }

    public class Receiver
    implements CallableProxy {
        private ReceiverType type;
        private Object receiver;
        private ExecutableStatement initValue;
        private ProtoInstance instance;

        public Receiver(ProtoInstance protoInstance, ReceiverType receiverType, Object object) {
            this.instance = protoInstance;
            this.type = receiverType;
            this.receiver = object;
        }

        public Receiver(ProtoInstance protoInstance, ReceiverType receiverType, ExecutableStatement executableStatement) {
            this.instance = protoInstance;
            this.type = receiverType;
            this.initValue = executableStatement;
        }

        public Object call(Object object, Object object2, VariableResolverFactory variableResolverFactory, Object[] objectArray) {
            switch (this.type) {
                case FUNCTION: {
                    return ((Function)this.receiver).call(object, object2, new InvokationContextFactory(variableResolverFactory, this.instance.instanceStates), objectArray);
                }
                case PROPERTY: {
                    return this.receiver;
                }
                case DEFERRED: {
                    throw new CompileException("unresolved prototype receiver", Proto.this.expr, Proto.this.start);
                }
            }
            return null;
        }

        public Receiver init(ProtoInstance protoInstance, Object object, Object object2, VariableResolverFactory variableResolverFactory) {
            return new Receiver(protoInstance, this.type, this.type == ReceiverType.PROPERTY && this.initValue != null ? this.initValue.getValue(object, object2, variableResolverFactory) : this.receiver);
        }

        public void setType(ReceiverType receiverType) {
            this.type = receiverType;
        }

        public void setInitValue(ExecutableStatement executableStatement) {
            this.initValue = executableStatement;
        }
    }
}

