/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.ast;

import com.contrastsecurity.thirdparty.org.mvel2.CompileException;
import com.contrastsecurity.thirdparty.org.mvel2.ParserContext;
import com.contrastsecurity.thirdparty.org.mvel2.ast.ArraySize;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.AbstractParser;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.ExecutableStatement;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.util.ArrayTools;
import com.contrastsecurity.thirdparty.org.mvel2.util.ParseTools;
import com.contrastsecurity.thirdparty.org.mvel2.util.ReflectionUtil;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDescriptor
implements Serializable {
    private String className;
    private char[] expr;
    private int start;
    private int offset;
    private ArraySize[] arraySize;
    private ExecutableStatement[] compiledArraySize;
    int endRange;

    public TypeDescriptor(char[] cArray, int n2, int n3, int n4) {
        this.expr = cArray;
        this.start = n2;
        this.offset = n3;
        this.updateClassName(cArray, this.start, this.offset, n4);
    }

    public void updateClassName(char[] cArray, int n2, int n3, int n4) {
        this.expr = cArray;
        if (n3 == 0 || !ParseTools.isIdentifierPart(cArray[n2]) || Character.isDigit(cArray[n2])) {
            return;
        }
        this.endRange = ArrayTools.findFirst('(', n2, n3, cArray);
        if (this.endRange == -1) {
            this.endRange = ArrayTools.findFirst('[', n2, n3, cArray);
            if (this.endRange != -1) {
                int n5;
                this.className = new String(cArray, n2, this.endRange - n2).trim();
                LinkedList<char[]> linkedList = new LinkedList<char[]>();
                int n6 = n2 + n3;
                while (this.endRange < n6) {
                    while (this.endRange < n6 && ParseTools.isWhitespace(cArray[this.endRange])) {
                        ++this.endRange;
                    }
                    if (this.endRange == n6 || cArray[this.endRange] == '{') break;
                    if (cArray[this.endRange] != '[') {
                        throw new CompileException("unexpected token in constructor", cArray, this.endRange);
                    }
                    int n7 = ParseTools.balancedCapture(cArray, this.endRange, n2 + n3, '[');
                    linkedList.add(ParseTools.subset(cArray, ++this.endRange, n7 - this.endRange));
                    this.endRange = n7 + 1;
                }
                Iterator iterator = linkedList.iterator();
                this.arraySize = new ArraySize[linkedList.size()];
                for (n5 = 0; n5 < this.arraySize.length; ++n5) {
                    this.arraySize[n5] = new ArraySize((char[])iterator.next());
                }
                if ((n4 & 0x10) != 0) {
                    this.compiledArraySize = new ExecutableStatement[this.arraySize.length];
                    for (n5 = 0; n5 < this.compiledArraySize.length; ++n5) {
                        this.compiledArraySize[n5] = (ExecutableStatement)ParseTools.subCompileExpression(this.arraySize[n5].value);
                    }
                }
                return;
            }
            this.className = new String(cArray, n2, n3).trim();
        } else {
            this.className = new String(cArray, n2, this.endRange - n2).trim();
        }
    }

    public boolean isArray() {
        return this.arraySize != null;
    }

    public int getArrayLength() {
        return this.arraySize.length;
    }

    public ArraySize[] getArraySize() {
        return this.arraySize;
    }

    public ExecutableStatement[] getCompiledArraySize() {
        return this.compiledArraySize;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public boolean isClass() {
        return this.className != null && this.className.length() != 0;
    }

    public int getEndRange() {
        return this.endRange;
    }

    public void setEndRange(int n2) {
        this.endRange = n2;
    }

    public Class<?> getClassReference() throws ClassNotFoundException {
        return TypeDescriptor.getClassReference(null, this);
    }

    public Class<?> getClassReference(ParserContext parserContext) throws ClassNotFoundException {
        return TypeDescriptor.getClassReference(parserContext, this);
    }

    public static Class getClassReference(Class clazz, TypeDescriptor typeDescriptor, VariableResolverFactory variableResolverFactory, ParserContext parserContext) throws ClassNotFoundException {
        return ParseTools.findClass(variableResolverFactory, ParseTools.repeatChar('[', typeDescriptor.arraySize.length) + "L" + clazz.getName() + ";", parserContext);
    }

    public static Class getClassReference(ParserContext parserContext, Class clazz, TypeDescriptor typeDescriptor) throws ClassNotFoundException {
        if (typeDescriptor.isArray()) {
            clazz = clazz.isPrimitive() ? ReflectionUtil.toPrimitiveArrayType(clazz) : ParseTools.findClass(null, ParseTools.repeatChar('[', typeDescriptor.arraySize.length) + "L" + clazz.getName() + ";", parserContext);
        }
        return clazz;
    }

    public static Class getClassReference(ParserContext parserContext, TypeDescriptor typeDescriptor) throws ClassNotFoundException {
        Class clazz;
        if (parserContext != null && parserContext.hasImport(typeDescriptor.className)) {
            clazz = parserContext.getImport(typeDescriptor.className);
            if (typeDescriptor.isArray()) {
                clazz = clazz.isPrimitive() ? ReflectionUtil.toPrimitiveArrayType(clazz) : ParseTools.findClass(null, ParseTools.repeatChar('[', typeDescriptor.arraySize.length) + "L" + clazz.getName() + ";", parserContext);
            }
        } else if (parserContext == null && TypeDescriptor.hasContextFreeImport(typeDescriptor.className)) {
            clazz = TypeDescriptor.getContextFreeImport(typeDescriptor.className);
            if (typeDescriptor.isArray()) {
                clazz = clazz.isPrimitive() ? ReflectionUtil.toPrimitiveArrayType(clazz) : ParseTools.findClass(null, ParseTools.repeatChar('[', typeDescriptor.arraySize.length) + "L" + clazz.getName() + ";", parserContext);
            }
        } else {
            clazz = ParseTools.createClass(typeDescriptor.getClassName(), parserContext);
            if (typeDescriptor.isArray()) {
                clazz = clazz.isPrimitive() ? ReflectionUtil.toPrimitiveArrayType(clazz) : ParseTools.findClass(null, ParseTools.repeatChar('[', typeDescriptor.arraySize.length) + "L" + clazz.getName() + ";", parserContext);
            }
        }
        return clazz;
    }

    public boolean isUndimensionedArray() {
        if (this.arraySize != null) {
            for (ArraySize arraySize : this.arraySize) {
                if (arraySize.value.length != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasContextFreeImport(String string) {
        return AbstractParser.LITERALS.containsKey(string) && AbstractParser.LITERALS.get(string) instanceof Class;
    }

    public static Class getContextFreeImport(String string) {
        return (Class)AbstractParser.LITERALS.get(string);
    }

    public char[] getExpr() {
        return this.expr;
    }

    public int getStart() {
        return this.start;
    }

    public int getOffset() {
        return this.offset;
    }
}

