/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.conversion;

import com.contrastsecurity.thirdparty.org.mvel2.ConversionException;
import com.contrastsecurity.thirdparty.org.mvel2.ConversionHandler;
import com.contrastsecurity.thirdparty.org.mvel2.conversion.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class IntegerCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>(10);

    public Object convertFrom(Object object) {
        if (!CNV.containsKey(object.getClass())) {
            throw new ConversionException("cannot convert type: " + object.getClass().getName() + " to: " + Integer.class.getName());
        }
        return CNV.get(object.getClass()).convert(object);
    }

    public boolean canConvertFrom(Class clazz) {
        return CNV.containsKey(clazz);
    }

    static {
        CNV.put(Object.class, new Converter(){

            public Object convert(Object object) {
                if (((String)object).length() == 0) {
                    return 0;
                }
                return Integer.parseInt(String.valueOf(object));
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            public Integer convert(Object object) {
                return ((BigDecimal)object).intValue();
            }
        });
        CNV.put(BigInteger.class, new Converter(){

            public Integer convert(Object object) {
                return ((BigInteger)object).intValue();
            }
        });
        CNV.put(String.class, new Converter(){

            public Object convert(Object object) {
                return Integer.parseInt((String)object);
            }
        });
        CNV.put(Short.class, new Converter(){

            public Object convert(Object object) {
                return ((Short)object).intValue();
            }
        });
        CNV.put(Long.class, new Converter(){

            public Object convert(Object object) {
                if ((Long)object > Integer.MAX_VALUE) {
                    throw new ConversionException("cannot coerce Long to Integer since the value (" + String.valueOf(object) + ") exceeds that maximum precision of Integer.");
                }
                return ((Long)object).intValue();
            }
        });
        CNV.put(Float.class, new Converter(){

            public Object convert(Object object) {
                if (((Float)object).floatValue() > 2.1474836E9f) {
                    throw new ConversionException("cannot coerce Float to Integer since the value (" + String.valueOf(object) + ") exceeds that maximum precision of Integer.");
                }
                return ((Float)object).intValue();
            }
        });
        CNV.put(Double.class, new Converter(){

            public Object convert(Object object) {
                if ((Double)object > 2.147483647E9) {
                    throw new ConversionException("cannot coerce Long to Integer since the value (" + String.valueOf(object) + ") exceeds that maximum precision of Integer.");
                }
                return ((Double)object).intValue();
            }
        });
        CNV.put(Integer.class, new Converter(){

            public Object convert(Object object) {
                return object;
            }
        });
        CNV.put(Boolean.class, new Converter(){

            public Integer convert(Object object) {
                if (((Boolean)object).booleanValue()) {
                    return 1;
                }
                return 0;
            }
        });
        CNV.put(Character.class, new Converter(){

            public Integer convert(Object object) {
                return ((Character)object).charValue();
            }
        });
    }
}

