/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.conversion;

import com.contrastsecurity.thirdparty.org.mvel2.ConversionException;
import com.contrastsecurity.thirdparty.org.mvel2.ConversionHandler;
import com.contrastsecurity.thirdparty.org.mvel2.conversion.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class LongCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();
    private static Converter stringConverter = new Converter(){

        public Object convert(Object object) {
            if (((String)object).length() == 0) {
                return 0L;
            }
            return Long.parseLong((String)object);
        }
    };

    public Object convertFrom(Object object) {
        if (!CNV.containsKey(object.getClass())) {
            throw new ConversionException("cannot convert type: " + object.getClass().getName() + " to: " + Long.class.getName());
        }
        return CNV.get(object.getClass()).convert(object);
    }

    public boolean canConvertFrom(Class clazz) {
        return CNV.containsKey(clazz);
    }

    static {
        CNV.put(String.class, stringConverter);
        CNV.put(Object.class, new Converter(){

            public Object convert(Object object) {
                return stringConverter.convert(String.valueOf(object));
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            public Long convert(Object object) {
                return ((BigDecimal)object).longValue();
            }
        });
        CNV.put(BigInteger.class, new Converter(){

            public Long convert(Object object) {
                return ((BigInteger)object).longValue();
            }
        });
        CNV.put(Short.class, new Converter(){

            public Object convert(Object object) {
                return ((Short)object).longValue();
            }
        });
        CNV.put(Long.class, new Converter(){

            public Object convert(Object object) {
                return new Long((Long)object);
            }
        });
        CNV.put(Integer.class, new Converter(){

            public Object convert(Object object) {
                return ((Integer)object).longValue();
            }
        });
        CNV.put(Double.class, new Converter(){

            public Object convert(Object object) {
                return ((Double)object).longValue();
            }
        });
        CNV.put(Float.class, new Converter(){

            public Object convert(Object object) {
                return ((Float)object).longValue();
            }
        });
        CNV.put(Boolean.class, new Converter(){

            public Long convert(Object object) {
                if (((Boolean)object).booleanValue()) {
                    return 1L;
                }
                return 0L;
            }
        });
    }
}

