/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.optimizers.dynamic;

import com.contrastsecurity.thirdparty.org.mvel2.ParserContext;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.Accessor;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.optimizers.AccessorOptimizer;
import com.contrastsecurity.thirdparty.org.mvel2.optimizers.OptimizerFactory;
import com.contrastsecurity.thirdparty.org.mvel2.optimizers.dynamic.DynamicAccessor;
import com.contrastsecurity.thirdparty.org.mvel2.optimizers.dynamic.DynamicOptimizer;

public class DynamicSetAccessor
implements DynamicAccessor {
    private char[] property;
    private int start;
    private int offset;
    private boolean opt = false;
    private int runcount = 0;
    private long stamp;
    private ParserContext context;
    private final Accessor _safeAccessor;
    private Accessor _accessor;
    private String description;

    public DynamicSetAccessor(ParserContext parserContext, char[] cArray, int n2, int n3, Accessor accessor) {
        assert (accessor != null);
        this._safeAccessor = this._accessor = accessor;
        this.context = parserContext;
        this.property = cArray;
        this.start = n2;
        this.offset = n3;
        this.stamp = System.currentTimeMillis();
    }

    public Object setValue(Object object, Object object2, VariableResolverFactory variableResolverFactory, Object object3) {
        if (!this.opt && ++this.runcount > DynamicOptimizer.tenuringThreshold) {
            if (System.currentTimeMillis() - this.stamp < DynamicOptimizer.timeSpan) {
                this.opt = true;
                return this.optimize(object, object2, variableResolverFactory, object3);
            }
            this.runcount = 0;
            this.stamp = System.currentTimeMillis();
        }
        this._accessor.setValue(object, object2, variableResolverFactory, object3);
        return object3;
    }

    public Object getValue(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        throw new RuntimeException("value cannot be read with this accessor");
    }

    private Object optimize(Object object, Object object2, VariableResolverFactory variableResolverFactory, Object object3) {
        if (DynamicOptimizer.isOverloaded()) {
            DynamicOptimizer.enforceTenureLimit();
        }
        AccessorOptimizer accessorOptimizer = OptimizerFactory.getAccessorCompiler("ASM");
        this._accessor = accessorOptimizer.optimizeSetAccessor(this.context, this.property, this.start, this.offset, object, object2, variableResolverFactory, false, object3, object3 != null ? object3.getClass() : Object.class);
        assert (this._accessor != null);
        return object3;
    }

    public void deoptimize() {
        this._accessor = this._safeAccessor;
        this.opt = false;
        this.runcount = 0;
        this.stamp = System.currentTimeMillis();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Class getKnownEgressType() {
        return this._safeAccessor.getKnownEgressType();
    }
}

