/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.sh.command.basic;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.mvel2.sh.Command;
import com.contrastsecurity.thirdparty.org.mvel2.sh.ShellSession;
import com.contrastsecurity.thirdparty.org.mvel2.sh.text.TextUtil;
import com.contrastsecurity.thirdparty.org.mvel2.util.StringAppender;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;

public class ObjectInspector
implements Command {
    private static final int PADDING = 17;

    public Object execute(ShellSession shellSession, String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("inspect: requires an argument.");
            return null;
        }
        if (!shellSession.getVariables().containsKey(stringArray[0])) {
            System.out.println("inspect: no such variable: " + stringArray[0]);
            return null;
        }
        Object object = shellSession.getVariables().get(stringArray[0]);
        System.out.println("Object Inspector");
        System.out.println(TextUtil.paint('-', 17));
        if (object == null) {
            System.out.println("[Value is Null]");
            return null;
        }
        Class<?> clazz = object.getClass();
        boolean bl2 = true;
        long l2 = 0L;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(byteArrayOutputStream));
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            byteArrayOutputStream.flush();
            l2 = byteArrayOutputStream.size();
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            bl2 = false;
        }
        ObjectInspector.write("VariableName", stringArray[0]);
        ObjectInspector.write("Hashcode", object.hashCode());
        ObjectInspector.write("ClassType", clazz.getName());
        ObjectInspector.write("Serializable", bl2);
        if (bl2) {
            ObjectInspector.write("SerializedSize", l2 + " bytes");
        }
        ObjectInspector.write("ClassHierarchy", ObjectInspector.renderClassHeirarchy(clazz));
        ObjectInspector.write("Fields", clazz.getFields().length);
        ObjectInspector.renderFields(clazz);
        ObjectInspector.write("Methods", clazz.getMethods().length);
        ObjectInspector.renderMethods(clazz);
        System.out.println();
        return null;
    }

    private static String renderClassHeirarchy(Class clazz) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(clazz.getName());
        while ((clazz = clazz.getSuperclass()) != null) {
            linkedList.add(clazz.getName());
        }
        StringAppender stringAppender = new StringAppender();
        for (int i2 = linkedList.size() - 1; i2 != -1; --i2) {
            stringAppender.append((String)linkedList.get(i2));
            if (i2 - 1 == -1) continue;
            stringAppender.append(" -> ");
        }
        return stringAppender.toString();
    }

    private static void renderFields(Class clazz) {
        Field[] fieldArray = clazz.getFields();
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            ObjectInspector.write("", fieldArray[i2].getType().getName() + " " + fieldArray[i2].getName());
        }
    }

    private static void renderMethods(Class clazz) {
        Method[] methodArray = clazz.getMethods();
        StringAppender stringAppender = new StringAppender();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            stringAppender.append(TextUtil.paint(' ', 19));
            Method method = methodArray[i2];
            int n2 = method.getModifiers();
            if ((n2 & 1) != 0) {
                stringAppender.append("public");
            } else if ((n2 & 2) != 0) {
                stringAppender.append("private");
            } else if ((n2 & 4) != 0) {
                stringAppender.append("protected");
            }
            stringAppender.append(' ').append(method.getReturnType().getName()).append(' ').append(method.getName()).append("(");
            Class<?>[] classArray = method.getParameterTypes();
            for (int i3 = 0; i3 < classArray.length; ++i3) {
                if (classArray[i3].isArray()) {
                    stringAppender.append(classArray[i3].getComponentType().getName() + "[]");
                } else {
                    stringAppender.append(classArray[i3].getName());
                }
                if (i3 + 1 >= classArray.length) continue;
                stringAppender.append(", ");
            }
            stringAppender.append(")");
            if (method.getDeclaringClass() != clazz) {
                stringAppender.append("    [inherited from: ").append(method.getDeclaringClass().getName()).append("]");
            }
            if (i2 + 1 >= methodArray.length) continue;
            stringAppender.append('\n');
        }
        System.out.println(stringAppender.toString());
    }

    private static void write(Object object, Object object2) {
        System.out.println(TextUtil.padTwo(object, ": " + object2, 17));
    }

    public String getDescription() {
        return "inspects an object";
    }

    public String getHelp() {
        return "No help yet";
    }
}

