/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.util;

import com.contrastsecurity.thirdparty.org.mvel2.CompileException;
import com.contrastsecurity.thirdparty.org.mvel2.DataConversion;
import com.contrastsecurity.thirdparty.org.mvel2.ParserContext;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.ExecutableStatement;
import com.contrastsecurity.thirdparty.org.mvel2.util.ParseTools;
import com.contrastsecurity.thirdparty.org.mvel2.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.HashMap;

public class CollectionParser {
    private char[] property;
    private int cursor;
    private int start;
    private int end;
    private int type;
    public static final int LIST = 0;
    public static final int ARRAY = 1;
    public static final int MAP = 2;
    private Class colType;
    private ParserContext pCtx;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public CollectionParser() {
    }

    public CollectionParser(int n2) {
        this.type = n2;
    }

    public Object parseCollection(char[] cArray, int n2, int n3, boolean bl2, ParserContext parserContext) {
        this.property = cArray;
        this.pCtx = parserContext;
        this.end = n2 + n3;
        while (n2 < this.end && ParseTools.isWhitespace(cArray[n2])) {
            ++n2;
        }
        this.start = this.cursor = n2;
        return this.parseCollection(bl2);
    }

    public Object parseCollection(char[] cArray, int n2, int n3, boolean bl2, Class clazz, ParserContext parserContext) {
        if (clazz != null) {
            this.colType = ParseTools.getBaseComponentType(clazz);
        }
        this.property = cArray;
        this.end = n2 + n3;
        while (n2 < this.end && ParseTools.isWhitespace(cArray[n2])) {
            ++n2;
        }
        this.start = this.cursor = n2;
        this.pCtx = parserContext;
        return this.parseCollection(bl2);
    }

    private Object parseCollection(boolean bl2) {
        if (this.end - this.start == 0) {
            if (this.type == 0) {
                return new ArrayList();
            }
            return EMPTY_ARRAY;
        }
        HashMap<String, Object> hashMap = null;
        ArrayList<Object> arrayList = null;
        int n2 = this.start;
        if (this.type != -1) {
            switch (this.type) {
                case 0: 
                case 1: {
                    arrayList = new ArrayList<Object>();
                    break;
                }
                case 2: {
                    hashMap = new HashMap<String, Object>();
                }
            }
        }
        Object object = null;
        int n3 = -1;
        while (this.cursor < this.end) {
            switch (this.property[this.cursor]) {
                case '{': {
                    if (n3 == -1) {
                        n3 = 1;
                    }
                }
                case '[': {
                    if (this.cursor > this.start && ParseTools.isIdentifierPart(this.property[this.cursor - 1])) break;
                    if (n3 == -1) {
                        n3 = 0;
                    }
                    n2 = this.cursor;
                    this.cursor = ParseTools.balancedCapture(this.property, n2, this.end, this.property[n2]);
                    Object object2 = new CollectionParser(n3).parseCollection(this.property, n2 + 1, this.cursor - n2 - 1, bl2, this.colType, this.pCtx);
                    if (this.type == 2) {
                        hashMap.put((String)object, object2);
                    } else {
                        object = object2;
                        arrayList.add(object);
                    }
                    n2 = this.cursor = ParseTools.skipWhitespace(this.property, ++this.cursor);
                    if (n2 < this.end && this.property[this.cursor] == ',') {
                        n2 = this.cursor + 1;
                        break;
                    }
                    if (this.cursor >= this.end || ParseTools.opLookup(this.property[this.cursor]) != -1) break;
                    throw new CompileException("unterminated collection element", this.property, this.cursor);
                }
                case '(': {
                    this.cursor = ParseTools.balancedCapture(this.property, this.cursor, this.end, '(');
                    break;
                }
                case '\"': 
                case '\'': {
                    this.cursor = ParseTools.balancedCapture(this.property, this.cursor, this.end, this.property[this.cursor]);
                    break;
                }
                case ',': {
                    if (this.type != 2) {
                        arrayList.add(new String(this.property, n2, this.cursor - n2).trim());
                    } else {
                        hashMap.put((String)object, ParseTools.createStringTrimmed(this.property, n2, this.cursor - n2));
                    }
                    if (bl2) {
                        this.subCompile(n2, this.cursor - n2);
                    }
                    n2 = this.cursor + 1;
                    break;
                }
                case ':': {
                    if (this.type != 2) {
                        hashMap = new HashMap();
                        this.type = 2;
                    }
                    object = ParseTools.createStringTrimmed(this.property, n2, this.cursor - n2);
                    if (bl2) {
                        this.subCompile(n2, this.cursor - n2);
                    }
                    n2 = this.cursor + 1;
                    break;
                }
                case '.': {
                    ++this.cursor;
                    this.cursor = ParseTools.skipWhitespace(this.property, this.cursor);
                    if (this.cursor == this.end || this.property[this.cursor] != '{') break;
                    this.cursor = ParseTools.balancedCapture(this.property, this.cursor, '{');
                }
            }
            ++this.cursor;
        }
        if (n2 < this.end && ParseTools.isWhitespace(this.property[n2])) {
            n2 = ParseTools.skipWhitespace(this.property, n2);
        }
        if (n2 < this.end) {
            if (this.cursor < this.end - 1) {
                ++this.cursor;
            }
            if (this.type == 2) {
                hashMap.put((String)object, ParseTools.createStringTrimmed(this.property, n2, this.cursor - n2));
            } else {
                if (this.cursor < this.end) {
                    ++this.cursor;
                }
                arrayList.add(ParseTools.createStringTrimmed(this.property, n2, this.cursor - n2));
            }
            if (bl2) {
                this.subCompile(n2, this.cursor - n2);
            }
        }
        switch (this.type) {
            case 2: {
                return hashMap;
            }
            case 1: {
                return arrayList.toArray();
            }
        }
        return arrayList;
    }

    private void subCompile(int n2, int n3) {
        if (this.colType == null) {
            ParseTools.subCompileExpression(this.property, n2, n3, this.pCtx);
        } else {
            Class clazz = ((ExecutableStatement)ParseTools.subCompileExpression(this.property, n2, n3, this.pCtx)).getKnownEgressType();
            if (!(clazz == null || ReflectionUtil.isAssignableFrom(this.colType, clazz) || !this.isStrongType() && DataConversion.canConvert(clazz, this.colType))) {
                throw new CompileException("expected type: " + this.colType.getName() + "; but found: " + clazz.getName(), this.property, this.cursor);
            }
        }
    }

    private boolean isStrongType() {
        return this.pCtx != null && this.pCtx.isStrongTyping();
    }

    public int getCursor() {
        return this.cursor;
    }
}

