/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.objectweb.asm.commons;

import com.contrastsecurity.thirdparty.org.objectweb.asm.Label;
import com.contrastsecurity.thirdparty.org.objectweb.asm.MethodVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.Opcodes;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.AbstractInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.InsnList;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.InsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.JumpInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.LabelNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.LocalVariableNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.LookupSwitchInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.MethodNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.TableSwitchInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.TryCatchBlockNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSRInlinerAdapter
extends MethodNode
implements Opcodes {
    private final BitSet mainSubroutineInsns = new BitSet();
    private final Map<LabelNode, BitSet> subroutinesInsns = new HashMap<LabelNode, BitSet>();
    final BitSet sharedSubroutineInsns = new BitSet();

    public JSRInlinerAdapter(MethodVisitor methodVisitor, int n2, String string, String string2, String string3, String[] stringArray) {
        this(589824, methodVisitor, n2, string, string2, string3, stringArray);
        if (this.getClass() != JSRInlinerAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected JSRInlinerAdapter(int n2, MethodVisitor methodVisitor, int n3, String string, String string2, String string3, String[] stringArray) {
        super(n2, n3, string, string2, string3, stringArray);
        this.mv = methodVisitor;
    }

    @Override
    public void visitJumpInsn(int n2, Label label) {
        super.visitJumpInsn(n2, label);
        LabelNode labelNode = ((JumpInsnNode)this.instructions.getLast()).label;
        if (n2 == 168 && !this.subroutinesInsns.containsKey(labelNode)) {
            this.subroutinesInsns.put(labelNode, new BitSet());
        }
    }

    @Override
    public void visitEnd() {
        if (!this.subroutinesInsns.isEmpty()) {
            this.findSubroutinesInsns();
            this.emitCode();
        }
        if (this.mv != null) {
            this.accept(this.mv);
        }
    }

    private void findSubroutinesInsns() {
        BitSet bitSet = new BitSet();
        this.findSubroutineInsns(0, this.mainSubroutineInsns, bitSet);
        for (Map.Entry<LabelNode, BitSet> entry : this.subroutinesInsns.entrySet()) {
            LabelNode labelNode = entry.getKey();
            BitSet bitSet2 = entry.getValue();
            this.findSubroutineInsns(this.instructions.indexOf(labelNode), bitSet2, bitSet);
        }
    }

    private void findSubroutineInsns(int n2, BitSet bitSet, BitSet bitSet2) {
        boolean bl2;
        this.findReachableInsns(n2, bitSet, bitSet2);
        do {
            bl2 = false;
            for (TryCatchBlockNode tryCatchBlockNode : this.tryCatchBlocks) {
                int n3 = this.instructions.indexOf(tryCatchBlockNode.handler);
                if (bitSet.get(n3)) continue;
                int n4 = this.instructions.indexOf(tryCatchBlockNode.start);
                int n5 = this.instructions.indexOf(tryCatchBlockNode.end);
                int n6 = bitSet.nextSetBit(n4);
                if (n6 < n4 || n6 >= n5) continue;
                this.findReachableInsns(n3, bitSet, bitSet2);
                bl2 = true;
            }
        } while (bl2);
    }

    private void findReachableInsns(int n2, BitSet bitSet, BitSet bitSet2) {
        for (int i2 = n2; i2 < this.instructions.size(); ++i2) {
            AbstractInsnNode abstractInsnNode;
            if (bitSet.get(i2)) {
                return;
            }
            bitSet.set(i2);
            if (bitSet2.get(i2)) {
                this.sharedSubroutineInsns.set(i2);
            }
            bitSet2.set(i2);
            AbstractInsnNode abstractInsnNode2 = this.instructions.get(i2);
            if (abstractInsnNode2.getType() == 7 && abstractInsnNode2.getOpcode() != 168) {
                abstractInsnNode = (JumpInsnNode)abstractInsnNode2;
                this.findReachableInsns(this.instructions.indexOf(abstractInsnNode.label), bitSet, bitSet2);
            } else if (abstractInsnNode2.getType() == 11) {
                abstractInsnNode = (TableSwitchInsnNode)abstractInsnNode2;
                this.findReachableInsns(this.instructions.indexOf(((TableSwitchInsnNode)abstractInsnNode).dflt), bitSet, bitSet2);
                for (LabelNode labelNode : ((TableSwitchInsnNode)abstractInsnNode).labels) {
                    this.findReachableInsns(this.instructions.indexOf(labelNode), bitSet, bitSet2);
                }
            } else if (abstractInsnNode2.getType() == 12) {
                abstractInsnNode = (LookupSwitchInsnNode)abstractInsnNode2;
                this.findReachableInsns(this.instructions.indexOf(((LookupSwitchInsnNode)abstractInsnNode).dflt), bitSet, bitSet2);
                for (LabelNode labelNode : ((LookupSwitchInsnNode)abstractInsnNode).labels) {
                    this.findReachableInsns(this.instructions.indexOf(labelNode), bitSet, bitSet2);
                }
            }
            switch (this.instructions.get(i2).getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
            }
        }
    }

    private void emitCode() {
        LinkedList<Instantiation> linkedList = new LinkedList<Instantiation>();
        linkedList.add(new Instantiation(null, this.mainSubroutineInsns));
        InsnList insnList = new InsnList();
        ArrayList<TryCatchBlockNode> arrayList = new ArrayList<TryCatchBlockNode>();
        ArrayList<LocalVariableNode> arrayList2 = new ArrayList<LocalVariableNode>();
        while (!linkedList.isEmpty()) {
            Instantiation instantiation = (Instantiation)linkedList.removeFirst();
            this.emitInstantiation(instantiation, linkedList, insnList, arrayList, arrayList2);
        }
        this.instructions = insnList;
        this.tryCatchBlocks = arrayList;
        this.localVariables = arrayList2;
    }

    private void emitInstantiation(Instantiation instantiation, List<Instantiation> list, InsnList insnList, List<TryCatchBlockNode> list2, List<LocalVariableNode> list3) {
        Object object;
        Object object2;
        LabelNode labelNode;
        Object object3 = null;
        for (int i2 = 0; i2 < this.instructions.size(); ++i2) {
            Object object4 = this.instructions.get(i2);
            if (((AbstractInsnNode)object4).getType() == 8) {
                labelNode = (LabelNode)object4;
                object2 = instantiation.getClonedLabel(labelNode);
                if (object2 == object3) continue;
                insnList.add((AbstractInsnNode)object2);
                object3 = object2;
                continue;
            }
            if (instantiation.findOwner(i2) != instantiation) continue;
            if (((AbstractInsnNode)object4).getOpcode() == 169) {
                labelNode = null;
                object2 = instantiation;
                while (object2 != null) {
                    if (((Instantiation)object2).subroutineInsns.get(i2)) {
                        labelNode = ((Instantiation)object2).returnLabel;
                    }
                    object2 = ((Instantiation)object2).parent;
                }
                if (labelNode == null) {
                    throw new IllegalArgumentException(JSRInlinerAdapter.stringConcat$0(i2));
                }
                insnList.add(new JumpInsnNode(167, labelNode));
                continue;
            }
            if (((AbstractInsnNode)object4).getOpcode() == 168) {
                labelNode = ((JumpInsnNode)object4).label;
                object2 = this.subroutinesInsns.get(labelNode);
                object = new Instantiation(instantiation, (BitSet)object2);
                LabelNode labelNode2 = ((Instantiation)object).getClonedLabelForJumpInsn(labelNode);
                insnList.add(new InsnNode(1));
                insnList.add(new JumpInsnNode(167, labelNode2));
                insnList.add(((Instantiation)object).returnLabel);
                list.add((Instantiation)object);
                continue;
            }
            insnList.add(((AbstractInsnNode)object4).clone(instantiation));
        }
        for (Object object4 : this.tryCatchBlocks) {
            labelNode = instantiation.getClonedLabel(((TryCatchBlockNode)object4).start);
            if (labelNode == (object2 = instantiation.getClonedLabel(((TryCatchBlockNode)object4).end))) continue;
            object = instantiation.getClonedLabelForJumpInsn(((TryCatchBlockNode)object4).handler);
            if (labelNode == null || object2 == null || object == null) {
                throw new AssertionError((Object)"Internal error!");
            }
            list2.add(new TryCatchBlockNode(labelNode, (LabelNode)object2, (LabelNode)object, ((TryCatchBlockNode)object4).type));
        }
        for (Object object4 : this.localVariables) {
            labelNode = instantiation.getClonedLabel(((LocalVariableNode)object4).start);
            if (labelNode == (object2 = instantiation.getClonedLabel(((LocalVariableNode)object4).end))) continue;
            list3.add(new LocalVariableNode(((LocalVariableNode)object4).name, ((LocalVariableNode)object4).desc, ((LocalVariableNode)object4).signature, labelNode, (LabelNode)object2, ((LocalVariableNode)object4).index));
        }
    }

    private static /* synthetic */ String stringConcat$0(int n2) {
        return "Instruction #" + n2 + " is a RET not owned by any subroutine";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Instantiation
    extends AbstractMap<LabelNode, LabelNode> {
        final Instantiation parent;
        final BitSet subroutineInsns;
        final Map<LabelNode, LabelNode> clonedLabels;
        final LabelNode returnLabel;

        Instantiation(Instantiation instantiation, BitSet bitSet) {
            Object object = instantiation;
            while (object != null) {
                if (((Instantiation)object).subroutineInsns == bitSet) {
                    throw new IllegalArgumentException(Instantiation.stringConcat$0(bitSet));
                }
                object = ((Instantiation)object).parent;
            }
            this.parent = instantiation;
            this.subroutineInsns = bitSet;
            this.returnLabel = instantiation == null ? null : new LabelNode();
            this.clonedLabels = new HashMap<LabelNode, LabelNode>();
            object = null;
            for (int i2 = 0; i2 < JSRInlinerAdapter.this.instructions.size(); ++i2) {
                AbstractInsnNode abstractInsnNode = JSRInlinerAdapter.this.instructions.get(i2);
                if (abstractInsnNode.getType() == 8) {
                    LabelNode labelNode = (LabelNode)abstractInsnNode;
                    if (object == null) {
                        object = new LabelNode();
                    }
                    this.clonedLabels.put(labelNode, (LabelNode)object);
                    continue;
                }
                if (this.findOwner(i2) != this) continue;
                object = null;
            }
        }

        private static /* synthetic */ String stringConcat$0(BitSet bitSet) {
            return "Recursive invocation of " + bitSet;
        }

        Instantiation findOwner(int n2) {
            if (!this.subroutineInsns.get(n2)) {
                return null;
            }
            if (!JSRInlinerAdapter.this.sharedSubroutineInsns.get(n2)) {
                return this;
            }
            Instantiation instantiation = this;
            Instantiation instantiation2 = this.parent;
            while (instantiation2 != null) {
                if (instantiation2.subroutineInsns.get(n2)) {
                    instantiation = instantiation2;
                }
                instantiation2 = instantiation2.parent;
            }
            return instantiation;
        }

        LabelNode getClonedLabelForJumpInsn(LabelNode labelNode) {
            return this.findOwner((int)JSRInlinerAdapter.this.instructions.indexOf((AbstractInsnNode)labelNode)).clonedLabels.get(labelNode);
        }

        LabelNode getClonedLabel(LabelNode labelNode) {
            return this.clonedLabels.get(labelNode);
        }

        @Override
        public Set<Map.Entry<LabelNode, LabelNode>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LabelNode get(Object object) {
            return this.getClonedLabelForJumpInsn((LabelNode)object);
        }

        @Override
        public boolean equals(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }
}

