/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.objectweb.asm.tree;

import com.contrastsecurity.thirdparty.org.objectweb.asm.MethodVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.AbstractInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.LabelNode;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsnList
implements Iterable<AbstractInsnNode> {
    private int size;
    private AbstractInsnNode firstInsn;
    private AbstractInsnNode lastInsn;
    AbstractInsnNode[] cache;

    public int size() {
        return this.size;
    }

    public AbstractInsnNode getFirst() {
        return this.firstInsn;
    }

    public AbstractInsnNode getLast() {
        return this.lastInsn;
    }

    public AbstractInsnNode get(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (this.cache == null) {
            this.cache = this.toArray();
        }
        return this.cache[n2];
    }

    public boolean contains(AbstractInsnNode abstractInsnNode) {
        AbstractInsnNode abstractInsnNode2 = this.firstInsn;
        while (abstractInsnNode2 != null && abstractInsnNode2 != abstractInsnNode) {
            abstractInsnNode2 = abstractInsnNode2.nextInsn;
        }
        return abstractInsnNode2 != null;
    }

    public int indexOf(AbstractInsnNode abstractInsnNode) {
        if (this.cache == null) {
            this.cache = this.toArray();
        }
        return abstractInsnNode.index;
    }

    public void accept(MethodVisitor methodVisitor) {
        AbstractInsnNode abstractInsnNode = this.firstInsn;
        while (abstractInsnNode != null) {
            abstractInsnNode.accept(methodVisitor);
            abstractInsnNode = abstractInsnNode.nextInsn;
        }
    }

    @Override
    public ListIterator<AbstractInsnNode> iterator() {
        return this.iterator(0);
    }

    public ListIterator<AbstractInsnNode> iterator(int n2) {
        return new InsnListIterator(n2);
    }

    public AbstractInsnNode[] toArray() {
        int n2 = 0;
        AbstractInsnNode abstractInsnNode = this.firstInsn;
        AbstractInsnNode[] abstractInsnNodeArray = new AbstractInsnNode[this.size];
        while (abstractInsnNode != null) {
            abstractInsnNodeArray[n2] = abstractInsnNode;
            abstractInsnNode.index = n2++;
            abstractInsnNode = abstractInsnNode.nextInsn;
        }
        return abstractInsnNodeArray;
    }

    public void set(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        AbstractInsnNode abstractInsnNode3;
        AbstractInsnNode abstractInsnNode4;
        abstractInsnNode2.nextInsn = abstractInsnNode4 = abstractInsnNode.nextInsn;
        if (abstractInsnNode4 != null) {
            abstractInsnNode4.previousInsn = abstractInsnNode2;
        } else {
            this.lastInsn = abstractInsnNode2;
        }
        abstractInsnNode2.previousInsn = abstractInsnNode3 = abstractInsnNode.previousInsn;
        if (abstractInsnNode3 != null) {
            abstractInsnNode3.nextInsn = abstractInsnNode2;
        } else {
            this.firstInsn = abstractInsnNode2;
        }
        if (this.cache != null) {
            int n2 = abstractInsnNode.index;
            this.cache[n2] = abstractInsnNode2;
            abstractInsnNode2.index = n2;
        } else {
            abstractInsnNode2.index = 0;
        }
        abstractInsnNode.index = -1;
        abstractInsnNode.previousInsn = null;
        abstractInsnNode.nextInsn = null;
    }

    public void add(AbstractInsnNode abstractInsnNode) {
        ++this.size;
        if (this.lastInsn == null) {
            this.firstInsn = abstractInsnNode;
            this.lastInsn = abstractInsnNode;
        } else {
            this.lastInsn.nextInsn = abstractInsnNode;
            abstractInsnNode.previousInsn = this.lastInsn;
        }
        this.lastInsn = abstractInsnNode;
        this.cache = null;
        abstractInsnNode.index = 0;
    }

    public void add(InsnList insnList) {
        if (insnList.size == 0) {
            return;
        }
        this.size += insnList.size;
        if (this.lastInsn == null) {
            this.firstInsn = insnList.firstInsn;
            this.lastInsn = insnList.lastInsn;
        } else {
            AbstractInsnNode abstractInsnNode;
            this.lastInsn.nextInsn = abstractInsnNode = insnList.firstInsn;
            abstractInsnNode.previousInsn = this.lastInsn;
            this.lastInsn = insnList.lastInsn;
        }
        this.cache = null;
        insnList.removeAll(false);
    }

    public void insert(AbstractInsnNode abstractInsnNode) {
        ++this.size;
        if (this.firstInsn == null) {
            this.firstInsn = abstractInsnNode;
            this.lastInsn = abstractInsnNode;
        } else {
            this.firstInsn.previousInsn = abstractInsnNode;
            abstractInsnNode.nextInsn = this.firstInsn;
        }
        this.firstInsn = abstractInsnNode;
        this.cache = null;
        abstractInsnNode.index = 0;
    }

    public void insert(InsnList insnList) {
        if (insnList.size == 0) {
            return;
        }
        this.size += insnList.size;
        if (this.firstInsn == null) {
            this.firstInsn = insnList.firstInsn;
            this.lastInsn = insnList.lastInsn;
        } else {
            AbstractInsnNode abstractInsnNode;
            this.firstInsn.previousInsn = abstractInsnNode = insnList.lastInsn;
            abstractInsnNode.nextInsn = this.firstInsn;
            this.firstInsn = insnList.firstInsn;
        }
        this.cache = null;
        insnList.removeAll(false);
    }

    public void insert(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        ++this.size;
        AbstractInsnNode abstractInsnNode3 = abstractInsnNode.nextInsn;
        if (abstractInsnNode3 == null) {
            this.lastInsn = abstractInsnNode2;
        } else {
            abstractInsnNode3.previousInsn = abstractInsnNode2;
        }
        abstractInsnNode.nextInsn = abstractInsnNode2;
        abstractInsnNode2.nextInsn = abstractInsnNode3;
        abstractInsnNode2.previousInsn = abstractInsnNode;
        this.cache = null;
        abstractInsnNode2.index = 0;
    }

    public void insert(AbstractInsnNode abstractInsnNode, InsnList insnList) {
        if (insnList.size == 0) {
            return;
        }
        this.size += insnList.size;
        AbstractInsnNode abstractInsnNode2 = insnList.firstInsn;
        AbstractInsnNode abstractInsnNode3 = insnList.lastInsn;
        AbstractInsnNode abstractInsnNode4 = abstractInsnNode.nextInsn;
        if (abstractInsnNode4 == null) {
            this.lastInsn = abstractInsnNode3;
        } else {
            abstractInsnNode4.previousInsn = abstractInsnNode3;
        }
        abstractInsnNode.nextInsn = abstractInsnNode2;
        abstractInsnNode3.nextInsn = abstractInsnNode4;
        abstractInsnNode2.previousInsn = abstractInsnNode;
        this.cache = null;
        insnList.removeAll(false);
    }

    public void insertBefore(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        ++this.size;
        AbstractInsnNode abstractInsnNode3 = abstractInsnNode.previousInsn;
        if (abstractInsnNode3 == null) {
            this.firstInsn = abstractInsnNode2;
        } else {
            abstractInsnNode3.nextInsn = abstractInsnNode2;
        }
        abstractInsnNode.previousInsn = abstractInsnNode2;
        abstractInsnNode2.nextInsn = abstractInsnNode;
        abstractInsnNode2.previousInsn = abstractInsnNode3;
        this.cache = null;
        abstractInsnNode2.index = 0;
    }

    public void insertBefore(AbstractInsnNode abstractInsnNode, InsnList insnList) {
        if (insnList.size == 0) {
            return;
        }
        this.size += insnList.size;
        AbstractInsnNode abstractInsnNode2 = insnList.firstInsn;
        AbstractInsnNode abstractInsnNode3 = insnList.lastInsn;
        AbstractInsnNode abstractInsnNode4 = abstractInsnNode.previousInsn;
        if (abstractInsnNode4 == null) {
            this.firstInsn = abstractInsnNode2;
        } else {
            abstractInsnNode4.nextInsn = abstractInsnNode2;
        }
        abstractInsnNode.previousInsn = abstractInsnNode3;
        abstractInsnNode3.nextInsn = abstractInsnNode;
        abstractInsnNode2.previousInsn = abstractInsnNode4;
        this.cache = null;
        insnList.removeAll(false);
    }

    public void remove(AbstractInsnNode abstractInsnNode) {
        --this.size;
        AbstractInsnNode abstractInsnNode2 = abstractInsnNode.nextInsn;
        AbstractInsnNode abstractInsnNode3 = abstractInsnNode.previousInsn;
        if (abstractInsnNode2 == null) {
            if (abstractInsnNode3 == null) {
                this.firstInsn = null;
                this.lastInsn = null;
            } else {
                abstractInsnNode3.nextInsn = null;
                this.lastInsn = abstractInsnNode3;
            }
        } else if (abstractInsnNode3 == null) {
            this.firstInsn = abstractInsnNode2;
            abstractInsnNode2.previousInsn = null;
        } else {
            abstractInsnNode3.nextInsn = abstractInsnNode2;
            abstractInsnNode2.previousInsn = abstractInsnNode3;
        }
        this.cache = null;
        abstractInsnNode.index = -1;
        abstractInsnNode.previousInsn = null;
        abstractInsnNode.nextInsn = null;
    }

    void removeAll(boolean bl2) {
        if (bl2) {
            AbstractInsnNode abstractInsnNode = this.firstInsn;
            while (abstractInsnNode != null) {
                AbstractInsnNode abstractInsnNode2 = abstractInsnNode.nextInsn;
                abstractInsnNode.index = -1;
                abstractInsnNode.previousInsn = null;
                abstractInsnNode.nextInsn = null;
                abstractInsnNode = abstractInsnNode2;
            }
        }
        this.size = 0;
        this.firstInsn = null;
        this.lastInsn = null;
        this.cache = null;
    }

    public void clear() {
        this.removeAll(false);
    }

    public void resetLabels() {
        AbstractInsnNode abstractInsnNode = this.firstInsn;
        while (abstractInsnNode != null) {
            if (abstractInsnNode instanceof LabelNode) {
                ((LabelNode)abstractInsnNode).resetLabel();
            }
            abstractInsnNode = abstractInsnNode.nextInsn;
        }
    }

    private final class InsnListIterator
    implements ListIterator {
        AbstractInsnNode nextInsn;
        AbstractInsnNode previousInsn;
        AbstractInsnNode remove;

        InsnListIterator(int n2) {
            if (n2 < 0 || n2 > InsnList.this.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == InsnList.this.size()) {
                this.nextInsn = null;
                this.previousInsn = InsnList.this.getLast();
            } else {
                AbstractInsnNode abstractInsnNode = InsnList.this.getFirst();
                for (int i2 = 0; i2 < n2; ++i2) {
                    abstractInsnNode = abstractInsnNode.nextInsn;
                }
                this.nextInsn = abstractInsnNode;
                this.previousInsn = abstractInsnNode.previousInsn;
            }
        }

        public boolean hasNext() {
            return this.nextInsn != null;
        }

        public Object next() {
            AbstractInsnNode abstractInsnNode;
            if (this.nextInsn == null) {
                throw new NoSuchElementException();
            }
            this.previousInsn = abstractInsnNode = this.nextInsn;
            this.nextInsn = abstractInsnNode.nextInsn;
            this.remove = abstractInsnNode;
            return abstractInsnNode;
        }

        public void remove() {
            if (this.remove != null) {
                if (this.remove == this.nextInsn) {
                    this.nextInsn = this.nextInsn.nextInsn;
                } else {
                    this.previousInsn = this.previousInsn.previousInsn;
                }
            } else {
                throw new IllegalStateException();
            }
            InsnList.this.remove(this.remove);
            this.remove = null;
        }

        public boolean hasPrevious() {
            return this.previousInsn != null;
        }

        public Object previous() {
            AbstractInsnNode abstractInsnNode;
            if (this.previousInsn == null) {
                throw new NoSuchElementException();
            }
            this.nextInsn = abstractInsnNode = this.previousInsn;
            this.previousInsn = abstractInsnNode.previousInsn;
            this.remove = abstractInsnNode;
            return abstractInsnNode;
        }

        public int nextIndex() {
            if (this.nextInsn == null) {
                return InsnList.this.size();
            }
            if (InsnList.this.cache == null) {
                InsnList.this.cache = InsnList.this.toArray();
            }
            return this.nextInsn.index;
        }

        public int previousIndex() {
            if (this.previousInsn == null) {
                return -1;
            }
            if (InsnList.this.cache == null) {
                InsnList.this.cache = InsnList.this.toArray();
            }
            return this.previousInsn.index;
        }

        public void add(Object object) {
            if (this.nextInsn != null) {
                InsnList.this.insertBefore(this.nextInsn, (AbstractInsnNode)object);
            } else if (this.previousInsn != null) {
                InsnList.this.insert(this.previousInsn, (AbstractInsnNode)object);
            } else {
                InsnList.this.add((AbstractInsnNode)object);
            }
            this.previousInsn = (AbstractInsnNode)object;
            this.remove = null;
        }

        public void set(Object object) {
            if (this.remove != null) {
                InsnList.this.set(this.remove, (AbstractInsnNode)object);
                if (this.remove == this.previousInsn) {
                    this.previousInsn = (AbstractInsnNode)object;
                } else {
                    this.nextInsn = (AbstractInsnNode)object;
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }
}

