/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.objectweb.asm.tree.analysis;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.objectweb.asm.Opcodes;
import com.contrastsecurity.thirdparty.org.objectweb.asm.Type;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.AbstractInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.IincInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.InsnList;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.JumpInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.LabelNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.LookupSwitchInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.MethodNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.TableSwitchInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.TryCatchBlockNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.VarInsnNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.analysis.AnalyzerException;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.analysis.Frame;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.analysis.Interpreter;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.analysis.Subroutine;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.analysis.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyzer<V extends Value>
implements Opcodes {
    private final Interpreter<V> interpreter;
    private InsnList insnList;
    private int insnListSize;
    private List<TryCatchBlockNode>[] handlers;
    private Frame<V>[] frames;
    private Subroutine[] subroutines;
    private boolean[] inInstructionsToProcess;
    private int[] instructionsToProcess;
    private int numInstructionsToProcess;

    public Analyzer(Interpreter<V> interpreter) {
        this.interpreter = interpreter;
    }

    public Frame<V>[] analyze(String string, MethodNode methodNode) throws AnalyzerException {
        Frame<V> frame;
        Object object;
        if ((methodNode.access & 0x500) != 0) {
            this.frames = new Frame[0];
            return this.frames;
        }
        this.insnList = methodNode.instructions;
        this.insnListSize = this.insnList.size();
        this.handlers = new List[this.insnListSize];
        this.frames = new Frame[this.insnListSize];
        this.subroutines = new Subroutine[this.insnListSize];
        this.inInstructionsToProcess = new boolean[this.insnListSize];
        this.instructionsToProcess = new int[this.insnListSize];
        this.numInstructionsToProcess = 0;
        for (int i2 = 0; i2 < methodNode.tryCatchBlocks.size(); ++i2) {
            object = methodNode.tryCatchBlocks.get(i2);
            int n2 = this.insnList.indexOf(((TryCatchBlockNode)object).start);
            int n3 = this.insnList.indexOf(((TryCatchBlockNode)object).end);
            for (int i3 = n2; i3 < n3; ++i3) {
                List<TryCatchBlockNode> list = this.handlers[i3];
                if (list == null) {
                    this.handlers[i3] = list = new ArrayList<TryCatchBlockNode>();
                }
                list.add((TryCatchBlockNode)object);
            }
        }
        this.findSubroutines(methodNode.maxLocals);
        try {
            frame = this.computeInitialFrame(string, methodNode);
            this.merge(0, frame, null);
            this.init(string, methodNode);
        }
        catch (RuntimeException runtimeException) {
            Throwables.throwIfCritical(runtimeException);
            object = runtimeException;
            throw new AnalyzerException(this.insnList.get(0), Analyzer.stringConcat$0(((Throwable)object).getMessage()), (Throwable)object);
        }
        while (this.numInstructionsToProcess > 0) {
            int n4 = this.instructionsToProcess[--this.numInstructionsToProcess];
            Frame<V> frame2 = this.frames[n4];
            Subroutine subroutine = this.subroutines[n4];
            this.inInstructionsToProcess[n4] = false;
            AbstractInsnNode abstractInsnNode = null;
            try {
                Object object2;
                Object object3;
                abstractInsnNode = methodNode.instructions.get(n4);
                int n5 = abstractInsnNode.getOpcode();
                int n6 = abstractInsnNode.getType();
                if (n6 == 8 || n6 == 15 || n6 == 14) {
                    this.merge(n4 + 1, frame2, subroutine);
                    this.newControlFlowEdge(n4, n4 + 1);
                } else {
                    int n7;
                    frame.init(frame2).execute(abstractInsnNode, this.interpreter);
                    Subroutine subroutine2 = subroutine = subroutine == null ? null : new Subroutine(subroutine);
                    if (abstractInsnNode instanceof JumpInsnNode) {
                        object3 = (JumpInsnNode)abstractInsnNode;
                        if (n5 != 167 && n5 != 168) {
                            frame.initJumpTarget(n5, null);
                            this.merge(n4 + 1, frame, subroutine);
                            this.newControlFlowEdge(n4, n4 + 1);
                        }
                        int n8 = this.insnList.indexOf(((JumpInsnNode)object3).label);
                        frame.initJumpTarget(n5, ((JumpInsnNode)object3).label);
                        if (n5 == 168) {
                            this.merge(n8, frame, new Subroutine(((JumpInsnNode)object3).label, methodNode.maxLocals, (JumpInsnNode)object3));
                        } else {
                            this.merge(n8, frame, subroutine);
                        }
                        this.newControlFlowEdge(n4, n8);
                    } else if (abstractInsnNode instanceof LookupSwitchInsnNode) {
                        object3 = (LookupSwitchInsnNode)abstractInsnNode;
                        int n9 = this.insnList.indexOf(((LookupSwitchInsnNode)object3).dflt);
                        frame.initJumpTarget(n5, ((LookupSwitchInsnNode)object3).dflt);
                        this.merge(n9, frame, subroutine);
                        this.newControlFlowEdge(n4, n9);
                        for (n7 = 0; n7 < ((LookupSwitchInsnNode)object3).labels.size(); ++n7) {
                            object2 = ((LookupSwitchInsnNode)object3).labels.get(n7);
                            n9 = this.insnList.indexOf((AbstractInsnNode)object2);
                            frame.initJumpTarget(n5, (LabelNode)object2);
                            this.merge(n9, frame, subroutine);
                            this.newControlFlowEdge(n4, n9);
                        }
                    } else if (abstractInsnNode instanceof TableSwitchInsnNode) {
                        object3 = (TableSwitchInsnNode)abstractInsnNode;
                        int n10 = this.insnList.indexOf(((TableSwitchInsnNode)object3).dflt);
                        frame.initJumpTarget(n5, ((TableSwitchInsnNode)object3).dflt);
                        this.merge(n10, frame, subroutine);
                        this.newControlFlowEdge(n4, n10);
                        for (n7 = 0; n7 < ((TableSwitchInsnNode)object3).labels.size(); ++n7) {
                            object2 = ((TableSwitchInsnNode)object3).labels.get(n7);
                            frame.initJumpTarget(n5, (LabelNode)object2);
                            n10 = this.insnList.indexOf((AbstractInsnNode)object2);
                            this.merge(n10, frame, subroutine);
                            this.newControlFlowEdge(n4, n10);
                        }
                    } else if (n5 == 169) {
                        if (subroutine == null) {
                            throw new AnalyzerException(abstractInsnNode, "RET instruction outside of a subroutine");
                        }
                        for (int i4 = 0; i4 < subroutine.callers.size(); ++i4) {
                            JumpInsnNode jumpInsnNode = subroutine.callers.get(i4);
                            n7 = this.insnList.indexOf(jumpInsnNode);
                            if (this.frames[n7] == null) continue;
                            this.merge(n7 + 1, this.frames[n7], frame, this.subroutines[n7], subroutine.localsUsed);
                            this.newControlFlowEdge(n4, n7 + 1);
                        }
                    } else if (n5 != 191 && (n5 < 172 || n5 > 177)) {
                        if (subroutine != null) {
                            if (abstractInsnNode instanceof VarInsnNode) {
                                int n11 = ((VarInsnNode)abstractInsnNode).var;
                                subroutine.localsUsed[n11] = true;
                                if (n5 == 22 || n5 == 24 || n5 == 55 || n5 == 57) {
                                    subroutine.localsUsed[n11 + 1] = true;
                                }
                            } else if (abstractInsnNode instanceof IincInsnNode) {
                                int n12 = ((IincInsnNode)abstractInsnNode).var;
                                subroutine.localsUsed[n12] = true;
                            }
                        }
                        this.merge(n4 + 1, frame, subroutine);
                        this.newControlFlowEdge(n4, n4 + 1);
                    }
                }
                if ((object3 = this.handlers[n4]) == null) continue;
                Iterator<TryCatchBlockNode> iterator = object3.iterator();
                while (iterator.hasNext()) {
                    TryCatchBlockNode tryCatchBlockNode = iterator.next();
                    object2 = tryCatchBlockNode.type == null ? Type.getObjectType("java/lang/Throwable") : Type.getObjectType(tryCatchBlockNode.type);
                    if (!this.newControlFlowExceptionEdge(n4, tryCatchBlockNode)) continue;
                    Frame<V> frame3 = this.newFrame(frame2);
                    V v2 = this.interpreter.newExceptionValue(tryCatchBlockNode, frame3, (Type)object2);
                    frame3.clearStack();
                    frame3.push(v2);
                    this.merge(this.insnList.indexOf(tryCatchBlockNode.handler), frame3, subroutine);
                    frame3 = this.newFrame(frame);
                    frame3.clearStack();
                    frame3.push(v2);
                    this.merge(this.insnList.indexOf(tryCatchBlockNode.handler), frame3, subroutine);
                }
            }
            catch (AnalyzerException analyzerException) {
                throw new AnalyzerException(analyzerException.node, Analyzer.stringConcat$1(n4, analyzerException.getMessage()), analyzerException);
            }
            catch (RuntimeException runtimeException) {
                Throwables.throwIfCritical(runtimeException);
                RuntimeException runtimeException2 = runtimeException;
                throw new AnalyzerException(abstractInsnNode, Analyzer.stringConcat$2(n4, runtimeException2.getMessage()), runtimeException2);
            }
        }
        return this.frames;
    }

    private static /* synthetic */ String stringConcat$0(String string) {
        return "Error at instruction 0: " + string;
    }

    private static /* synthetic */ String stringConcat$1(int n2, String string) {
        return "Error at instruction " + n2 + ": " + string;
    }

    private static /* synthetic */ String stringConcat$2(int n2, String string) {
        return "Error at instruction " + n2 + ": " + string;
    }

    public Frame<V>[] analyzeAndComputeMaxs(String string, MethodNode methodNode) throws AnalyzerException {
        methodNode.maxLocals = Analyzer.computeMaxLocals(methodNode);
        methodNode.maxStack = -1;
        this.analyze(string, methodNode);
        methodNode.maxStack = Analyzer.computeMaxStack(this.frames);
        return this.frames;
    }

    private static int computeMaxLocals(MethodNode methodNode) {
        int n2 = Type.getArgumentsAndReturnSizes(methodNode.desc) >> 2;
        if ((methodNode.access & 8) != 0) {
            --n2;
        }
        for (AbstractInsnNode abstractInsnNode : methodNode.instructions) {
            int n3;
            if (abstractInsnNode instanceof VarInsnNode) {
                n3 = ((VarInsnNode)abstractInsnNode).var;
                int n4 = abstractInsnNode.getOpcode() == 22 || abstractInsnNode.getOpcode() == 24 || abstractInsnNode.getOpcode() == 55 || abstractInsnNode.getOpcode() == 57 ? 2 : 1;
                n2 = Math.max(n2, n3 + n4);
                continue;
            }
            if (!(abstractInsnNode instanceof IincInsnNode)) continue;
            n3 = ((IincInsnNode)abstractInsnNode).var;
            n2 = Math.max(n2, n3 + 1);
        }
        return n2;
    }

    private static int computeMaxStack(Frame<?>[] frameArray) {
        int n2 = 0;
        for (Frame<?> frame : frameArray) {
            if (frame == null) continue;
            int n3 = 0;
            for (int i2 = 0; i2 < frame.getStackSize(); ++i2) {
                n3 += frame.getStack(i2).getSize();
            }
            n2 = Math.max(n2, n3);
        }
        return n2;
    }

    private void findSubroutines(int n2) throws AnalyzerException {
        Subroutine subroutine = new Subroutine(null, n2, null);
        ArrayList<AbstractInsnNode> arrayList = new ArrayList<AbstractInsnNode>();
        this.findSubroutine(0, subroutine, arrayList);
        HashMap<LabelNode, Subroutine> hashMap = new HashMap<LabelNode, Subroutine>();
        while (!arrayList.isEmpty()) {
            JumpInsnNode jumpInsnNode = (JumpInsnNode)arrayList.remove(0);
            Subroutine subroutine2 = (Subroutine)hashMap.get(jumpInsnNode.label);
            if (subroutine2 == null) {
                subroutine2 = new Subroutine(jumpInsnNode.label, n2, jumpInsnNode);
                hashMap.put(jumpInsnNode.label, subroutine2);
                this.findSubroutine(this.insnList.indexOf(jumpInsnNode.label), subroutine2, arrayList);
                continue;
            }
            subroutine2.callers.add(jumpInsnNode);
        }
        for (int i2 = 0; i2 < this.insnListSize; ++i2) {
            if (this.subroutines[i2] == null || this.subroutines[i2].start != null) continue;
            this.subroutines[i2] = null;
        }
    }

    private void findSubroutine(int n2, Subroutine subroutine, List<AbstractInsnNode> list) throws AnalyzerException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(n2);
        block3: while (!arrayList.isEmpty()) {
            Object object;
            Object object2;
            int n3 = (Integer)arrayList.remove(arrayList.size() - 1);
            if (n3 < 0 || n3 >= this.insnListSize) {
                throw new AnalyzerException(null, "Execution can fall off the end of the code");
            }
            if (this.subroutines[n3] != null) continue;
            this.subroutines[n3] = new Subroutine(subroutine);
            AbstractInsnNode abstractInsnNode = this.insnList.get(n3);
            if (abstractInsnNode instanceof JumpInsnNode) {
                if (abstractInsnNode.getOpcode() == 168) {
                    list.add(abstractInsnNode);
                } else {
                    object2 = (JumpInsnNode)abstractInsnNode;
                    arrayList.add(this.insnList.indexOf(((JumpInsnNode)object2).label));
                }
            } else if (abstractInsnNode instanceof TableSwitchInsnNode) {
                object2 = (TableSwitchInsnNode)abstractInsnNode;
                this.findSubroutine(this.insnList.indexOf(((TableSwitchInsnNode)object2).dflt), subroutine, list);
                for (int i2 = ((TableSwitchInsnNode)object2).labels.size() - 1; i2 >= 0; --i2) {
                    object = ((TableSwitchInsnNode)object2).labels.get(i2);
                    arrayList.add(this.insnList.indexOf((AbstractInsnNode)object));
                }
            } else if (abstractInsnNode instanceof LookupSwitchInsnNode) {
                object2 = (LookupSwitchInsnNode)abstractInsnNode;
                this.findSubroutine(this.insnList.indexOf(((LookupSwitchInsnNode)object2).dflt), subroutine, list);
                for (int i3 = ((LookupSwitchInsnNode)object2).labels.size() - 1; i3 >= 0; --i3) {
                    object = ((LookupSwitchInsnNode)object2).labels.get(i3);
                    arrayList.add(this.insnList.indexOf((AbstractInsnNode)object));
                }
            }
            object2 = this.handlers[n3];
            if (object2 != null) {
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (TryCatchBlockNode)iterator.next();
                    arrayList.add(this.insnList.indexOf(((TryCatchBlockNode)object).handler));
                }
            }
            switch (abstractInsnNode.getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    continue block3;
                }
            }
            arrayList.add(n3 + 1);
        }
    }

    private Frame<V> computeInitialFrame(String string, MethodNode methodNode) {
        Type[] typeArray;
        boolean bl2;
        Frame<V> frame = this.newFrame(methodNode.maxLocals, methodNode.maxStack);
        int n2 = 0;
        boolean bl3 = bl2 = (methodNode.access & 8) == 0;
        if (bl2) {
            typeArray = Type.getObjectType(string);
            frame.setLocal(n2, this.interpreter.newParameterValue(bl2, n2, (Type)typeArray));
            ++n2;
        }
        for (Type type : typeArray = Type.getArgumentTypes(methodNode.desc)) {
            frame.setLocal(n2, this.interpreter.newParameterValue(bl2, n2, type));
            ++n2;
            if (type.getSize() != 2) continue;
            frame.setLocal(n2, this.interpreter.newEmptyValue(n2));
            ++n2;
        }
        while (n2 < methodNode.maxLocals) {
            frame.setLocal(n2, this.interpreter.newEmptyValue(n2));
            ++n2;
        }
        frame.setReturn(this.interpreter.newReturnTypeValue(Type.getReturnType(methodNode.desc)));
        return frame;
    }

    public Frame<V>[] getFrames() {
        return this.frames;
    }

    public List<TryCatchBlockNode> getHandlers(int n2) {
        return this.handlers[n2];
    }

    protected void init(String string, MethodNode methodNode) throws AnalyzerException {
    }

    protected Frame<V> newFrame(int n2, int n3) {
        return new Frame(n2, n3);
    }

    protected Frame<V> newFrame(Frame<? extends V> frame) {
        return new Frame<V>(frame);
    }

    protected void newControlFlowEdge(int n2, int n3) {
    }

    protected boolean newControlFlowExceptionEdge(int n2, int n3) {
        return true;
    }

    protected boolean newControlFlowExceptionEdge(int n2, TryCatchBlockNode tryCatchBlockNode) {
        return this.newControlFlowExceptionEdge(n2, this.insnList.indexOf(tryCatchBlockNode.handler));
    }

    private void merge(int n2, Frame<V> frame, Subroutine subroutine) throws AnalyzerException {
        boolean bl2;
        Frame<V> frame2 = this.frames[n2];
        if (frame2 == null) {
            this.frames[n2] = this.newFrame(frame);
            bl2 = true;
        } else {
            bl2 = frame2.merge(frame, this.interpreter);
        }
        Subroutine subroutine2 = this.subroutines[n2];
        if (subroutine2 == null) {
            if (subroutine != null) {
                this.subroutines[n2] = new Subroutine(subroutine);
                bl2 = true;
            }
        } else if (subroutine != null) {
            bl2 |= subroutine2.merge(subroutine);
        }
        if (bl2 && !this.inInstructionsToProcess[n2]) {
            this.inInstructionsToProcess[n2] = true;
            this.instructionsToProcess[this.numInstructionsToProcess++] = n2;
        }
    }

    private void merge(int n2, Frame<V> frame, Frame<V> frame2, Subroutine subroutine, boolean[] blArray) throws AnalyzerException {
        boolean bl2;
        frame2.merge(frame, blArray);
        Frame<V> frame3 = this.frames[n2];
        if (frame3 == null) {
            this.frames[n2] = this.newFrame(frame2);
            bl2 = true;
        } else {
            bl2 = frame3.merge(frame2, this.interpreter);
        }
        Subroutine subroutine2 = this.subroutines[n2];
        if (subroutine2 != null && subroutine != null) {
            bl2 |= subroutine2.merge(subroutine);
        }
        if (bl2 && !this.inInstructionsToProcess[n2]) {
            this.inInstructionsToProcess[n2] = true;
            this.instructionsToProcess[this.numInstructionsToProcess++] = n2;
        }
    }
}

