/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.objectweb.asm.util;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.objectweb.asm.AnnotationVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.Attribute;
import com.contrastsecurity.thirdparty.org.objectweb.asm.ClassReader;
import com.contrastsecurity.thirdparty.org.objectweb.asm.ClassVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.ClassWriter;
import com.contrastsecurity.thirdparty.org.objectweb.asm.FieldVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.Label;
import com.contrastsecurity.thirdparty.org.objectweb.asm.MethodVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.ModuleVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.RecordComponentVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.Type;
import com.contrastsecurity.thirdparty.org.objectweb.asm.TypePath;
import com.contrastsecurity.thirdparty.org.objectweb.asm.TypeReference;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.ClassNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.MethodNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.TryCatchBlockNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.analysis.Analyzer;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.analysis.AnalyzerException;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.analysis.BasicValue;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.analysis.Frame;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.analysis.SimpleVerifier;
import com.contrastsecurity.thirdparty.org.objectweb.asm.util.CheckAnnotationAdapter;
import com.contrastsecurity.thirdparty.org.objectweb.asm.util.CheckFieldAdapter;
import com.contrastsecurity.thirdparty.org.objectweb.asm.util.CheckMethodAdapter;
import com.contrastsecurity.thirdparty.org.objectweb.asm.util.CheckModuleAdapter;
import com.contrastsecurity.thirdparty.org.objectweb.asm.util.CheckRecordComponentAdapter;
import com.contrastsecurity.thirdparty.org.objectweb.asm.util.Textifier;
import com.contrastsecurity.thirdparty.org.objectweb.asm.util.TraceMethodVisitor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckClassAdapter
extends ClassVisitor {
    private static final String USAGE = "Verifies the given class.\nUsage: CheckClassAdapter <fully qualified class name or class file name>";
    private static final String ERROR_AT = ": error at index ";
    private boolean checkDataFlow;
    private int version;
    private boolean visitCalled;
    private boolean visitModuleCalled;
    private boolean visitSourceCalled;
    private boolean visitOuterClassCalled;
    private boolean visitNestHostCalled;
    private String nestMemberPackageName;
    private boolean visitEndCalled;
    private Map<Label, Integer> labelInsnIndices = new HashMap<Label, Integer>();

    public CheckClassAdapter(ClassVisitor classVisitor) {
        this(classVisitor, true);
    }

    public CheckClassAdapter(ClassVisitor classVisitor, boolean bl2) {
        this(589824, classVisitor, bl2);
        if (this.getClass() != CheckClassAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckClassAdapter(int n2, ClassVisitor classVisitor, boolean bl2) {
        super(n2, classVisitor);
        this.checkDataFlow = bl2;
    }

    @Override
    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        if (this.visitCalled) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.visitCalled = true;
        this.checkState();
        CheckClassAdapter.checkAccess(n3, 259633);
        if (string == null) {
            throw new IllegalArgumentException("Illegal class name (null)");
        }
        if (!string.endsWith("package-info") && !string.endsWith("module-info")) {
            CheckMethodAdapter.checkInternalName(n2, string, "class name");
        }
        if ("java/lang/Object".equals(string)) {
            if (string3 != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else if (string.endsWith("module-info")) {
            if (string3 != null) {
                throw new IllegalArgumentException("The super class name of a module-info class must be 'null'");
            }
        } else {
            CheckMethodAdapter.checkInternalName(n2, string3, "super class name");
        }
        if (string2 != null) {
            CheckClassAdapter.checkClassSignature(string2);
        }
        if ((n3 & 0x200) != 0 && !"java/lang/Object".equals(string3)) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                CheckMethodAdapter.checkInternalName(n2, stringArray[i2], CheckClassAdapter.stringConcat$0(i2));
            }
        }
        this.version = n2;
        super.visit(n2, n3, string, string2, string3, stringArray);
    }

    private static /* synthetic */ String stringConcat$0(int n2) {
        return "interface name at index " + n2;
    }

    @Override
    public void visitSource(String string, String string2) {
        this.checkState();
        if (this.visitSourceCalled) {
            throw new IllegalStateException("visitSource can be called only once.");
        }
        this.visitSourceCalled = true;
        super.visitSource(string, string2);
    }

    @Override
    public ModuleVisitor visitModule(String string, int n2, String string2) {
        this.checkState();
        if (this.visitModuleCalled) {
            throw new IllegalStateException("visitModule can be called only once.");
        }
        this.visitModuleCalled = true;
        CheckClassAdapter.checkFullyQualifiedName(this.version, string, "module name");
        CheckClassAdapter.checkAccess(n2, 36896);
        CheckModuleAdapter checkModuleAdapter = new CheckModuleAdapter(this.api, super.visitModule(string, n2, string2), (n2 & 0x20) != 0);
        checkModuleAdapter.classVersion = this.version;
        return checkModuleAdapter;
    }

    @Override
    public void visitNestHost(String string) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(this.version, string, "nestHost");
        if (this.visitNestHostCalled) {
            throw new IllegalStateException("visitNestHost can be called only once.");
        }
        if (this.nestMemberPackageName != null) {
            throw new IllegalStateException("visitNestHost and visitNestMember are mutually exclusive.");
        }
        this.visitNestHostCalled = true;
        super.visitNestHost(string);
    }

    @Override
    public void visitNestMember(String string) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(this.version, string, "nestMember");
        if (this.visitNestHostCalled) {
            throw new IllegalStateException("visitMemberOfNest and visitNestHost are mutually exclusive.");
        }
        String string2 = CheckClassAdapter.packageName(string);
        if (this.nestMemberPackageName == null) {
            this.nestMemberPackageName = string2;
        } else if (!this.nestMemberPackageName.equals(string2)) {
            throw new IllegalStateException(CheckClassAdapter.stringConcat$1(string, this.nestMemberPackageName));
        }
        super.visitNestMember(string);
    }

    private static /* synthetic */ String stringConcat$1(String string, String string2) {
        return "nest member " + string + " should be in the package " + string2;
    }

    @Override
    public void visitPermittedSubclass(String string) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(this.version, string, "permittedSubclass");
        super.visitPermittedSubclass(string);
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
        this.checkState();
        if (this.visitOuterClassCalled) {
            throw new IllegalStateException("visitOuterClass can be called only once.");
        }
        this.visitOuterClassCalled = true;
        if (string == null) {
            throw new IllegalArgumentException("Illegal outer class owner");
        }
        if (string3 != null) {
            CheckMethodAdapter.checkMethodDescriptor(this.version, string3);
        }
        super.visitOuterClass(string, string2, string3);
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n2) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(this.version, string, "class name");
        if (string2 != null) {
            CheckMethodAdapter.checkInternalName(this.version, string2, "outer class name");
        }
        if (string3 != null) {
            int n3;
            for (n3 = 0; n3 < string3.length() && Character.isDigit(string3.charAt(n3)); ++n3) {
            }
            if (n3 == 0 || n3 < string3.length()) {
                CheckMethodAdapter.checkIdentifier(this.version, string3, n3, -1, "inner class name");
            }
        }
        CheckClassAdapter.checkAccess(n2, 30239);
        super.visitInnerClass(string, string2, string3, n2);
    }

    @Override
    public RecordComponentVisitor visitRecordComponent(String string, String string2, String string3) {
        this.checkState();
        CheckMethodAdapter.checkUnqualifiedName(this.version, string, "record component name");
        CheckMethodAdapter.checkDescriptor(this.version, string2, false);
        if (string3 != null) {
            CheckClassAdapter.checkFieldSignature(string3);
        }
        return new CheckRecordComponentAdapter(this.api, super.visitRecordComponent(string, string2, string3));
    }

    @Override
    public FieldVisitor visitField(int n2, String string, String string2, String string3, Object object) {
        this.checkState();
        CheckClassAdapter.checkAccess(n2, 184543);
        CheckMethodAdapter.checkUnqualifiedName(this.version, string, "field name");
        CheckMethodAdapter.checkDescriptor(this.version, string2, false);
        if (string3 != null) {
            CheckClassAdapter.checkFieldSignature(string3);
        }
        if (object != null) {
            CheckMethodAdapter.checkConstant(object);
        }
        return new CheckFieldAdapter(this.api, super.visitField(n2, string, string2, string3, object));
    }

    @Override
    public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        CheckMethodAdapter checkMethodAdapter;
        this.checkState();
        CheckClassAdapter.checkMethodAccess(this.version, n2, 171519);
        if (!"<init>".equals(string) && !"<clinit>".equals(string)) {
            CheckMethodAdapter.checkMethodIdentifier(this.version, string, "method name");
        }
        CheckMethodAdapter.checkMethodDescriptor(this.version, string2);
        if (string3 != null) {
            CheckClassAdapter.checkMethodSignature(string3);
        }
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                CheckMethodAdapter.checkInternalName(this.version, stringArray[i2], CheckClassAdapter.stringConcat$2(i2));
            }
        }
        MethodVisitor methodVisitor = super.visitMethod(n2, string, string2, string3, stringArray);
        if (this.checkDataFlow) {
            if (this.cv instanceof ClassWriter) {
                methodVisitor = new CheckMethodAdapter.MethodWriterWrapper(this.api, this.version, (ClassWriter)this.cv, methodVisitor);
            }
            checkMethodAdapter = new CheckMethodAdapter(this.api, n2, string, string2, methodVisitor, this.labelInsnIndices);
        } else {
            checkMethodAdapter = new CheckMethodAdapter(this.api, methodVisitor, this.labelInsnIndices);
        }
        checkMethodAdapter.version = this.version;
        return checkMethodAdapter;
    }

    private static /* synthetic */ String stringConcat$2(int n2) {
        return "exception name at index " + n2;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
        this.checkState();
        CheckMethodAdapter.checkDescriptor(this.version, string, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(string, bl2));
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        this.checkState();
        int n3 = new TypeReference(n2).getSort();
        if (n3 != 0 && n3 != 17 && n3 != 16) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$3(Integer.toHexString(n3)));
        }
        CheckClassAdapter.checkTypeRef(n2);
        CheckMethodAdapter.checkDescriptor(this.version, string, false);
        return new CheckAnnotationAdapter(super.visitTypeAnnotation(n2, typePath, string, bl2));
    }

    private static /* synthetic */ String stringConcat$3(String string) {
        return "Invalid type reference sort 0x" + string;
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.checkState();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attribute);
    }

    @Override
    public void visitEnd() {
        this.checkState();
        this.visitEndCalled = true;
        super.visitEnd();
    }

    private void checkState() {
        if (!this.visitCalled) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.visitEndCalled) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int n2, int n3) {
        if ((n2 & ~n3) != 0) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$4(n2));
        }
        int n4 = 7;
        if (Integer.bitCount(n2 & n4) > 1) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$5(n2));
        }
        if (Integer.bitCount(n2 & 0x410) > 1) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$6(n2));
        }
    }

    private static /* synthetic */ String stringConcat$4(int n2) {
        return "Invalid access flags: " + n2;
    }

    private static /* synthetic */ String stringConcat$5(int n2) {
        return "public, protected and private are mutually exclusive: " + n2;
    }

    private static /* synthetic */ String stringConcat$6(int n2) {
        return "final and abstract are mutually exclusive: " + n2;
    }

    private static void checkMethodAccess(int n2, int n3, int n4) {
        CheckClassAdapter.checkAccess(n3, n4);
        if ((n2 & 0xFFFF) < 61 && Integer.bitCount(n3 & 0xC00) > 1) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$7(n3));
        }
    }

    private static /* synthetic */ String stringConcat$7(int n2) {
        return "strictfp and abstract are mutually exclusive: " + n2;
    }

    static void checkFullyQualifiedName(int n2, String string, String string2) {
        try {
            int n3;
            int n4 = 0;
            while ((n3 = string.indexOf(46, n4 + 1)) != -1) {
                CheckMethodAdapter.checkIdentifier(n2, string, n4, n3, null);
                n4 = n3 + 1;
            }
            CheckMethodAdapter.checkIdentifier(n2, string, n4, string.length(), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$8(string2, string), illegalArgumentException);
        }
    }

    private static /* synthetic */ String stringConcat$8(String string, String string2) {
        return "Invalid " + string + " (must be a fully qualified name): " + string2;
    }

    public static void checkClassSignature(String string) {
        int n2 = 0;
        if (CheckClassAdapter.getChar(string, 0) == '<') {
            n2 = CheckClassAdapter.checkTypeParameters(string, n2);
        }
        n2 = CheckClassAdapter.checkClassTypeSignature(string, n2);
        while (CheckClassAdapter.getChar(string, n2) == 'L') {
            n2 = CheckClassAdapter.checkClassTypeSignature(string, n2);
        }
        if (n2 != string.length()) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$9(string, n2));
        }
    }

    private static /* synthetic */ String stringConcat$9(String string, int n2) {
        return string + ERROR_AT + n2;
    }

    public static void checkMethodSignature(String string) {
        int n2 = 0;
        if (CheckClassAdapter.getChar(string, 0) == '<') {
            n2 = CheckClassAdapter.checkTypeParameters(string, n2);
        }
        n2 = CheckClassAdapter.checkChar('(', string, n2);
        while ("ZCBSIFJDL[T".indexOf(CheckClassAdapter.getChar(string, n2)) != -1) {
            n2 = CheckClassAdapter.checkJavaTypeSignature(string, n2);
        }
        n2 = CheckClassAdapter.getChar(string, n2 = CheckClassAdapter.checkChar(')', string, n2)) == 'V' ? ++n2 : CheckClassAdapter.checkJavaTypeSignature(string, n2);
        while (CheckClassAdapter.getChar(string, n2) == '^') {
            if (CheckClassAdapter.getChar(string, ++n2) == 'L') {
                n2 = CheckClassAdapter.checkClassTypeSignature(string, n2);
                continue;
            }
            n2 = CheckClassAdapter.checkTypeVariableSignature(string, n2);
        }
        if (n2 != string.length()) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$10(string, n2));
        }
    }

    private static /* synthetic */ String stringConcat$10(String string, int n2) {
        return string + ERROR_AT + n2;
    }

    public static void checkFieldSignature(String string) {
        int n2 = CheckClassAdapter.checkReferenceTypeSignature(string, 0);
        if (n2 != string.length()) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$11(string, n2));
        }
    }

    private static /* synthetic */ String stringConcat$11(String string, int n2) {
        return string + ERROR_AT + n2;
    }

    private static int checkTypeParameters(String string, int n2) {
        int n3 = n2;
        n3 = CheckClassAdapter.checkChar('<', string, n3);
        n3 = CheckClassAdapter.checkTypeParameter(string, n3);
        while (CheckClassAdapter.getChar(string, n3) != '>') {
            n3 = CheckClassAdapter.checkTypeParameter(string, n3);
        }
        return n3 + 1;
    }

    private static int checkTypeParameter(String string, int n2) {
        int n3 = n2;
        n3 = CheckClassAdapter.checkSignatureIdentifier(string, n3);
        if ("L[T".indexOf(CheckClassAdapter.getChar(string, n3 = CheckClassAdapter.checkChar(':', string, n3))) != -1) {
            n3 = CheckClassAdapter.checkReferenceTypeSignature(string, n3);
        }
        while (CheckClassAdapter.getChar(string, n3) == ':') {
            n3 = CheckClassAdapter.checkReferenceTypeSignature(string, n3 + 1);
        }
        return n3;
    }

    private static int checkReferenceTypeSignature(String string, int n2) {
        switch (CheckClassAdapter.getChar(string, n2)) {
            case 'L': {
                return CheckClassAdapter.checkClassTypeSignature(string, n2);
            }
            case '[': {
                return CheckClassAdapter.checkJavaTypeSignature(string, n2 + 1);
            }
        }
        return CheckClassAdapter.checkTypeVariableSignature(string, n2);
    }

    private static int checkClassTypeSignature(String string, int n2) {
        int n3 = n2;
        n3 = CheckClassAdapter.checkChar('L', string, n3);
        n3 = CheckClassAdapter.checkSignatureIdentifier(string, n3);
        while (CheckClassAdapter.getChar(string, n3) == '/') {
            n3 = CheckClassAdapter.checkSignatureIdentifier(string, n3 + 1);
        }
        if (CheckClassAdapter.getChar(string, n3) == '<') {
            n3 = CheckClassAdapter.checkTypeArguments(string, n3);
        }
        while (CheckClassAdapter.getChar(string, n3) == '.') {
            if (CheckClassAdapter.getChar(string, n3 = CheckClassAdapter.checkSignatureIdentifier(string, n3 + 1)) != '<') continue;
            n3 = CheckClassAdapter.checkTypeArguments(string, n3);
        }
        return CheckClassAdapter.checkChar(';', string, n3);
    }

    private static int checkTypeArguments(String string, int n2) {
        int n3 = n2;
        n3 = CheckClassAdapter.checkChar('<', string, n3);
        n3 = CheckClassAdapter.checkTypeArgument(string, n3);
        while (CheckClassAdapter.getChar(string, n3) != '>') {
            n3 = CheckClassAdapter.checkTypeArgument(string, n3);
        }
        return n3 + 1;
    }

    private static int checkTypeArgument(String string, int n2) {
        int n3 = n2;
        char c2 = CheckClassAdapter.getChar(string, n3);
        if (c2 == '*') {
            return n3 + 1;
        }
        if (c2 == '+' || c2 == '-') {
            ++n3;
        }
        return CheckClassAdapter.checkReferenceTypeSignature(string, n3);
    }

    private static int checkTypeVariableSignature(String string, int n2) {
        int n3 = n2;
        n3 = CheckClassAdapter.checkChar('T', string, n3);
        n3 = CheckClassAdapter.checkSignatureIdentifier(string, n3);
        return CheckClassAdapter.checkChar(';', string, n3);
    }

    private static int checkJavaTypeSignature(String string, int n2) {
        int n3 = n2;
        switch (CheckClassAdapter.getChar(string, n3)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n3 + 1;
            }
        }
        return CheckClassAdapter.checkReferenceTypeSignature(string, n3);
    }

    private static int checkSignatureIdentifier(String string, int n2) {
        int n3 = n2;
        while (n3 < string.length() && ".;[/<>:".indexOf(string.codePointAt(n3)) == -1) {
            n3 = string.offsetByCodePoints(n3, 1);
        }
        if (n3 == n2) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$12(string, n2));
        }
        return n3;
    }

    private static /* synthetic */ String stringConcat$12(String string, int n2) {
        return string + ": identifier expected at index " + n2;
    }

    private static int checkChar(char c2, String string, int n2) {
        if (CheckClassAdapter.getChar(string, n2) == c2) {
            return n2 + 1;
        }
        throw new IllegalArgumentException(CheckClassAdapter.stringConcat$13(string, c2, n2));
    }

    private static /* synthetic */ String stringConcat$13(String string, char c2, int n2) {
        return string + ": '" + c2 + "' expected at index " + n2;
    }

    private static char getChar(String string, int n2) {
        return n2 < string.length() ? string.charAt(n2) : (char)'\u0000';
    }

    static void checkTypeRef(int n2) {
        int n3 = 0;
        switch (n2 >>> 24) {
            case 0: 
            case 1: 
            case 22: {
                n3 = -65536;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                n3 = -16777216;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 66: {
                n3 = -256;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                n3 = -16776961;
                break;
            }
        }
        if (n3 == 0 || (n2 & ~n3) != 0) {
            throw new IllegalArgumentException(CheckClassAdapter.stringConcat$14(Integer.toHexString(n2)));
        }
    }

    private static /* synthetic */ String stringConcat$14(String string) {
        return "Invalid type reference 0x" + string;
    }

    private static String packageName(String string) {
        int n2 = string.lastIndexOf(47);
        if (n2 == -1) {
            return "";
        }
        return string.substring(0, n2);
    }

    public static void main(String[] stringArray) throws IOException {
        CheckClassAdapter.main(stringArray, new PrintWriter(System.err, true));
    }

    static void main(String[] stringArray, PrintWriter printWriter) throws IOException {
        ClassReader classReader;
        block6: {
            block5: {
                if (stringArray.length != 1) {
                    printWriter.println(USAGE);
                    return;
                }
                if (!stringArray[0].endsWith(".class")) break block5;
                FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
                try {
                    classReader = new ClassReader(fileInputStream);
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (Throwable throwable3) {
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable4 = throwable3;
                    }
                    throw throwable2;
                }
                ((InputStream)fileInputStream).close();
                break block6;
            }
            classReader = new ClassReader(stringArray[0]);
        }
        CheckClassAdapter.verify(classReader, false, printWriter);
    }

    public static void verify(ClassReader classReader, boolean bl2, PrintWriter printWriter) {
        CheckClassAdapter.verify(classReader, null, bl2, printWriter);
    }

    public static void verify(ClassReader classReader, ClassLoader classLoader, boolean bl2, PrintWriter printWriter) {
        ClassNode classNode = new ClassNode();
        classReader.accept(new CheckClassAdapter(0x10A0000, classNode, false){}, 2);
        Type type = classNode.superName == null ? null : Type.getObjectType(classNode.superName);
        List<MethodNode> list = classNode.methods;
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (String object : classNode.interfaces) {
            arrayList.add(Type.getObjectType(object));
        }
        for (MethodNode methodNode : list) {
            SimpleVerifier simpleVerifier = new SimpleVerifier(Type.getObjectType(classNode.name), type, arrayList, (classNode.access & 0x200) != 0);
            Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(simpleVerifier);
            if (classLoader != null) {
                simpleVerifier.setClassLoader(classLoader);
            }
            try {
                analyzer.analyze(classNode.name, methodNode);
            }
            catch (AnalyzerException analyzerException) {
                analyzerException.printStackTrace(printWriter);
            }
            if (!bl2) continue;
            CheckClassAdapter.printAnalyzerResult(methodNode, analyzer, printWriter);
        }
        printWriter.flush();
    }

    static void printAnalyzerResult(MethodNode methodNode, Analyzer<BasicValue> analyzer, PrintWriter printWriter) {
        Textifier textifier = new Textifier();
        TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor(textifier);
        printWriter.println(CheckClassAdapter.stringConcat$15(methodNode.name, methodNode.desc));
        for (int i2 = 0; i2 < methodNode.instructions.size(); ++i2) {
            methodNode.instructions.get(i2).accept(traceMethodVisitor);
            StringBuilder object = new StringBuilder();
            Frame<BasicValue> frame = analyzer.getFrames()[i2];
            if (frame == null) {
                object.append('?');
            } else {
                int n2;
                for (n2 = 0; n2 < frame.getLocals(); ++n2) {
                    object.append(CheckClassAdapter.getUnqualifiedName(frame.getLocal(n2).toString())).append(' ');
                }
                object.append(" : ");
                for (n2 = 0; n2 < frame.getStackSize(); ++n2) {
                    object.append(CheckClassAdapter.getUnqualifiedName(frame.getStack(n2).toString())).append(' ');
                }
            }
            while (object.length() < methodNode.maxStack + methodNode.maxLocals + 1) {
                object.append(' ');
            }
            printWriter.print(Integer.toString(i2 + 100000).substring(1));
            printWriter.print(CheckClassAdapter.stringConcat$16(object, textifier.text.get(textifier.text.size() - 1)));
        }
        for (TryCatchBlockNode tryCatchBlockNode : methodNode.tryCatchBlocks) {
            tryCatchBlockNode.accept(traceMethodVisitor);
            printWriter.print(CheckClassAdapter.stringConcat$17(textifier.text.get(textifier.text.size() - 1)));
        }
        printWriter.println();
    }

    private static /* synthetic */ String stringConcat$15(String string, String string2) {
        return string + string2;
    }

    private static /* synthetic */ String stringConcat$16(StringBuilder stringBuilder, Object object) {
        return " " + stringBuilder + " : " + object;
    }

    private static /* synthetic */ String stringConcat$17(Object object) {
        return " " + object;
    }

    private static String getUnqualifiedName(String string) {
        int n2;
        int n3 = string.lastIndexOf(47);
        if (n3 == -1) {
            return string;
        }
        int n4 = string.length();
        if (string.charAt(n4 - 1) == ';') {
            --n4;
        }
        if ((n2 = string.lastIndexOf(91)) == -1) {
            return string.substring(n3 + 1, n4);
        }
        return CheckClassAdapter.stringConcat$18(string.substring(0, n2 + 1), string.substring(n3 + 1, n4));
    }

    private static /* synthetic */ String stringConcat$18(String string, String string2) {
        return string + string2;
    }
}

