/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.apps;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.RouteDiscoveryListener;
import com.contrastsecurity.agent.apps.java.c;
import com.contrastsecurity.agent.apps.java.codeinfo.b;
import com.contrastsecurity.agent.apps.java.codeinfo.d;
import com.contrastsecurity.agent.apps.java.e;
import com.contrastsecurity.agent.classloader.b;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Purgeable;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.ConfigUpdatable;
import com.contrastsecurity.agent.config.m;
import com.contrastsecurity.agent.config.q;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.l;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.opentelemetry.OtelGlobalConfig;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.i;
import com.contrastsecurity.agent.plugins.security.RegexSecurityControls;
import com.contrastsecurity.agent.s.A;
import com.contrastsecurity.agent.telemetry.h;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Singleton
@DontObfuscate
public class ApplicationManager
implements Purgeable {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationManager.class);
    private final AtomicReference<Application.a> defaultAppRef;
    private final Map<String, Application> applicationKeys;
    private final ConcurrentReferenceHashMap<ClassLoader, Set<Application>> applicationClassLoaders;
    private final i pluginManager;
    private final A serverInfo;
    private final com.contrastsecurity.agent.config.e config;
    private final a jarAnalyzerFactory;
    private final RouteDiscoveryListener routeDiscoveryListener;
    private boolean isStandaloneMode;
    private final com.contrastsecurity.agent.classloader.b classLoaderStrategy;
    private final m effectiveConfigListener;
    private final com.contrastsecurity.agent.n.c eventListener;
    private final OtelGlobalConfig otelGlobalConfig;
    private final RegexSecurityControls regexSecurityControls;
    @n
    static final String GAUGE_NUMBER_APPLICATIONS = "numberOfApplications";

    public ApplicationManager(A a2, ConfigUpdatable configUpdatable, b b2, i i2, Clock clock, RouteDiscoveryListener routeDiscoveryListener, m m2, h h2, com.contrastsecurity.agent.n.c c2, OtelGlobalConfig otelGlobalConfig) {
        this(a2, configUpdatable, b2, i2, clock, routeDiscoveryListener, m2, h2.d(), c2, otelGlobalConfig);
    }

    @n
    public ApplicationManager(A a2, ConfigUpdatable configUpdatable, b b2, i i2, Clock clock, RouteDiscoveryListener routeDiscoveryListener, m m2, TelemetryMetrics telemetryMetrics, com.contrastsecurity.agent.n.c c2, OtelGlobalConfig otelGlobalConfig) {
        this(a2, configUpdatable, b2, i2, clock, routeDiscoveryListener, new Application.a(configUpdatable, c2, otelGlobalConfig), m2, telemetryMetrics, c2, otelGlobalConfig);
    }

    @n
    ApplicationManager(A a2, ConfigUpdatable configUpdatable, b b2, i i2, Clock clock, RouteDiscoveryListener routeDiscoveryListener, Application.a a3, m m2, TelemetryMetrics telemetryMetrics, com.contrastsecurity.agent.n.c c2, OtelGlobalConfig otelGlobalConfig) {
        this.pluginManager = Objects.requireNonNull(i2);
        this.serverInfo = Objects.requireNonNull(a2);
        this.config = Objects.requireNonNull(configUpdatable);
        this.routeDiscoveryListener = Objects.requireNonNull(routeDiscoveryListener);
        this.defaultAppRef = new AtomicReference<Application.a>(Objects.requireNonNull(a3));
        this.jarAnalyzerFactory = new a(Objects.requireNonNull(b2), clock, configUpdatable);
        this.applicationKeys = new ConcurrentHashMap<String, Application>();
        this.applicationClassLoaders = new ConcurrentReferenceHashMap(10, ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.STRONG);
        this.classLoaderStrategy = new b.a();
        if (this.defaultAppRef.get().a()) {
            this.enableStandaloneModeFromConfig(null, null);
        }
        this.effectiveConfigListener = m2;
        configUpdatable.initializeEffectiveConfigUpdateListener(this.effectiveConfigListener);
        telemetryMetrics.newGauge(GAUGE_NUMBER_APPLICATIONS, TelemetryMetrics.TelemetryCategory.ENVIRONMENT_PARAMETERS).a("Describes the number of applications currently served by this Agent instance.").a(this, object -> this.size()).a();
        this.eventListener = Objects.requireNonNull(c2);
        this.otelGlobalConfig = Objects.requireNonNull(otelGlobalConfig);
        this.regexSecurityControls = new RegexSecurityControls();
    }

    @Override
    public void purgeStale() {
        this.jarAnalyzerFactory.purgeStale();
        this.applicationClassLoaders.purgeStaleEntries();
    }

    @Override
    public int purgeableCount() {
        return this.jarAnalyzerFactory.purgeableCount();
    }

    public Application enableStandaloneModeFromEmbedded(String string, String string2, com.contrastsecurity.agent.plugins.frameworks.h h2) {
        return this.enableStandaloneMode(string, string2, "EMBEDDED_" + h2.toString());
    }

    public Application enableStandaloneModeFromConfig(String string, String string2) {
        return this.enableStandaloneMode(string, string2, "CONFIG");
    }

    private Application enableStandaloneMode(String string, String string2, String string3) {
        if (this.isStandaloneMode) {
            logger.debug("Standalone mode already turned on, attempted for appName={}, contextPath={}, reason={}", string, string2, string3);
            return this.defaultAppRef.get().b();
        }
        logger.debug("Enabling standalone app mode: appName={}, contextPath={}, reason={}", string, string2, string3);
        Application application = this.defaultAppRef.get().b();
        this.defaultAppRef.get().a(string, string2, this.config);
        this.updateClassLoaders(application);
        this.isStandaloneMode = true;
        return this.defaultAppRef.get().b();
    }

    public Application current(Application application) {
        if (application == null) {
            ContrastContext.current().application(null);
            return null;
        }
        Application application2 = this.defaultAppRef.get().b();
        if (application == application2) {
            return application;
        }
        ContrastContext.current().application(application);
        return this.isStandaloneMode ? application2 : application;
    }

    public Application current() {
        Application application = this._current();
        return application == null || application.isUnwanted() ? null : application;
    }

    private Application _current() {
        if (this.isStandaloneMode) {
            return this.defaultAppRef.get().b();
        }
        Application application = ContrastContext.current().application();
        if (application != null) {
            return application;
        }
        Collection<Application> collection = this.findByClassLoader(l.a(Thread.currentThread()));
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        return null;
    }

    public Application createApplication(String string, String string2, String string3, String string4, String string5, String string6, ClassLoader classLoader, Application.InventoryProvider inventoryProvider) {
        com.contrastsecurity.agent.context.c c2 = new com.contrastsecurity.agent.context.c();
        if (StringUtils.isNotBlank(string4)) {
            if (q.a(string4)) {
                this.config.initializeApplicationConfig(c2, string4);
            } else {
                logger.error(q.c(string4));
            }
        }
        ClassLoader classLoader2 = classLoader == null ? l.a(Thread.currentThread()) : classLoader;
        Application application = new Application(string, string2, string3, this.config, string5, string6, inventoryProvider, c2, classLoader2, this.eventListener, this.otelGlobalConfig);
        logger.debug("Created new application {}", (Object)application);
        String string7 = StringUtils.trimToNull(this.config.getOrNull(c2, ConfigProperty.APPLICATION_NAME));
        if (!this.applicationKeys.isEmpty() && !this.isStandaloneMode && StringUtils.isNotBlank(string7)) {
            String string8 = "Multiple apps detected with the same name on the same server. Indicates misuse of `contrast.application.name`. This action can cause issues with reporting data to TeamServer. This behavior can be fixed by grouping via application tags. More information found here: https://support.contrastsecurity.com/hc/en-us/articles/360052187171-Multi-Application-configuration-with-Contrast-Profiles";
            com.contrastsecurity.agent.logging.a.c("APPLICATION_NAME_MISUSED", logger, "Multiple apps detected with the same name on the same server. Indicates misuse of `contrast.application.name`. This action can cause issues with reporting data to TeamServer. This behavior can be fixed by grouping via application tags. More information found here: https://support.contrastsecurity.com/hc/en-us/articles/360052187171-Multi-Application-configuration-with-Contrast-Profiles");
        }
        this.applicationKeys.put(application.getKey(), application);
        this.updateClassLoaders(application, classLoader2);
        if (this.isStandaloneMode) {
            logger.debug("Marking application {} as unwanted because it is not the default app and the agent is in standalone mode", (Object)application);
            application.markUnwanted();
            this.defaultAppRef.get().c();
        }
        this.effectiveConfigListener.a(application);
        logger.debug("App {} has been created and is ready for creation on remote server", (Object)application);
        return application;
    }

    public Application findByKey(String string) {
        if (string == null || this.applicationKeys.isEmpty()) {
            logger.trace("Key was null or there were no applications, key: {}", (Object)string);
            return null;
        }
        Application application = this.applicationKeys.get(StringUtils.defaultIfBlank(StringUtils.trimToEmpty(string), "/"));
        logger.trace("ApplicationManager#findByKey: key: {}, app: {}", (Object)string, (Object)application);
        return application;
    }

    public Collection<Application> findByClassLoader(ClassLoader classLoader) {
        Collection collection;
        if (!this.applicationClassLoaders.keys().hasMoreElements()) {
            return Collections.emptySet();
        }
        if (classLoader == null) {
            logger.trace("ClassLoader was null, assuming Bootstrap ClassLoader and returning all apps");
            collection = this.applicationKeys.values();
        } else {
            collection = this.applicationClassLoaders.getOrDefault(classLoader, Collections.emptySet());
        }
        logger.trace("ApplicationManager#findByClassLoader: classLoader: {}, apps: {}", (Object)classLoader, (Object)collection);
        return Collections.unmodifiableCollection(collection);
    }

    public int size() {
        return this.isStandaloneMode ? 1 : this.applicationKeys.size();
    }

    public Collection<Application> getApplications() {
        return this.isStandaloneMode ? Collections.singleton(this.defaultAppRef.get().b()) : Collections.unmodifiableCollection(this.applicationKeys.values());
    }

    public void onApplicationUpdate(Application application) {
        if (application == null || application.isUnwanted()) {
            return;
        }
        this.routeDiscoveryListener.onRoutesDiscovered(application.getUnreportedDiscoveredRoutes(), application);
    }

    public void inventory(com.contrastsecurity.agent.plugins.frameworks.l l2, Application application) {
        if (!application.getState().a() && !this.isStandaloneMode) {
            logger.debug("Application is not ready or has already been inventoried: {}", (Object)application);
        }
        if (this.isStandaloneMode) {
            Application.a a2 = this.defaultAppRef.get();
            for (Application application2 : this.applicationKeys.values()) {
                application2.created();
                if ((!application2.getState().a() || !this._inventory(l2, application2)) && !application2.isDirty()) continue;
                a2.a(application2);
            }
        } else {
            this.defaultAppRef.get().d();
        }
        this._inventory(l2, application);
    }

    private boolean _inventory(com.contrastsecurity.agent.plugins.frameworks.l l2, Application application) {
        if (application.startInventory()) {
            if (com.contrastsecurity.agent.apps.e.a(this.config, ConfigProperty.INVENTORY_LIBRARIES)) {
                this.determineLibrariesByFramework(l2, application);
            } else {
                logger.debug("Ignoring framework library analysis");
            }
            application.inventoried();
            logger.debug("Application successfully inventoried: {}", (Object)application);
            for (ContrastPlugin contrastPlugin : this.pluginManager.getPlugins()) {
                contrastPlugin.onApplicationInventoried(application);
            }
            return true;
        }
        return false;
    }

    private void updateClassLoaders(Application application) {
        this.updateClassLoaders(application, null);
    }

    private void updateClassLoaders(Application application, ClassLoader classLoader2) {
        ClassLoader classLoader3;
        ClassLoader classLoader4 = classLoader3 = classLoader2 == null ? l.a(Thread.currentThread()) : classLoader2;
        if (classLoader3 == null) {
            logger.debug("ClassLoader was null, assuming Bootstrap ClassLoader");
            return;
        }
        this.classLoaderStrategy.a(classLoader3).forEach(classLoader -> this.applicationClassLoaders.merge((ClassLoader)classLoader, Collections.singleton(application), (set, set2) -> Stream.of(set, set2).flatMap(Collection::stream).collect(Collectors.toSet())));
    }

    @n
    Set<d> getLibraryFinders(com.contrastsecurity.agent.plugins.frameworks.l l2, Application application) {
        LinkedHashSet<d> linkedHashSet = new LinkedHashSet<d>();
        List<com.contrastsecurity.agent.plugins.frameworks.n> list = l2.c();
        com.contrastsecurity.agent.apps.java.codeinfo.a a2 = this.jarAnalyzerFactory.a();
        if (this.isStandaloneMode || this.config.getBoolean(application.context(), ConfigProperty.CLASSPATH_LIBS)) {
            linkedHashSet.add(new c(this.serverInfo, a2));
        }
        for (com.contrastsecurity.agent.plugins.frameworks.n object : list) {
            object.a(linkedHashSet, application, a2);
        }
        String string = this.config.getOrNull(application.context(), ConfigProperty.EXTERNAL_LIB_DIR);
        if (StringUtils.isNotBlank(string)) {
            List<String> list2 = Collections.unmodifiableList(Arrays.asList(string.split(File.pathSeparator)));
            ArrayList<File> arrayList = new ArrayList<File>();
            for (String string2 : list2) {
                File file = new File(string2);
                if (file.exists() && file.isDirectory()) {
                    arrayList.add(new File(string2));
                    continue;
                }
                logger.warn("Skipping external library directory: {} because it does not exist or is not a directory.", (Object)string2);
            }
            linkedHashSet.add(new e(a2, arrayList));
        }
        logger.debug("Application {} will use the following LibraryFinders: {}", (Object)application, (Object)linkedHashSet);
        return linkedHashSet;
    }

    private void determineLibrariesByFramework(com.contrastsecurity.agent.plugins.frameworks.l l2, Application application) {
        Set<d> set = this.getLibraryFinders(l2, application);
        for (d d2 : set) {
            d2.a(application);
        }
    }

    public RouteDiscoveryListener getRouteDiscoveryListener() {
        return this.routeDiscoveryListener;
    }

    public RegexSecurityControls regexSecurityControls() {
        return this.regexSecurityControls;
    }

    private static final class a
    implements Purgeable {
        private final b a;
        private final long b;
        private final Clock c;
        private com.contrastsecurity.agent.apps.java.codeinfo.a d;
        private long e;

        private a(b b2, Clock clock, com.contrastsecurity.agent.config.e e2) {
            this.a = b2;
            this.c = clock;
            this.b = e2.getLong(ConfigProperty.APPMGR_JARANALYZER_TTL);
        }

        private synchronized com.contrastsecurity.agent.apps.java.codeinfo.a a() {
            if (this.d == null) {
                this.e = this.c.now();
                this.d = this.a.a();
            }
            return this.d;
        }

        @Override
        public synchronized void purgeStale() {
            if (this.c.now() - this.e >= this.b) {
                this.d = null;
            }
        }

        @Override
        public int purgeableCount() {
            return this.d == null ? 0 : 1;
        }
    }
}

