/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.boot;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class DenylistedProcessCheck {
    private static final String CATALINA_STARTUP_BOOTSTRAP_STOP = "catalina.startup.Bootstrap stop";
    private static final String KARAF_INDICATOR = "org.apache.karaf";
    private static final Set<String> JAVA_TOOLS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("com.sun.tools.hat.Main", "sun.jvm.hotspot.jdi.SADebugServer", "sun.applet.Main", "jdk.tools.jaotc.Main", "sun.tools.jar.Main", "sun.security.tools.jarsigner.Main", "com.sun.tools.javac.Main", "jdk.javadoc.internal.tool.Main", "com.sun.tools.javah.Main", "com.sun.tools.javap.Main", "sun.tools.jcmd.JCmd", "sun.tools.jconsole.JConsole", "com.sun.tools.example.debug.tty.TTY", "com.sun.tools.jdeprscan.Main", "com.sun.tools.jdeps.Main", "jdk.jfr.internal.tool.Main", "sun.jvm.hotspot.SALauncher", "jdk.tools.jimage.Main", "sun.tools.jinfo.JInfo", "jdk.nashorn.tools.jjs.Main", "jdk.tools.jlink.internal.Main", "sun.tools.jmap.JMap", "jdk.tools.jmod.Main", "jdk.jpackage.main.Main", "sun.tools.jps.Jps", "com.sun.tools.script.shell.Main", "jdk.internal.jshell.tool.JShellToolProvider", "sun.tools.jstack.JStack", "sun.tools.jstat.Jstat", "sun.tools.jstatd.Jstatd", "sun.security.tools.keytool.Main", "com.sun.java.util.jar.pack.Driver", "sun.rmi.rmic.Main", "sun.rmi.server.Activation", "sun.rmi.registry.RegistryImpl", "sun.tools.serialver.SerialVer", "com.sun.tools.internal.ws.WsGen", "com.sun.tools.internal.ws.WsImport", "com.sun.tools.internal.xjc.Driver", "java.desktop/sun.applet.Main", "jdk.aot/jdk.tools.jaotc.Main", "jdk.jartool/sun.tools.jar.Main", "jdk.jartool/sun.security.tools.jarsigner.Main", "jdk.compiler/com.sun.tools.javac.Main", "jdk.javadoc/jdk.javadoc.internal.tool.Main", "jdk.compiler/com.sun.tools.javah.Main", "jdk.jdeps/com.sun.tools.javap.Main", "jdk.jcmd/sun.tools.jcmd.JCmd", "jdk.jconsole/sun.tools.jconsole.JConsole", "jdk.jdi/com.sun.tools.example.debug.tty.TTY", "jdk.jdeps/com.sun.tools.jdeprscan.Main", "jdk.jdeps/com.sun.tools.jdeps.Main", "jdk.jfr/jdk.jfr.internal.tool.Main", "jdk.hotspot.agent/sun.jvm.hotspot.SALauncher", "jdk.jlink/jdk.tools.jimage.Main", "jdk.jcmd/sun.tools.jinfo.JInfo", "jdk.scripting.nashorn.shell/jdk.nashorn.tools.jjs.Main", "jdk.jlink/jdk.tools.jlink.internal.Main", "jdk.jcmd/sun.tools.jmap.JMap", "jdk.jlink/jdk.tools.jmod.Main", "jdk.jpackage/jdk.jpackage.main.Main", "jdk.jcmd/sun.tools.jps.Jps", "java.scripting/com.sun.tools.script.shell.Main", "jdk.jshell/jdk.internal.jshell.tool.JShellToolProvider", "jdk.jcmd/sun.tools.jstack.JStack", "jdk.jcmd/sun.tools.jstat.Jstat", "jdk.jstatd/sun.tools.jstatd.Jstatd", "java.base/sun.security.tools.keytool.Main", "java.base/com.sun.java.util.jar.pack.Driver", "jdk.rmic/sun.rmi.rmic.Main", "java.rmi/sun.rmi.server.Activation", "java.rmi/sun.rmi.registry.RegistryImpl", "jdk.compiler/sun.tools.serialver.SerialVer", "jdk.xml.ws/com.sun.tools.internal.ws.WsGen", "jdk.xml.ws/com.sun.tools.internal.ws.WsImport", "jdk.xml.bind/com.sun.tools.internal.xjc.Driver")));

    private DenylistedProcessCheck() {
    }

    public static boolean isDenied(String cmd) {
        if (cmd == null) {
            return false;
        }
        return DenylistedProcessCheck.isJavaTooling(cmd) || DenylistedProcessCheck.isTomcat(cmd) || DenylistedProcessCheck.isKaraf(cmd);
    }

    private static boolean isJavaTooling(String cmd) {
        for (String tool : JAVA_TOOLS) {
            if (!cmd.startsWith(tool)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTomcat(String cmd) {
        return cmd.endsWith(CATALINA_STARTUP_BOOTSTRAP_STOP);
    }

    private static boolean isKaraf(String cmd) {
        return cmd.startsWith(KARAF_INDICATOR) && !cmd.endsWith(".main.Main");
    }
}

