/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.commons;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.util.ContrastAgentUtil;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

@DontObfuscate
public enum HeapUsage {
    NONE,
    DEEP,
    SHALLOW;


    public static HeapUsage supportsHeapProfiling(Object object, Class<?> clazz) {
        if (clazz.isArray()) {
            if (object instanceof Object[]) {
                return DEEP;
            }
            return SHALLOW;
        }
        if (HeapUsage.isConstantType(clazz)) {
            return NONE;
        }
        if (clazz.getAnnotation(SupportsHeapProfiling.class) != null) {
            return DEEP;
        }
        if (object instanceof LambdaSupportsShallowHeapProfiling) {
            return SHALLOW;
        }
        if (object instanceof LambdaSupportsDeepHeapProfiling) {
            return DEEP;
        }
        if (object instanceof StackTraceElement) {
            return SHALLOW;
        }
        String string = clazz.getTypeName();
        if (!string.startsWith("java.") && !string.startsWith("sun.")) {
            if (ContrastAgentUtil.isAgentClass(string)) {
                throw new UnsupportedOperationException(string + " does not support heap profiling.");
            }
            return SHALLOW;
        }
        if (object instanceof String || object instanceof StringBuilder || object instanceof StringBuffer || object instanceof CharBuffer || object instanceof Character || object instanceof Number || object instanceof Throwable || object instanceof File || object instanceof URI || Object.class.equals(clazz) || object instanceof Collection || object instanceof Map || object instanceof Map.Entry) {
            return DEEP;
        }
        Class<?> clazz2 = clazz.getDeclaringClass();
        if (HeapUsage.isInnerCollectionClass(clazz2)) {
            return DEEP;
        }
        Class<?> clazz3 = clazz.getEnclosingClass();
        if (HeapUsage.isInnerCollectionClass(clazz3)) {
            return DEEP;
        }
        if (object instanceof Reference || object instanceof ReferenceQueue || object instanceof Condition || object instanceof Lock || object instanceof AtomicBoolean || object instanceof AtomicReference || object instanceof AtomicMarkableReference || object instanceof AtomicStampedReference || object instanceof AtomicIntegerArray || object instanceof AtomicLongArray || object instanceof AtomicReferenceArray) {
            return DEEP;
        }
        return SHALLOW;
    }

    private static boolean isConstantType(Class<?> clazz) {
        return clazz.isEnum() || Class.class.equals(clazz);
    }

    private static boolean isInnerCollectionClass(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Map.Entry.class.isAssignableFrom(clazz);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @DontObfuscate
    public static @interface SupportsHeapProfiling {
        public HeapUsage implicitOuterReference() default HeapUsage.NONE;

        public Class<?>[] ownedCaches() default {};
    }

    @DontObfuscate
    public static interface LambdaSupportsShallowHeapProfiling {
    }

    @DontObfuscate
    public static interface LambdaSupportsDeepHeapProfiling {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    @DontObfuscate
    public static @interface Cacheable {
        public Class<?> cache();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    @DontObfuscate
    public static @interface Shallow {
        public Reason reason();

        @DontObfuscate
        public static enum Reason {
            AGENT_GLOBAL,
            JVM_GLOBAL;

        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    @DontObfuscate
    public static @interface Deep {
    }
}

