/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.context;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.b;
import com.contrastsecurity.agent.http.HttpContext;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.protect.ProtectContext;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.scope.ScopeProviderAssess;
import com.contrastsecurity.agent.scope.ScopeProviderAssessImpl;
import com.contrastsecurity.agent.scope.ScopeProviderImpl;

@DontObfuscate
public class ContrastContext
implements b<ContrastContext> {
    private final HttpContext http;
    private final ScopeProvider scopeProvider;
    private final ScopeProviderAssess scopeProviderAssess;
    protected static ThreadLocal<ContrastContext> CONTEXT;
    private Application application;
    private AssessmentContext assessment;
    private ProtectContext protect;
    private RootSpan observe;

    public static void enableThreadLocal() {
        CONTEXT = ThreadLocal.withInitial(ContrastContext::new);
    }

    protected ContrastContext() {
        this.http = new HttpContext();
        this.scopeProvider = new ScopeProviderImpl();
        this.scopeProviderAssess = new ScopeProviderAssessImpl(this.scopeProvider);
    }

    protected ContrastContext(ContrastContext contrastContext) {
        this.http = contrastContext.http().copy();
        this.application = contrastContext.application();
        this.assessment = contrastContext.assessment();
        this.protect = contrastContext.protect();
        this.observe = contrastContext.observe();
        this.scopeProvider = new ScopeProviderImpl();
        this.scopeProviderAssess = new ScopeProviderAssessImpl(this.scopeProvider);
    }

    public void clear() {
        this.application = null;
        this.assessment = null;
        this.protect = null;
        this.observe = null;
        this.http.clear();
    }

    public Application application() {
        return this.application;
    }

    public Application application(Application application) {
        this.application = application;
        return application;
    }

    public AssessmentContext assessment() {
        return this.assessment;
    }

    public AssessmentContext assessment(AssessmentContext assessmentContext) {
        this.assessment = assessmentContext;
        return assessmentContext;
    }

    public HttpContext http() {
        return this.http;
    }

    public RootSpan observe() {
        return this.observe;
    }

    public RootSpan observe(RootSpan rootSpan) {
        this.observe = rootSpan;
        return rootSpan;
    }

    public ProtectContext protect() {
        return this.protect;
    }

    public ProtectContext protect(ProtectContext protectContext) {
        this.protect = protectContext;
        return protectContext;
    }

    public ScopeProvider scopeProvider() {
        return this.scopeProvider;
    }

    public ScopeProviderAssess scopeProviderAssess() {
        return this.scopeProviderAssess;
    }

    @Override
    public ContrastContext copy() {
        return new ContrastContext(this);
    }

    public String toString() {
        return "ContrastContext{application=" + this.application + ", http=" + this.http + ", scopeProvider=" + this.scopeProvider + ", scopeProviderAssess=" + this.scopeProviderAssess + ", assessment=" + this.assessment + ", protect=" + this.protect + ", observe=" + this.observe + '}';
    }

    public static ContrastContext current() {
        return CONTEXT.get();
    }
}

