/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.contrastapi_v1_0;

import com.contrastsecurity.agent.contrastapi_v1_0.RequestMethod;
import java.util.Map;
import java.util.TreeMap;

public enum StandardRequestMethod implements RequestMethod
{
    ALL,
    CONNECT,
    DELETE,
    GET,
    HEAD,
    OPTIONS,
    PATCH,
    POST,
    PUT,
    TRACE,
    UNARY,
    CLIENTSTREAM,
    SERVERSTREAM,
    BIDISTREAM,
    WEBSOCKET,
    PROPFIND,
    PROPPATCH,
    MKCOL,
    COPY,
    MOVE,
    LOCK,
    UNLOCK,
    VERSION_CONTROL("VERSION-CONTROL"),
    REPORT,
    CHECKOUT,
    CHECKIN,
    UNCHECKOUT,
    MKWORKSPACE,
    UPDATE,
    LABEL,
    MERGE,
    BASELINE_CONTROL("BASELINE-CONTROL"),
    MKACTIVITY,
    ORDERPATCH,
    ACL,
    SEARCH,
    MKCALENDAR;

    private final String name;
    static final Map<String, RequestMethod> REQUEST_METHOD_MAP;

    private StandardRequestMethod(String string2) {
        this.name = string2;
    }

    private StandardRequestMethod() {
        this.name = this.name();
    }

    @Override
    public String methodName() {
        return this.name;
    }

    @Override
    public boolean isUnknownHeader() {
        return false;
    }

    public String toString() {
        return this.methodName();
    }

    static {
        REQUEST_METHOD_MAP = new TreeMap<String, RequestMethod>(String.CASE_INSENSITIVE_ORDER);
        for (StandardRequestMethod standardRequestMethod : StandardRequestMethod.values()) {
            REQUEST_METHOD_MAP.put(standardRequestMethod.methodName(), standardRequestMethod);
        }
    }
}

