/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.core;

import com.contrastsecurity.agent.Contrast;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.java.b;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.StartupTiming;
import com.contrastsecurity.agent.commons.Suppliers;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.WorkingDirectories;
import com.contrastsecurity.agent.core.a;
import com.contrastsecurity.agent.core.c;
import com.contrastsecurity.agent.d;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.i.g;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.i;
import com.contrastsecurity.agent.s.A;
import com.contrastsecurity.agent.s.B;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.services.f;
import com.contrastsecurity.agent.services.ngreporting.e;
import com.contrastsecurity.agent.startup.FatalStartupException;
import com.contrastsecurity.agent.startup.v;
import com.contrastsecurity.agent.startup.w;
import com.contrastsecurity.agent.startup.x;
import com.contrastsecurity.agent.startup.z;
import com.contrastsecurity.agent.telemetry.errors.o;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.util.H;
import com.contrastsecurity.agent.util.I;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.agent.util.PerfUtil;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.agent.util.Q;
import com.contrastsecurity.agent.util.j;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@DontObfuscate
public class ContrastEngine
implements i {
    private final i pluginManager;
    private final ScopeProvider scopeProvider;
    private d transformer;
    private final e legacyReportingService;
    private com.contrastsecurity.agent.services.a compositeServices;
    private final List<com.contrastsecurity.agent.services.a> injectedBackgroundServices;
    private final Instrumentation inst;
    private final com.contrastsecurity.agent.config.e config;
    private final com.contrastsecurity.agent.services.b executorServiceModule;
    private final Clock clock;
    private final WorkingDirectories directories;
    private final c failureStrategy;
    private final A server;
    private final Queue<b> classLoadEvents;
    private final com.contrastsecurity.agent.logging.c loggerManager;
    private final o errorEmitter;
    private final com.contrastsecurity.agent.telemetry.c startupTimingReporter;
    private final g hierarchyCache;
    private final List<x> startupTasks;
    private final TelemetryMetrics metrics;
    private final com.contrastsecurity.agent.h.a errorHandler;
    private static final Logger logger = LoggerFactory.getLogger(ContrastEngine.class);

    @Override
    public List<ContrastPlugin> getPlugins() {
        return this.pluginManager.getPlugins();
    }

    @Override
    public void forEachEnabled(Application application, HttpRequest httpRequest, Consumer<ContrastPlugin> consumer) {
        this.pluginManager.forEachEnabled(application, httpRequest, consumer);
    }

    @Override
    public void forEachDisabled(Application application, HttpRequest httpRequest, Consumer<ContrastPlugin> consumer) {
        this.pluginManager.forEachDisabled(application, httpRequest, consumer);
    }

    public o getErrorEmitter() {
        return this.errorEmitter;
    }

    public ContrastEngine(Instrumentation instrumentation, A a2, com.contrastsecurity.agent.config.e e2, List<x> list, Clock clock, List<com.contrastsecurity.agent.services.a> list2, i i2, e e3, ScopeProvider scopeProvider, WorkingDirectories workingDirectories, TelemetryMetrics telemetryMetrics, o o2, Queue<b> queue, com.contrastsecurity.agent.logging.c c2, com.contrastsecurity.agent.services.b b2, com.contrastsecurity.agent.telemetry.c c3, g g2, com.contrastsecurity.agent.h.a a3) {
        this.inst = Objects.requireNonNull(instrumentation);
        this.server = Objects.requireNonNull(a2);
        this.config = Objects.requireNonNull(e2);
        this.startupTasks = Lists.copy((Collection)Objects.requireNonNull(list));
        this.injectedBackgroundServices = list2;
        this.clock = Objects.requireNonNull(clock);
        this.pluginManager = Objects.requireNonNull(i2);
        this.executorServiceModule = Objects.requireNonNull(b2);
        this.legacyReportingService = Objects.requireNonNull(e3);
        this.scopeProvider = Objects.requireNonNull(scopeProvider);
        this.directories = Objects.requireNonNull(workingDirectories);
        this.metrics = Objects.requireNonNull(telemetryMetrics);
        this.classLoadEvents = Objects.requireNonNull(queue);
        this.loggerManager = Objects.requireNonNull(c2);
        this.errorEmitter = Objects.requireNonNull(o2);
        this.failureStrategy = c.a(e2.get(ConfigProperty.STARTUP_FAILURE_STRATEGY));
        this.startupTimingReporter = Objects.requireNonNull(c3);
        this.hierarchyCache = Objects.requireNonNull(g2);
        this.errorHandler = Objects.requireNonNull(a3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartupTiming startupTiming) throws FatalStartupException {
        Objects.requireNonNull(startupTiming);
        H h2 = I.b();
        Contrast.starting(this.directories);
        v v2 = this.startupContext();
        v2.a(this.errorHandler);
        h2.b();
        this.startupTimingReporter.a(PerfUtil.a.a, "init-working-dir", h2);
        h2.c();
        try {
            for (x x2 : this.startupTasks) {
                this.doStartupTask(x2, v2);
            }
        }
        catch (FatalStartupException fatalStartupException) {
            this.errorAndPointToLog();
            logger.error("Problem starting up Contrast", fatalStartupException);
            logger.error(this.failureStrategy.b());
            this.failureStrategy.a(fatalStartupException);
            this.ifWebSphereAddFallbackTransformer(v2);
            return;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            this.logUnexpectedError(throwable2, this.failureStrategy.b());
            this.failureStrategy.a(throwable2);
            return;
        }
        finally {
            h2.a();
            for (x x3 : this.startupTasks) {
                x3.onStartupEnd(v2);
            }
        }
        this.transformer = v2.a();
        try {
            this.initBackgroundServicesAndRegisterPlugins(h2, startupTiming);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable3 = throwable;
            PreConfigUtil.err("Error reading Contrast configuration or policy. Are you sure your XML is right? " + this.failureStrategy.b());
            this.failureStrategy.a(throwable3);
            throwable3.printStackTrace(System.err);
        }
    }

    private void ifWebSphereAddFallbackTransformer(v v2) {
        d d2 = v2.a();
        if (d2 == null && w.a(this.server)) {
            logger.debug("Running in WebSphere, PhoneHome to TeamServer failed, attempting to add fallback transformer");
            try {
                this.addWebSphereFallBackTransformer(v2);
                logger.debug("Added WebSphereFallbackTransformer");
                new z(this.errorEmitter, this.inst).onStartupBegin(v2);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                logger.warn("Unable to prepare to correct disabled TLS algorithms in WebSphere", exception2);
            }
        }
    }

    private void addWebSphereFallBackTransformer(v v2) {
        new com.contrastsecurity.agent.plugins.frameworks.websphere.a.a(this.config, this.server, this.hierarchyCache, this.scopeProvider, this.classLoadEvents, this.errorEmitter, this.inst, v2).a();
    }

    private v startupContext() {
        v v2 = new v();
        v2.a(this);
        return v2;
    }

    private void logUnexpectedError(Throwable throwable, String string) {
        this.errorAndPointToLog();
        throwable.printStackTrace();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string2 = stringWriter.toString();
        PreConfigUtil.err("Unexpected error starting up. " + string + " Exception message [1]: " + string2);
        throwable.printStackTrace(System.err);
        PreConfigUtil.out("Unexpected error starting up. " + string + " Exception message [2]:  " + string2);
    }

    private void doStartupTask(x x2, v v2) throws FatalStartupException {
        H h2 = I.b();
        x2.onStartupBegin(v2);
        h2.b();
        this.startupTimingReporter.a(PerfUtil.a.a, x2.getTaskName(), h2);
    }

    private void initBackgroundServicesAndRegisterPlugins(H h2, StartupTiming startupTiming) {
        logger.info("Installing Contrast plugins...");
        ArrayList<com.contrastsecurity.agent.services.a> arrayList = new ArrayList<com.contrastsecurity.agent.services.a>(this.injectedBackgroundServices);
        if (JVMUtils.isIBMJVM()) {
            logger.info("On IBM JVM, adding zombie watcher thread.");
            arrayList.add(new f(this.config, Suppliers.constant(this), this.errorEmitter, this.executorServiceModule));
        }
        this.compositeServices = new a(this.config, arrayList, this.clock);
        this.compositeServices.a(this.inst, this.pluginManager.getPlugins());
        this.pluginManager.handoffToJVM();
        this.sendServerInfoUpdate();
        this.logStartupMessages(h2, startupTiming);
        Contrast.active(this.directories);
    }

    private void logStartupMessages(H h2, StartupTiming startupTiming) {
        startupTiming.premainEndTimeNs(this.clock.nanoTime());
        long l2 = startupTiming.premainElapsedTimeMs();
        h2.b();
        this.startupTimingReporter.a(PerfUtil.a.a, "init-services-plugins", h2);
        PerfUtil.printStartupTimingMessage(String.format("All Startup Tasks: %s", j.a(l2)));
        logger.info("Beginning application...");
        PreConfigUtil.out("Starting JVM [" + l2 + "ms]");
        ScheduledExecutorService scheduledExecutorService = this.executorServiceModule.b();
        this.startupTimingReporter.b("startupTimeAgent", l2);
        this.metrics.scheduleStartupReporting(scheduledExecutorService, this.config.getLong(ConfigProperty.AGENT_TELEMETRY_INITIAL_DELAY), this.startupTimingReporter);
    }

    private void sendServerInfoUpdate() {
        B b2 = new B(null, true);
        this.legacyReportingService.a(b2);
    }

    private void errorAndPointToLog() {
        String string = this.config.get(ConfigProperty.LOGGER_LOCATION);
        PreConfigUtil.err("Contrast not enabled. Check log for details - " + string);
    }

    public synchronized void stop() {
        logger.info("Stopping Contrast...");
        Contrast.stopping(this.directories);
        if (this.compositeServices != null) {
            this.compositeServices.a();
        }
        this.pluginManager.deactivatePlugins();
        this.executorServiceModule.close();
        Contrast.inactive(this.directories);
        logger.info("Stopped");
        this.loggerManager.a(this.config.getLong(ConfigProperty.LOGGER_SHUTDOWN_TIMEOUT), TimeUnit.SECONDS);
    }

    public void deinstrument() {
        this.transformer.b();
        List<Class<?>> list = Arrays.stream(this.inst.getAllLoadedClasses()).filter(this.inst::isModifiableClass).collect(Collectors.toList());
        logger.info("De-instrumenting {} classes", (Object)list.size());
        Q.a(this.inst, this.errorEmitter, list);
    }

    @Override
    public void registerPlugin(ContrastPlugin contrastPlugin) {
        this.pluginManager.registerPlugin(contrastPlugin);
    }

    @Override
    public void activatePlugins() {
        this.pluginManager.activatePlugins();
    }

    @Override
    public void deactivatePlugins() {
        this.pluginManager.deactivatePlugins();
    }

    @Override
    public void handoffToJVM() {
        this.pluginManager.handoffToJVM();
    }

    @Override
    public List<com.contrastsecurity.agent.instr.a.c> getDenylistAwarePlugins() {
        return this.pluginManager.getDenylistAwarePlugins();
    }
}

