/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.b;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.http.b;
import com.contrastsecurity.agent.http.k;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

@DontObfuscate
public class HttpContext
implements b<HttpContext> {
    private HttpRequest request;
    private HttpResponse response;
    private Collection<k> requestBodyListeners;

    public HttpContext() {
        this(null, null);
    }

    public HttpContext(HttpRequest httpRequest, HttpResponse httpResponse) {
        this.request = httpRequest;
        this.response = httpResponse;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpRequest setRequest(HttpRequest httpRequest) {
        this.updateRequestCrumbs(httpRequest);
        this.request = httpRequest;
        return httpRequest;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public HttpResponse setResponse(HttpResponse httpResponse) {
        this.updateResponseCrumbs(httpResponse);
        this.response = httpResponse;
        return httpResponse;
    }

    public void set(HttpRequest httpRequest, HttpResponse httpResponse) {
        this.request = httpRequest;
        this.response = httpResponse;
    }

    public Collection<k> addRequestBodyListeners(Collection<k> collection) {
        if (collection == null) {
            return this.requestBodyListeners;
        }
        if (this.requestBodyListeners == null) {
            this.requestBodyListeners = new ArrayList<k>(collection.size());
        }
        this.requestBodyListeners.addAll(collection);
        return this.requestBodyListeners;
    }

    public Collection<k> getRequestBodyListeners() {
        return this.requestBodyListeners == null ? Collections.emptyList() : this.requestBodyListeners;
    }

    public void clear() {
        this.request = null;
        this.response = null;
        this.requestBodyListeners = null;
    }

    @Override
    public HttpContext copy() {
        return new HttpContext(this.request, this.response);
    }

    private void updateRequestCrumbs(HttpRequest httpRequest) {
        if (httpRequest == null) {
            HttpRequest httpRequest2 = this.getRequest();
            if (httpRequest2 != null) {
                httpRequest2.updateBreadCrumbs(b.b.c);
            }
        } else {
            httpRequest.updateBreadCrumbs(b.b.b);
        }
    }

    private void updateResponseCrumbs(HttpResponse httpResponse) {
        if (httpResponse == null) {
            HttpResponse httpResponse2 = this.response;
            if (httpResponse2 != null) {
                httpResponse2.updateBreadCrumbs(b.b.c);
            }
        } else {
            httpResponse.updateBreadCrumbs(b.b.b);
        }
    }

    public String toString() {
        return "HttpContext{request=" + this.request + ", response=" + this.response + '}';
    }
}

