/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.commons.Maps;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.MemoryBuffer;
import com.contrastsecurity.agent.http.ReplacedResponseChunk;
import com.contrastsecurity.agent.http.c;
import com.contrastsecurity.agent.http.d;
import com.contrastsecurity.agent.http.n;
import com.contrastsecurity.agent.messages.mq.HttpResponseDTM;
import com.contrastsecurity.agent.pool.ObjectPool;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@DontObfuscate
public abstract class HttpResponse
extends c {
    private final Map<String, List<String>> headers = new ConcurrentHashMap<String, List<String>>();
    private volatile d contentTypeHeader;
    private Charset charset;
    private final ObjectPool<MemoryBuffer> memoryBufferPool;
    public static final int ENCODING_UTF8 = 0;
    public static final int ENCODING_UTF16 = 1;
    public static final int ENCODING_UTF32 = 2;
    public static final int ENCODING_ASCII = 3;
    public static final int ENCODING_ISO88591 = 4;
    public static final int ENCODING_SYSTEM_DEFAULT = 5;
    private static final Logger logger = LoggerFactory.getLogger(HttpResponse.class);
    public static Map<Integer, String> CHARSET_MAP = Maps.builder().add(3, "ASCII").add(0, "UTF-8").add(1, "UTF-16").add(2, "UTF-32").add(4, "ISO-8859-1").add(5, Charset.defaultCharset().name()).build();

    public HttpResponse(ObjectPool<MemoryBuffer> objectPool) {
        super("response");
        this.memoryBufferPool = Objects.requireNonNull(objectPool);
    }

    public abstract int getStatus();

    protected abstract String frameworkContentType();

    protected abstract String frameworkCharacterEncoding();

    public final d getContentType() {
        if (this.contentTypeHeader != null) {
            return this.contentTypeHeader;
        }
        List<String> list = this.getHeaders().get(n.t.headerName());
        this.contentTypeHeader = list != null ? d.a(list.get(0)) : d.a(this.frameworkContentType(), this.frameworkCharacterEncoding());
        return this.contentTypeHeader;
    }

    @Override
    protected final Charset getCharset() {
        if (this.charset == null) {
            this.charset = this.getContentType().b();
        }
        return this.charset;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public HttpResponseDTM toHttpResponseDTM() {
        return HttpResponseDTM.builder().characterEncoding(this.getCharset().toString()).contentType(this.getContentType().a()).status(this.getStatus()).headers(this.getHeaders()).build();
    }

    public Object getOutputMechanism() {
        return null;
    }

    public void enterWritingScope(Object object) {
        this.startWriteToBuffer();
    }

    public void leaveWritingScope(Object object) {
        this.stopWriteToBuffer();
    }

    public final ReplacedResponseChunk write(byte[] byArray, String string) {
        return this.write(string);
    }

    public final ReplacedResponseChunk write(String string, int n2, int n3) {
        if (string != null && this.writeAllowed()) {
            this.doWrite(string.getBytes(this.getCharset()), n2, n3);
        }
        return null;
    }

    public final ReplacedResponseChunk write(String string) {
        if (this.writeAllowed()) {
            String string2 = string == null ? "null" : string;
            byte[] byArray = string2.getBytes(this.getCharset());
            this.doWrite(byArray, 0, byArray.length);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(char[] cArray) {
        if (cArray != null) {
            this.write(cArray, 0, cArray.length);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(byte[] byArray) {
        if (byArray != null) {
            this.write(byArray, 0, byArray.length);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(char[] cArray, int n2, int n3) {
        this.doWriteWithAllowedCheck(cArray, n2, n3);
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(byte[] byArray, int n2, int n3) {
        if (this.writeAllowed()) {
            this.doWrite(byArray, n2, n3);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(byte by) {
        if (this.writeAllowed()) {
            this.doWrite(by);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(int n2) {
        this.write((byte)n2);
        return null;
    }

    public final ContrastReplacedResponseChunkModel print(String string, int n2, int n3) {
        this.write(string, n2, n3);
        return null;
    }

    public ContrastReplacedResponseChunkModel print(String string) {
        return this.write(string);
    }

    public final ContrastReplacedResponseChunkModel print(char[] cArray, int n2, int n3) {
        return this.write(cArray, n2, n3);
    }

    public final ContrastReplacedResponseChunkModel print(byte[] byArray, int n2, int n3) {
        return this.write(byArray, n2, n3);
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(char c2) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            String string = String.valueOf(c2);
            this.write(string);
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(short s2) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            String string = String.valueOf(s2);
            this.write(string);
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(int n2) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            String string = String.valueOf(n2);
            this.write(string);
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(long l2) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            String string = String.valueOf(l2);
            ReplacedResponseChunk replacedResponseChunk = this.write(string);
            scopeAggregator.leaveScope();
            return replacedResponseChunk;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(double d2) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            String string = String.valueOf(d2);
            ReplacedResponseChunk replacedResponseChunk = this.write(string);
            scopeAggregator.leaveScope();
            return replacedResponseChunk;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(float f2) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            String string = String.valueOf(f2);
            ReplacedResponseChunk replacedResponseChunk = this.write(string);
            scopeAggregator.leaveScope();
            return replacedResponseChunk;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(boolean bl2) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            String string = String.valueOf(bl2);
            ReplacedResponseChunk replacedResponseChunk = this.write(string);
            scopeAggregator.leaveScope();
            return replacedResponseChunk;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(Object object) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            String string = String.valueOf(object);
            ReplacedResponseChunk replacedResponseChunk = this.write(string);
            scopeAggregator.leaveScope();
            return replacedResponseChunk;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(char[] cArray) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            String string = String.valueOf(cArray);
            ReplacedResponseChunk replacedResponseChunk = this.write(string);
            scopeAggregator.leaveScope();
            return replacedResponseChunk;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    public final ContrastReplacedResponseChunkModel println(String string) {
        ReplacedResponseChunk replacedResponseChunk = this.write(string);
        this.write(ObjectShare.LINE_SEPARATOR);
        return replacedResponseChunk;
    }

    public ContrastReplacedResponseChunkModel println() {
        this.write(ObjectShare.LINE_SEPARATOR);
        return null;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(char c2) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            this.print(c2);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(short s2) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            this.print(s2);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(int n2) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            this.print(n2);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(long l2) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            this.print(l2);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(double d2) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            this.print(d2);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(float f2) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            this.print(f2);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(boolean bl2) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            this.print(bl2);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(Object object) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            this.print(object);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(char[] cArray) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            this.print(cArray);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    private void doWriteWithAllowedCheck(char[] cArray, int n2, int n3) {
        if (cArray == null || !this.writeAllowed()) {
            return;
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            this.doWrite((byte)cArray[i2]);
        }
    }

    @ScopedSensor
    private void doWrite(byte by) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            this.doWriteToBuffer(this.memoryBufferPool, by);
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    private void doWrite(byte[] byArray, int n2, int n3) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            this.doWriteToBuffer(this.memoryBufferPool, byArray, n2, n3, n3);
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }
}

