/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.http.MemoryBuffer;
import com.contrastsecurity.agent.http.b;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.pool.ObjectPool;
import com.contrastsecurity.agent.pool.Poolable;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;

public abstract class c {
    private final b breadCrumbs;
    private int scope;
    private boolean capturingInMemory;
    private Poolable<MemoryBuffer> bufferPoolable;
    private int maxBufferSize = 256;
    private boolean overflowed;
    @n
    static final int INITIAL_BLOCK_SIZE = 256;
    private static final int TARGET_SCOPE = 1;
    private static final int MEMORY_BUFFER_POOLABLE_TIMEOUT = 250;
    private static final Logger logger = LoggerFactory.getLogger(c.class);

    c(String string) {
        this.breadCrumbs = this.shouldCreateBreadCrumbs() ? new b(string) : null;
    }

    public void enableCapturing() {
        this.capturingInMemory = true;
    }

    public void disableCapturing() {
        this.capturingInMemory = false;
    }

    public void startWriteToBuffer() {
        ++this.scope;
    }

    public void stopWriteToBuffer() {
        --this.scope;
    }

    @n
    boolean isCapturingEnabled() {
        return this.capturingInMemory;
    }

    @n
    protected boolean shouldCreateBreadCrumbs() {
        return logger.isDebugEnabled();
    }

    public final int getBufferSize() {
        return this.bufferPoolable == null ? 0 : this.bufferPoolable.get().size();
    }

    public final boolean isBufferEmpty() {
        return this.bufferPoolable == null || this.bufferPoolable.get().isEmpty();
    }

    public void maxBufferSize(int n2) {
        if (n2 > 0) {
            this.maxBufferSize = n2;
        }
    }

    protected final int maxBufferSize() {
        return this.maxBufferSize;
    }

    public final void closeBuffer() {
        if (this.bufferPoolable == null) {
            return;
        }
        try {
            this.bufferPoolable.close();
        }
        catch (InterruptedException interruptedException) {
            logger.debug("Unable to close the MemoryBuffer Poolable and return it to the Queue", interruptedException);
        }
        this.bufferPoolable = null;
        this.overflowed = false;
    }

    public void updateBreadCrumbs(b.b b2) {
        if (this.breadCrumbs == null) {
            return;
        }
        try {
            this.breadCrumbs.a(b2, this.getAdditionalBreadCrumbInfo());
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.error("Problem updating HTTP crumbs", exception2);
        }
    }

    public String getBufferAsString() {
        return this.bufferPoolable == null ? "" : this.bufferPoolable.get().toString(this.getCharset());
    }

    public InputStream getBufferAsStream() {
        return this.bufferPoolable == null ? Empty.EMPTY_INPUT_STREAM : this.bufferPoolable.get().getInputStream();
    }

    protected abstract Charset getCharset();

    final boolean writeToBuffer(ObjectPool<MemoryBuffer> objectPool, int n2) {
        if (this.writeAllowed()) {
            return this.doWriteToBuffer(objectPool, n2);
        }
        return false;
    }

    final boolean writeToBuffer(ObjectPool<MemoryBuffer> objectPool, byte[] byArray, int n2, int n3, int n4) {
        if (!this.writeAllowed()) {
            return false;
        }
        return this.doWriteToBuffer(objectPool, byArray, n2, n3, n4);
    }

    final boolean doWriteToBuffer(ObjectPool<MemoryBuffer> objectPool, int n2) {
        MemoryBuffer memoryBuffer = this.getMemoryBuffer(objectPool);
        if (!this.bufferHasCapacity(memoryBuffer, 1)) {
            return false;
        }
        try {
            memoryBuffer.write(n2);
            return true;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.debug("There was a problem writing the data to the buffer", throwable2);
            return false;
        }
    }

    final boolean doWriteToBuffer(ObjectPool<MemoryBuffer> objectPool, byte[] byArray, int n2, int n3, int n4) {
        if (byArray == null || n2 < 0 || n3 < 0 && n4 != -1) {
            return false;
        }
        MemoryBuffer memoryBuffer = this.getMemoryBuffer(objectPool);
        if (!this.bufferHasCapacity(memoryBuffer, n4)) {
            return false;
        }
        int n5 = Math.min(n4, this.maxBufferSize() - this.getBufferSize());
        try {
            memoryBuffer.write(byArray, n2, n5);
            return true;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.error("There was a problem writing the data to the buffer", throwable2);
            return false;
        }
    }

    protected final boolean hasOverflowed() {
        return this.overflowed;
    }

    @n
    b getBreadCrumbs() {
        return this.breadCrumbs;
    }

    protected String getAdditionalBreadCrumbInfo() {
        return "";
    }

    private boolean bufferHasCapacity(MemoryBuffer memoryBuffer, int n2) {
        int n3;
        int n4 = memoryBuffer.size();
        boolean bl2 = n4 < (n3 = this.maxBufferSize()) && !this.overflowed;
        this.overflowed = n4 + n2 > n3;
        return bl2;
    }

    boolean writeAllowed() {
        return this.capturingInMemory && this.scope == 1;
    }

    private MemoryBuffer getMemoryBuffer(ObjectPool<MemoryBuffer> objectPool) {
        if (this.bufferPoolable == null) {
            this.bufferPoolable = objectPool.borrowObject(250L, TimeUnit.MILLISECONDS);
        }
        return this.bufferPoolable.get();
    }
}

