/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.grpc.assess;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.plugins.frameworks.antlr.g;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.c.a;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.controller.propagate.c;
import com.contrastsecurity.agent.plugins.security.model.PropagationEvent;
import com.contrastsecurity.agent.plugins.security.model.f;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicyManager;
import com.contrastsecurity.agent.plugins.security.policy.Location;
import com.contrastsecurity.agent.plugins.security.policy.propagators.Propagator;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.agent.scope.ScopeProviderAssess;
import com.contrastsecurity.agent.stack.i;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.TagRange;
import com.contrastsecurity.agent.trace.TagRanges;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.trace.d;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;

@Singleton
@DontObfuscate
final class ContrastGrpcAssessDispatcherImpl
implements ContrastGrpcAssessDispatcher {
    private final AssessmentManager assessmentManager;
    private final com.contrastsecurity.agent.plugins.security.model.c codeEventFactory;
    private final a debugStringFactory;
    private final EventContext eventContext;
    private final ScopeProviderAssess scopeProvider;
    private final i stackCaptureFactory;
    private final d traceFactory;
    private final Propagator copyToInternal;
    private final Propagator readFrom;
    private final Propagator onWrite;
    private static final MethodDescription COPY_TO_INTERNAL_MD = new MethodDescription("com.google.protobuf.ByteString", "copyToInternal", "([BIII)V", 0);
    private static final MethodDescription WRITE_MD = new MethodDescription("com.google.protobuf.ByteString$Output", "write", "([BII)V", 0);
    private static final MethodDescription READ_FROM_MD = new MethodDescription("com.google.protobuf.ByteString", "readFrom", "(Ljava/io/InputStream;II)Lcom/google/protobuf/ByteString;", 0);
    private static final Logger logger = LoggerFactory.getLogger(ContrastGrpcAssessDispatcherImpl.class);

    public ContrastGrpcAssessDispatcherImpl(AssessmentManager assessmentManager, com.contrastsecurity.agent.plugins.security.model.c c2, ContrastPolicyManager contrastPolicyManager, a a2, EventContext eventContext, ScopeProviderAssess scopeProviderAssess, i i2, d d2) {
        this.assessmentManager = assessmentManager;
        this.codeEventFactory = c2;
        this.debugStringFactory = a2;
        this.eventContext = eventContext;
        this.scopeProvider = scopeProviderAssess;
        this.stackCaptureFactory = i2;
        this.traceFactory = d2;
        ContrastPolicy contrastPolicy = contrastPolicyManager.currentPolicy();
        Propagator propagator = new Propagator(contrastPolicy.getId(), contrastPolicy.getLocation(), "zzz-grpc-copyToInternal", Location.COMMON_P1, Location.COMMON_R, null, null, null, null, false, false, new g());
        contrastPolicyManager.addPropagator(propagator);
        this.copyToInternal = propagator;
        Propagator propagator2 = new Propagator(contrastPolicy.getId(), contrastPolicy.getLocation(), "zzz-grpc-readFrom", Location.COMMON_P1, Location.COMMON_R, null, null, null, null, false, false, new g());
        contrastPolicyManager.addPropagator(propagator2);
        this.onWrite = propagator2;
        Propagator propagator3 = new Propagator(contrastPolicy.getId(), contrastPolicy.getLocation(), "zzz-grpc-readFrom", Location.COMMON_P1, Location.COMMON_R, null, null, null, null, false, false, new g());
        contrastPolicyManager.addPropagator(propagator3);
        this.readFrom = propagator3;
    }

    public void onCopyInternal(Object object2, byte[] byArray, int n2, int n3, int n4) {
        if (object2 == null) {
            return;
        }
        byte[] byArray2 = Reflect.reflect(object2, logger).field("bytes").asNullable(byte[].class);
        if (byArray2 == null || byArray2.length == 0) {
            return;
        }
        if (byArray == null || byArray.length == 0 || n4 <= 0 || n2 < 0 || n3 < 0) {
            return;
        }
        if (this.inMasterOrSamplingScope()) {
            return;
        }
        AssessmentContext assessmentContext = this.assessmentManager.currentContext();
        Map<Object, Trace> map = this.eventContext.getTraceMap(assessmentContext);
        Trace trace = map.get(byArray2);
        if (trace == null) {
            return;
        }
        Trace trace2 = map.computeIfAbsent(byArray, object -> this.traceFactory.a());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(trace.getLastEvent().getId());
        if (trace2.getLastEvent() != null) {
            arrayList.add(trace2.getLastEvent().getId());
        }
        TagRanges tagRanges = trace.getTagRanges().copy();
        TagRanges tagRanges2 = trace2.getTagRanges().copy();
        tagRanges.shift(n3);
        tagRanges2.clear(n3, n3 + n4);
        ArrayList<TagRange> arrayList2 = new ArrayList<TagRange>();
        arrayList2.addAll(tagRanges.getTagRanges());
        arrayList2.addAll(tagRanges2.getTagRanges());
        f f2 = (f)((f)((f)((f)((f)((f)((f)((f)this.codeEventFactory.b(this.copyToInternal).b(trace2.getId())).a(COPY_TO_INTERNAL_MD)).a((Object)byArray)).b((Object)null)).a(arrayList)).a(new TagRanges(arrayList2))).a(this.stackCaptureFactory.a(i.a.b))).a(new Object[]{byArray, n2, n3, n4});
        PropagationEvent propagationEvent = f2.g();
        trace2.addEvent(propagationEvent);
        map.put(byArray, trace2);
        if (logger.isDebugEnabled()) {
            logger.debug(this.debugStringFactory.a(propagationEvent, "TRACE "));
        }
        if (assessmentContext == null || !assessmentContext.isIdentityTaggingEnabled()) {
            return;
        }
        c.a(object2, trace2, trace, assessmentContext);
    }

    public void onWrite(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        if (byArray == null || byArray2 == null || n2 < 0 || n3 < 0 || n4 < 0) {
            return;
        }
        if (this.inMasterOrSamplingScope()) {
            return;
        }
        AssessmentContext assessmentContext = this.assessmentManager.currentContext();
        Map<Object, Trace> map = this.eventContext.getTraceMap(assessmentContext);
        Trace trace = map.get(byArray2);
        if (trace == null) {
            return;
        }
        Trace trace2 = map.computeIfAbsent(byArray, object -> this.traceFactory.a());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(trace.getLastEvent().getId());
        if (trace2.getLastEvent() != null) {
            arrayList.add(trace2.getLastEvent().getId());
        }
        TagRanges tagRanges = trace.getTagRanges().copy();
        TagRanges tagRanges2 = trace2.getTagRanges().copy();
        tagRanges.shift(n2);
        tagRanges2.clear(n2, n2 + n4);
        ArrayList<TagRange> arrayList2 = new ArrayList<TagRange>();
        arrayList2.addAll(tagRanges.getTagRanges());
        arrayList2.addAll(tagRanges2.getTagRanges());
        f f2 = (f)((f)((f)((f)((f)((f)((f)((f)this.codeEventFactory.b(this.onWrite).b(trace2.getId())).a(WRITE_MD)).a((Object)byArray)).b((Object)null)).a(arrayList)).a(new TagRanges(arrayList2))).a(this.stackCaptureFactory.a(i.a.b))).a(new Object[]{byArray2, n3, n4});
        PropagationEvent propagationEvent = f2.g();
        trace2.addEvent(propagationEvent);
        map.put(byArray, trace2);
        if (logger.isDebugEnabled()) {
            logger.debug(this.debugStringFactory.a(propagationEvent, "TRACE "));
        }
        if (assessmentContext == null || !assessmentContext.isIdentityTaggingEnabled()) {
            return;
        }
        c.a(byArray, trace2, trace, assessmentContext);
    }

    public void onReadFrom(Object object2, InputStream inputStream, int n2, int n3) {
        if (object2 == null || inputStream == null || n2 <= 0 || n3 <= 0) {
            return;
        }
        if (this.inMasterOrSamplingScope()) {
            return;
        }
        byte[] byArray = Reflect.reflect(object2, logger).field("bytes").asNullable(byte[].class);
        if (byArray == null || byArray.length == 0) {
            return;
        }
        AssessmentContext assessmentContext = this.assessmentManager.currentContext();
        Map<Object, Trace> map = this.eventContext.getTraceMap(assessmentContext);
        Trace trace = map.get(inputStream);
        if (trace == null) {
            return;
        }
        Trace trace2 = map.computeIfAbsent(byArray, object -> this.traceFactory.a());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(trace.getLastEvent().getId());
        if (trace2.getLastEvent() != null) {
            arrayList.add(trace2.getLastEvent().getId());
        }
        f f2 = (f)((f)((f)((f)((f)((f)((f)((f)this.codeEventFactory.b(this.readFrom).b(trace2.getId())).a(READ_FROM_MD)).a((Object)byArray)).b((Object)null)).a(arrayList)).a(trace.getTagRanges().copy())).a(this.stackCaptureFactory.a(i.a.b))).a(new Object[]{inputStream, n2, n3});
        PropagationEvent propagationEvent = f2.g();
        trace2.addEvent(propagationEvent);
        map.put(byArray, trace2);
        if (logger.isDebugEnabled()) {
            logger.debug(this.debugStringFactory.a(propagationEvent, "TRACE "));
        }
        if (assessmentContext == null || !assessmentContext.isIdentityTaggingEnabled()) {
            return;
        }
        c.a(object2, trace2, trace, assessmentContext);
    }

    private boolean inMasterOrSamplingScope() {
        return this.scopeProvider.isEnabled() && this.scopeProvider.scope().inMasterOrSamplingScope();
    }
}

