/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.j2ee;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.l;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Singleton
@DontObfuscate
public class J2EEClassCache {
    private final boolean enableClassCaching;
    private final Map<Class<?>, Method> characterEncodingMap;
    private final Map<Class<?>, Method> sessionMap;
    private final Map<Class<?>, Method> sessionGetAttributeMap;
    private final Map<Class<?>, Method> sessionSetAttributeMap;
    final a sessionGetMaxInactiveIntervalCache;
    final a sessionGetServletContextCache;
    private final Map<Class<?>, Method> requestGetHeadersMap;
    private final Map<Class<?>, Method> servletContextGetServerInfoMap;
    final a servletContextGetResourceAsStreamCache;
    private final Map<Class<?>, Method> statusMap;
    private final Map<Class<?>, Method> servletContextMap;
    private final Map<Class<?>, Method> parameterMapMap;
    private final Map<Class<?>, Field> innerResponseFieldMap;
    private final Map<Class<?>, Boolean> nonGetStatusResponseClassMap;
    private static final Logger logger = LoggerFactory.getLogger(J2EEClassCache.class);
    private static final Class<?>[] SET_ATTRIBUTE_ARGS = new Class[]{String.class, Object.class};

    static Class<?> servletContextClass(Class<?> clazz) {
        try {
            return l.a("javax.servlet.ServletContext", true, l.b(clazz));
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return l.a("jakarta.servlet.ServletContext", true, l.b(clazz));
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
    }

    public J2EEClassCache(e e2) {
        this.enableClassCaching = Objects.requireNonNull(e2).getBoolean(ConfigProperty.J2EE_CLASSCACHE);
        this.statusMap = new ConcurrentHashMap();
        this.sessionMap = new ConcurrentHashMap();
        this.sessionGetAttributeMap = new ConcurrentHashMap();
        this.sessionSetAttributeMap = new ConcurrentHashMap();
        this.sessionGetMaxInactiveIntervalCache = new b(this.enableClassCaching){

            @Override
            Method a(Class<?> clazz) {
                Method method = com.contrastsecurity.agent.reflection.a.b(clazz, "getMaxInactiveInterval", new Class[0]);
                if (method != null && !Modifier.isStatic(method.getModifiers()) && Integer.TYPE.equals(method.getReturnType())) {
                    return method;
                }
                return null;
            }
        };
        this.sessionGetServletContextCache = new b(this.enableClassCaching){

            @Override
            Method a(Class<?> clazz) {
                Method method = com.contrastsecurity.agent.reflection.a.b(clazz, "getServletContext", new Class[0]);
                if (method != null && !Modifier.isStatic(method.getModifiers()) && J2EEClassCache.servletContextClass(clazz).isAssignableFrom(method.getReturnType())) {
                    return method;
                }
                return null;
            }
        };
        this.servletContextMap = new ConcurrentHashMap();
        this.characterEncodingMap = new ConcurrentHashMap();
        this.parameterMapMap = new ConcurrentHashMap();
        this.requestGetHeadersMap = new ConcurrentHashMap();
        this.servletContextGetServerInfoMap = new ConcurrentHashMap();
        this.servletContextGetResourceAsStreamCache = new b(this.enableClassCaching){

            @Override
            Method a(Class<?> clazz) {
                Method method = com.contrastsecurity.agent.reflection.a.b(clazz, "getResourceAsStream", ObjectShare.SINGLE_STRING_ARRAY);
                if (method != null && !Modifier.isStatic(method.getModifiers()) && InputStream.class.isAssignableFrom(method.getReturnType())) {
                    return method;
                }
                return null;
            }
        };
        this.nonGetStatusResponseClassMap = new ConcurrentHashMap();
        this.innerResponseFieldMap = new ConcurrentHashMap();
    }

    public Method getCharacterEncodingMethod(Class<?> clazz) throws Exception {
        Method method = null;
        if (!this.enableClassCaching) {
            method = this.lookupCharacterEncodingMethod(clazz);
        } else {
            method = this.characterEncodingMap.get(clazz);
            if (method == null && (method = this.lookupCharacterEncodingMethod(clazz)) != null) {
                this.characterEncodingMap.put(clazz, method);
            }
        }
        return method;
    }

    public Method getSessionMethod(Class<?> clazz) throws Exception {
        Method method = null;
        if (!this.enableClassCaching) {
            method = this.lookupSessionMethod(clazz);
        } else {
            method = this.sessionMap.get(clazz);
            if (method == null && (method = this.lookupSessionMethod(clazz)) != null) {
                this.sessionMap.put(clazz, method);
            }
        }
        return method;
    }

    public Method getParameterMapMethod(Class<?> clazz) throws Exception {
        Method method = null;
        if (!this.enableClassCaching) {
            method = this.lookupParameterMapMethod(clazz);
        } else {
            method = this.parameterMapMap.get(clazz);
            if (method == null && (method = this.lookupParameterMapMethod(clazz)) != null) {
                this.parameterMapMap.put(clazz, method);
            }
        }
        return method;
    }

    public Method getStatusMethod(Class<?> clazz) throws Exception {
        Method method = null;
        if (!this.nonGetStatusResponseClassMap.containsKey(clazz)) {
            if (!this.enableClassCaching) {
                method = this.lookupStatusMethod(clazz);
            } else {
                method = this.statusMap.get(clazz);
                if (method == null) {
                    try {
                        method = this.lookupStatusMethod(clazz);
                        this.statusMap.put(clazz, method);
                    }
                    catch (Throwable throwable) {
                        Throwables.throwIfCritical(throwable);
                        Throwable throwable2 = throwable;
                        this.nonGetStatusResponseClassMap.put(clazz, Boolean.TRUE);
                    }
                }
            }
        }
        return method;
    }

    public int getWrappedStatus(Object object) {
        int n2 = 200;
        Class<?> clazz = object.getClass();
        try {
            Field field = this.getInnerResponseField(clazz);
            Object object2 = field.get(object);
            if (object2 != null) {
                Method method = this.getStatusMethod(object2.getClass());
                n2 = (Integer)method.invoke(object2, Empty.OBJ_ARRAY);
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            this.nonGetStatusResponseClassMap.put(clazz, Boolean.TRUE);
        }
        return n2;
    }

    private Field getInnerResponseField(Class<?> clazz) {
        Field field = this.innerResponseFieldMap.get(clazz);
        if (field == null) {
            try {
                field = com.contrastsecurity.agent.reflection.a.d(clazz, "response");
                this.innerResponseFieldMap.put(clazz, field);
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
            }
        }
        return field;
    }

    public Method getSerlvetContextMethod(Class<?> clazz) throws Exception {
        Method method = null;
        if (!this.enableClassCaching) {
            method = this.lookupServletContextMethod(clazz);
        } else {
            method = this.servletContextMap.get(clazz);
            if (method == null && (method = this.lookupServletContextMethod(clazz)) != null) {
                this.servletContextMap.put(clazz, method);
            }
        }
        return method;
    }

    public Method getGetSessionAttributeMethod(Class<?> clazz) {
        Method method = null;
        if (!this.enableClassCaching) {
            method = this.lookupGetSessionAttributeMethod(clazz);
        } else {
            method = this.sessionGetAttributeMap.get(clazz);
            if (method == null && (method = this.lookupGetSessionAttributeMethod(clazz)) != null) {
                this.sessionGetAttributeMap.put(clazz, method);
            }
        }
        return method;
    }

    public Method getSetSessionAttributeMethod(Class<?> clazz) {
        Method method = null;
        if (!this.enableClassCaching) {
            method = this.lookupSetSessionAttributeMethod(clazz);
        } else {
            method = this.sessionSetAttributeMap.get(clazz);
            if (method == null && (method = this.lookupSetSessionAttributeMethod(clazz)) != null) {
                this.sessionSetAttributeMap.put(clazz, method);
            }
        }
        return method;
    }

    public Method getGetHeadersMethod(Class<?> clazz) {
        Method method = null;
        if (!this.enableClassCaching) {
            method = this.lookupGetHeadersMethod(clazz);
        } else {
            method = this.requestGetHeadersMap.get(clazz);
            if (method == null && (method = this.lookupGetHeadersMethod(clazz)) != null) {
                this.requestGetHeadersMap.put(clazz, method);
            }
        }
        return method;
    }

    public Method getGetServerInfoMethod(Class<?> clazz) {
        Method method = null;
        if (!this.enableClassCaching) {
            method = this.lookupGetServerInfoMethod(clazz);
        } else {
            method = this.servletContextGetServerInfoMap.get(clazz);
            if (method == null && (method = this.lookupGetServerInfoMethod(clazz)) != null) {
                this.servletContextGetServerInfoMap.put(clazz, method);
            }
        }
        return method;
    }

    private Method lookupServletContextMethod(Class<?> clazz) throws Exception {
        return com.contrastsecurity.agent.reflection.a.f(clazz, "getServletContext");
    }

    private Method lookupSessionMethod(Class<?> clazz) throws Exception {
        return com.contrastsecurity.agent.reflection.a.c(clazz, "getSession", ObjectShare.SINGLE_BOOLEAN_ARRAY);
    }

    private Method lookupStatusMethod(Class<?> clazz) throws Exception {
        return com.contrastsecurity.agent.reflection.a.f(clazz, "getStatus");
    }

    private Method lookupCharacterEncodingMethod(Class<?> clazz) throws Exception {
        return com.contrastsecurity.agent.reflection.a.f(clazz, "getCharacterEncoding");
    }

    private Method lookupParameterMapMethod(Class<?> clazz) throws Exception {
        return com.contrastsecurity.agent.reflection.a.f(clazz, "getParameterMap");
    }

    private Method lookupGetSessionAttributeMethod(Class<?> clazz) {
        Method method = null;
        try {
            method = com.contrastsecurity.agent.reflection.a.c(clazz, "getAttribute", ObjectShare.SINGLE_STRING_ARRAY);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.debug("Couldn't find session#getAttribute()", throwable2);
        }
        return method;
    }

    private Method lookupSetSessionAttributeMethod(Class<?> clazz) {
        Method method = null;
        try {
            method = com.contrastsecurity.agent.reflection.a.c(clazz, "setAttribute", SET_ATTRIBUTE_ARGS);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.debug("Couldn't find session#setAttribute()", throwable2);
        }
        return method;
    }

    private Method lookupGetHeadersMethod(Class<?> clazz) {
        Method method = null;
        try {
            method = com.contrastsecurity.agent.reflection.a.c(clazz, "getHeaders", ObjectShare.SINGLE_STRING_ARRAY);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.debug("Couldn't find HttpServletRequest#getHeaders()", throwable2);
        }
        return method;
    }

    private Method lookupGetServerInfoMethod(Class<?> clazz) {
        Method method = null;
        try {
            method = com.contrastsecurity.agent.reflection.a.f(clazz, "getServerInfo");
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.debug("Couldn't find ServletContext#getServerInfo()", throwable2);
        }
        return method;
    }

    private static abstract class b
    extends a {
        private final boolean a;
        private final ConcurrentMap<Class<?>, Method> b;

        private b(boolean bl2) {
            this.a = bl2;
            this.b = new ConcurrentHashMap();
        }

        @Override
        final Method b(Class<?> clazz) {
            if (!this.a) {
                return this.a(clazz);
            }
            Method method = (Method)this.b.get(clazz);
            if (ObjectShare.METHOD_NOT_FOUND == method) {
                return null;
            }
            if (method != null) {
                return method;
            }
            Method method2 = this.a(clazz);
            method = this.b.putIfAbsent(clazz, method2 != null ? method2 : ObjectShare.METHOD_NOT_FOUND);
            if (ObjectShare.METHOD_NOT_FOUND == method) {
                return null;
            }
            return method != null ? method : method2;
        }

        abstract Method a(Class<?> var1);
    }

    static abstract class a {
        a() {
        }

        abstract Method b(Class<?> var1);
    }
}

