/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.j2ee.app;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.InventoryException;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.i;
import com.contrastsecurity.thirdparty.org.apache.commons.io.IOUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

@DontObfuscate
public abstract class ServletAppProfiler {
    private static final String CROSS_DOMAIN_XML = "crossdomain.xml";
    protected static final String FACES_CONFIG_FILE = "faces-config.xml";
    protected static final Logger logger = LoggerFactory.getLogger(ServletAppProfiler.class);

    protected abstract Application getApplication();

    protected abstract i getPluginManager();

    public abstract void profile(Application var1) throws InventoryException;

    private static boolean isCrossDomainXml(String string) {
        return CROSS_DOMAIN_XML.equals(string);
    }

    private static boolean isBootstrapCSS(String string) {
        return string.startsWith("bootstrap.") && string.endsWith(".css");
    }

    private static boolean isFlash(String string) {
        return string.endsWith(".swf");
    }

    private static boolean isHtml(String string) {
        return string.endsWith(".html") || string.endsWith(".htm");
    }

    private static boolean isJsp(String string) {
        return string.endsWith(".jsp") || string.endsWith(".jspx");
    }

    private static boolean isJavaApplet(String string) {
        return string.endsWith(".class") || string.endsWith(".jar");
    }

    private static boolean isJavaScript(String string) {
        return string.endsWith(".js");
    }

    private void processJavaScriptFileName(String string) {
        Application application = this.getApplication();
        String string2 = string.toLowerCase();
        if (string2.startsWith("jquery")) {
            application.addTechnology("jQuery");
        } else if (string2.startsWith("backbone")) {
            application.addTechnology("Backbone");
        } else if (string2.startsWith("dojo")) {
            application.addTechnology("Dojo");
        } else if (string2.startsWith("yui")) {
            application.addTechnology("YUI!");
        }
    }

    <T> void processWebResource(String string, T t2, a<T> a2, boolean bl2) {
        string = StringUtils.defaultIfEmpty(StringUtils.substringAfterLast(StringUtils.trim(string), "/"), string);
        Application application = this.getApplication();
        if (ServletAppProfiler.isFlash(string)) {
            logger.debug("Added Flash to technology list");
            application.addTechnology("Flash");
        } else if (ServletAppProfiler.isBootstrapCSS(string)) {
            application.addTechnology("Bootstrap");
        } else if (ServletAppProfiler.isHtml(string)) {
            application.addTechnology("HTML5");
        } else if (ServletAppProfiler.isJavaScript(string)) {
            application.addTechnology("HTML5");
            this.processJavaScriptFileName(string);
        } else if (ServletAppProfiler.isJsp(string)) {
            application.addTechnology("HTML5");
            application.addTechnology("JSP");
        } else if (!bl2 && ServletAppProfiler.isJavaApplet(string)) {
            application.addTechnology("Applet");
        } else if (bl2 && string.endsWith(FACES_CONFIG_FILE)) {
            application.addTechnology("JSF");
        } else if (ServletAppProfiler.isCrossDomainXml(string)) {
            this.processCrossDomainFile(t2, a2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> void processCrossDomainFile(T t2, a<T> a2) {
        Application application = this.getApplication();
        try {
            InputStream inputStream = a2.create(t2);
            try {
                String string = IOUtils.toString(inputStream, Charset.defaultCharset());
                for (ContrastPlugin contrastPlugin : this.getPluginManager().getPlugins()) {
                    contrastPlugin.onCrossDomainXmlRead(application, string);
                }
                if (inputStream == null) return;
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                if (inputStream == null) throw throwable2;
                try {
                    inputStream.close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    Throwables.throwIfCritical(throwable3);
                    Throwable throwable4 = throwable3;
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            inputStream.close();
            return;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable5 = throwable;
            logger.debug("Problem context scanning crossdomain.xml for app {}", (Object)application, (Object)throwable5);
        }
    }

    static interface a<T> {
        public InputStream create(T var1) throws IOException;
    }
}

