/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.mongo;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.plugins.architecture.controller.ArchitectureComponentReporter;
import com.contrastsecurity.agent.plugins.architecture.model.ArchitectureComponent;
import com.contrastsecurity.agent.plugins.architecture.util.ArchitectureScope;
import com.contrastsecurity.agent.plugins.frameworks.mongo.b;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

@Singleton
@DontObfuscate
public final class ContrastMongoQueryDispatcherImpl
implements ContrastMongoQueryDispatcher {
    private final e config;
    private final ApplicationManager applicationManager;
    private final ArchitectureComponentReporter architectureComponentReporter;
    private final ScopeProvider scopeProvider;
    private final b mongoArchitectureComponentFactory;
    private final ExecutionContext.b<a> detectedDatabasesKey = ExecutionContext.b.a(a.class);
    private static final Logger logger = LoggerFactory.getLogger(ContrastMongoQueryDispatcherImpl.class);

    public ContrastMongoQueryDispatcherImpl(e e2, ApplicationManager applicationManager, ArchitectureComponentReporter architectureComponentReporter, ScopeProvider scopeProvider, b b2) {
        this.config = e2;
        this.applicationManager = applicationManager;
        this.architectureComponentReporter = architectureComponentReporter;
        this.scopeProvider = scopeProvider;
        this.mongoArchitectureComponentFactory = b2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMongoQuery(Object object, String string) {
        if (!com.contrastsecurity.agent.apps.e.a(this.config, ConfigProperty.DBINSPECTION)) {
            return;
        }
        Application application = this.applicationManager.current();
        if (application == null) {
            return;
        }
        Set set = application.context().getOrComputeIfAbsent(this.detectedDatabasesKey, a.a).b;
        if (set.contains(string)) {
            return;
        }
        ScopeAggregator scopeAggregator = this.scopeProvider.enterScope();
        ArchitectureScope.getTrackerScope().enterScope();
        try {
            ArchitectureComponent architectureComponent = this.mongoArchitectureComponentFactory.a(object, string);
            if (architectureComponent != null) {
                set.add(string);
                this.architectureComponentReporter.report(application, architectureComponent);
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.debug("Failed to add Mongo architecture component", throwable2);
        }
        finally {
            scopeAggregator.leaveScope();
            ArchitectureScope.getTrackerScope().leaveScope();
        }
    }

    private static final class a {
        private static final Supplier<a> a = a::new;
        private final Set<String> b = Collections.synchronizedSet(new HashSet());

        private a() {
        }
    }
}

